#ifndef _font_h_
#define _font_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik

// Modified:  R. Sampath, Dec 1994



// The Font class represents a single font of the underlying windowing
// system, together with point size, type style and other attributes. An
// instance of this class cannot be created independently; it can only be
// created by the VisualObject and DrawingSurface classes. Every Font
// instance is owned by a corresponding VisualObject or DrawingSurface
// instance.



#include "base/string.h"
#include "base/sequence.h"

#include "ui/dsplrsrc.h"
#include "ui/fontdesc.h"


#if defined(__MS_WINDOWS__)
typedef ulong UI_NativeFontRep;

// Definitions of three common font names:
#define UIFont_Times      "Times New Roman"
#define UIFont_Courier    "Courier"
#define UIFont_Helvetica  "Arial"

#elif defined (__X_MOTIF__)
typedef CL_String UI_NativeFontRep;

// Definitions of three common font names:
#define UIFont_Times      "times"
#define UIFont_Courier    "courier"
#define UIFont_Helvetica  "helvetica"

#elif defined (__OS2__)
typedef ulong UI_NativeFontRep;

// Definitions of three common font names:
#define UIFont_Times      "Times New Roman"
#define UIFont_Courier    "Courier"
#define UIFont_Helvetica  "Helvetica"

#endif

class UI_VisualObject;

class UI_Font: public UI_DisplayResource {

public:

    long Height () const;
    // Return the height of each character, in pixels.

    long Width  () const;
    // Return the average width of a character, in pixels.

    long Width (const char* string) const;
    // Return the width, in pixels, of the box containing {\tt string}, if
    // it were to be drawn on the DrawingSurface that owns this Font.
    
    short PointSize() const;
    // Return the point size of this font.

    CL_String TypeFace() const;
    // Return the name of the type face.

    bool IsFixed () const;
    // Return whether this is a fixed-width font (i.e., all characters have
    // the same width).

    ulong Style () const {return _style; };
    // Return the style parameters for this Font.
    
    
    bool Italic() const;
    // Return whether this is an italic font.

    bool Underline() const;
    // Return whether this font has the underline attribute.

    bool BoldFace() const;
    // Return whether this is a boldface font.

    bool StrikeOut() const;
    // Return whether this font has the strike-out attribute.

    short Ascent ()  const;
    // Return the ascent of this font, in pixels.

    short Descent () const;
    // Return the descent of this font, in pixels.

    bool IsScalable () const;
    // Return whether this font is scalable to arbitrary point sizes.
    
    void PointSize (short ptSize);
    // Set the point size of this font to the given size.

    void TypeFace  (const char* new_type_face);
    // Set the type face name of this font.

    void Italic    (bool );
    // Set the italic attribute for this font.

    void Underline (bool );
    // Set the underline attribute for this font.

    void BoldFace  (bool );
    // Set the boldface attribute for this font.

    void StrikeOut (bool );
    // Set the strike-out attribute for this font.

    void operator= (const UI_FontDesc& desc);
    // Modify this Font according to the contents of the given descriptor.

    void operator= (const CL_Object& o);
    // The parameter is required to be of type {\tt UI_FontDesc}. This
    // method is provided so that the virtual assignment operator does not
    // become hidden.

#if defined(__X_MOTIF__)
    void operator= (const char* native_name);
    // [X-windows-specific] Use the font whose fully-qualified name is
    // {\tt native_name}.

#endif
    
    static const CL_Sequence<UI_FontInfo>& AvailableFonts ();
    // Return a reference to a sequence containing all available fonts.
    
    const char* ClassName() const { return "UI_Font";};
    // Override the method inherited from {\small\tt CL_Object}.

protected:

    void    _Setup ();
    // This method is called when any of the Font's attributes changes. It
    // sets up the new font handle.

#if defined(__MS_WINDOWS__) || defined(__X_MOTIF__)
    void    _Setup (UI_NativeFontRep nativename);
    
#endif

    short             _ptSize;
    CL_String         _typeFace;
    UI_NativeFontRep  _nativeName;
    ulong             _style;
    bool              _stockFont;
    long              _height;
    long              _width;

    void* _entry;

    static CL_Sequence<UI_FontInfo> _allFonts;

#if defined(__MS_WINDOWS__)
private:
    static long _ppi; // Pixels per inch: used during font enumeration
#endif
    
public:
#if defined(__MS_WINDOWS__)
    static void _AddFont (void*, void*, int);
    // [MS-Windows-specific; YACL internal use only]

#elif defined(__X_MOTIF__)
    long TextWidth (const CL_String& s) const;
    // [X-windows-specific; YACL internal use only]

#endif

    void*  NativeFontStruct () const;
    // [YACL internal use only]
    
    UI_Font (UI_VisualObject* client = NULL);
    // [Internal use only] Create the platform's default font for the given
    // client, if any.

    UI_Font (const CL_String& typeface, short ptSize, ulong style = 0);
    // [Internal use only] Create a font with the given attributes. The last
    // parameter is a disjunction of {\tt UIFont_Style} elements.
    
    UI_Font (const UI_Font&);
    // [Internal use only] Copy constructor.

    ~UI_Font ();
    // [Internal use only] Destructor.

    void UseClient (UI_DrawingSurface* sfc);
    // [Internal use only]
    
};




#endif



