

#ifndef _fontdesc_h_ /* Thu Dec 29 10:03:04 1994 */
#define _fontdesc_h_

#include "base/string.h"

enum UIFont_Style {UIFont_Italic    = 1,
                   UIFont_Underline = 2,
                   UIFont_BoldFace  = 4,
                   UIFont_StrikeOut = 8
               };


// A FontDesc object is a ``font descriptor'' that an application program
// can use to describe a font. The platform does not guarantee that a font
// described by a FontDesc exists; the application must use the FontInfo
// object to obtain information about the actual font.

class UI_FontDesc: public CL_Object {

public:

    UI_FontDesc (const char* type_face, short point_size = 10,
                 ulong style_enum = 0);
    // The third parameter is a disjunction of {\tt StyleEnum} values.

    UI_FontDesc ();
    
    short Compare (const CL_Object&) const;

    short Compare (const UI_FontDesc&) const;

    void operator= (const CL_Object&);

    UI_FontDesc& operator= (const UI_FontDesc&);


    short PointSize() const    {return _ptSize;};

    CL_String TypeFace() const {return _typeFace;};

    ulong Style () const   {return _style;};

protected:
    short             _ptSize;
    CL_String         _typeFace;
    short             _style;


};


//  The FontInfo class is an enhancement of the FontDesc class to include
//  platform-specific information.

class UI_FontInfo: public UI_FontDesc {

public:
    UI_FontInfo ();
    
#if defined(__X_MOTIF__)
    bool IsFixedWidth() const {return _fixedWidth;};

#endif

    bool IsScalable () const {return _scalable;};

    short Compare (const CL_Object&) const;

    short Compare (const UI_FontInfo&) const;

    void operator= (const CL_Object&);

    UI_FontInfo& operator= (const UI_FontInfo&);

    CL_String AsString () const;

protected:
    UI_FontInfo (const char* type_face, short point_size = 10,
                 ulong style_enum = 0, bool = FALSE);
    // Under Windows, the last parameter is TRUE for TrueType fonts; under
    // X, it is TRUE for proportional fonts.
    
    bool              _scalable;
    
#if defined(__X_MOTIF__)
    bool              _fixedWidth;
    CL_String         _realName;
#endif

    friend class UI_Font;
};

#endif /* _fontdesc_h_ */
