

#ifndef _graphic_h_ /* Fri Oct 28 17:18:04 1994 */
#define _graphic_h_


// GraphicObject is an abstract class representing a graphic object that can
// be drawn on a DrawingSurface.

#include "base/object.h"
#include "ui/point.h"

class UI_DrawingSurface;
class UI_Rectangle;

class UI_GraphicObject: public CL_Object {

public:

    virtual UI_Rectangle BoundingRectangle () const = 0;
    // Return the bounding rectangle for this graphic.
    // The default implementation issues a "not implemented" warning and
    // returns an empty rectangle.

    virtual UI_Point Center () const;
    // Return the center of this GraphicObject. The default implementation
    // returns the center of the BoundingRectangle.
    
    virtual bool DrawOn (UI_DrawingSurface& sfc,
                         const UI_Point& p = UI_Point (0, 0)) const = 0;
    // [Pure virtual method] Draw the graphic on the given surface,
    // translated with respect to {\tt p} (i.e., treating {\tt p} as the
    // origin). The default implementation does nothing.

    virtual bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Grow or shrink the graphic so that the two given points become the
    // diagonally-opposing points of its bounding box. Return TRUE if
    // successful. The default implementation returns FALSE unconditionally.

    virtual bool Fill   (UI_DrawingSurface& s) const;
    // Fill the interior of the graphic on the given surface with the current
    // foreground color of the given surface. This operation makes sense
    // only for closed figures. The default implementation returns FALSE.

    virtual bool OnBoundary (const UI_Point& p) const;
    // Tell whether the given point is on the boundary of this graphic. The
    // default implementation returns FALSE.

    virtual bool Includes (const UI_Point& p) const;
    // Tell whether the given point is within this graphic. The
    // default implementation returns FALSE.

    virtual bool IntersectsBoundary (const UI_Rectangle& r) const;
    // Tell whether the given rectangle intersects the boundary of this
    // GraphicObject. The default implementation uses the bounding
    // rectangle.

    virtual bool IsContainedIn (const UI_Rectangle& r) const;
    // Tell whether the given rectangle entirely contains this
    // GraphicObject. The default implementation returns whether this
    // object's bounding rectangle is contained in {\tt r}.

};

#endif /* _graphic_h_ */
