




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/label.h"
#include "ui/cntroler.h"
#include "ui/composit.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined(__X_MOTIF__)
#include <Xm/Label.h>
#include <Xm/Xm.h>
#endif


#if defined(__MS_WINDOWS__)
#define LABEL_STYLE WS_VISIBLE  | WS_CHILD 

static ulong WindowsStyle (UI_TextStyle style)
{
    switch (style) {
    case UIText_Left:
        return SS_LEFT;
        
    case UIText_Center:
        return SS_CENTER;
        
    case UIText_Right:
        return SS_RIGHT;

    default:
        return 0;
    }
}

#elif defined(__OS2__)
static ulong OS2Style (UI_TextStyle style)
{
    switch (style) {
    case UIText_Left:
        return DT_LEFT;
        
    case UIText_Center:
        return DT_CENTER;
        
    case UIText_Right:
        return DT_RIGHT;

    default:
        return 0;
    }
}

#elif defined(__X_MOTIF__)

static uchar XMotifStyle (UI_TextStyle style)
{
    switch (style) {
    case UIText_Left:
        return XmALIGNMENT_BEGINNING;
        
    case UIText_Center:
        return XmALIGNMENT_CENTER;
        
    case UIText_Right:
        return XmALIGNMENT_END;

    default:
        return 0;
    }
}

#endif


UI_Label::UI_Label ( UI_VObjCollection* parent, 
                     const UI_Rectangle& r, 
                     UI_ViewID id)
: UI_SimpleVObject (parent, r, id
#if defined(__MS_WINDOWS__)
                    , LABEL_STYLE
#endif
                    )
{
    _model = &_title;
    _ownModel = FALSE; // So that we don't attempt to delete the title
    _textStyle = UIText_Center;
    _borderShown = FALSE; // By default
    _isTabStop = FALSE;
#if defined(__MS_WINDOWS__)
    _style |= WindowsStyle (_textStyle);
#elif defined(__OS2__)
    _style = (_visible ? WS_VISIBLE : 0) | SS_TEXT | DT_WORDBREAK |
        OS2Style (_textStyle);
#endif
}



#if defined(__MS_WINDOWS__)
UI_Label :: UI_Label ( UI_CompositeVObject* parent, UI_ViewID id,
                       UI_ViewHandle h)
: UI_SimpleVObject (parent, id, h)
{
    _model    = &_title;
    _ownModel = FALSE;
    _borderShown = FALSE; // By default
    _isTabStop = FALSE;
}
#endif


UI_Label :: UI_Label ( UI_VObjCollection* parent, CL_String* msg,
                       const UI_Rectangle& r, UI_ViewID id)
: UI_SimpleVObject (parent, msg, id, r
#if defined(__MS_WINDOWS__)
                    , LABEL_STYLE
#endif
                    )
{
    _borderShown = FALSE; // By default
    _textStyle = UIText_Center;
    _isTabStop = FALSE;
#if defined(__MS_WINDOWS__)
    _style |= WindowsStyle (_textStyle);
#elif defined(__OS2__)
    _style = (_visible ? WS_VISIBLE : 0) | SS_TEXT | DT_CENTER;
#endif
}


#if defined(__X_MOTIF__)
void UI_Label::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;

    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add other resource specs:
    XtSetArg (arg [argn], XmNrecomputeSize, FALSE); argn++;
    XtSetArg (arg [argn], XmNalignment, XMotifStyle (_textStyle)); argn++;
}

#endif



void UI_Label :: _PrivateInitialize ( )
{
    UI_SimpleVObject :: _PrivateInitialize ( );
    CL_String& p = *(CL_String *) _model;
    if (p.Size () <= 0 )
        return;
#if defined(__MS_WINDOWS__)
    SendMessage (_handle, WM_SETTEXT, 0, (long) p.AsPtr());   
#elif defined(__X_MOTIF__)
    Arg arg[1];
    XmString xmlabel;
    char *label = (char *) p.AsPtr ( );
    xmlabel = XmStringCreateLtoR ( label, XmSTRING_DEFAULT_CHARSET );
    XtSetArg (arg[0], XmNlabelString, xmlabel);
    XtSetValues (_xwidget, arg, 1);
    XmStringFree (xmlabel);
#endif
}


bool UI_Label :: _TitleChanged ( CL_Object&, long )
{
#if defined(__MS_WINDOWS__)
    if ( _handle > 0 ) {
        SendMessage (_handle, WM_SETTEXT, 0,
                     (long) ((CL_String*) _model)->AsPtr() );   

        // For some reason, if I don't force a redraw via SetWindowPos, the
        // text doesn't get (reliably)  shown, so:
        SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_SHOWWINDOW | 
                       SWP_NOSIZE | SWP_NOMOVE | 
                       SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
    }
#elif defined(__OS2__)
    if (_handle > 0) {
        WinSetWindowText (_handle, _title.AsPtr());
    }
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE;
    Arg arg[1];
    XmString label;
    label = XmStringCreateLtoR ((char *) ( (CL_String *)_model )->AsPtr (), 
                                XmSTRING_DEFAULT_CHARSET 
                                );    
    XtSetArg    (arg[0], XmNlabelString, label);
    XtSetValues (_xwidget, arg, 1);

    XmUpdateDisplay (_xwidget);
    XmStringFree (label);
#endif

    return TRUE;
}




bool UI_Label::SetTextStyle (UI_TextStyle style)
{
    if (style != UIText_Left && style != UIText_Center && style !=
        UIText_Right)
        return FALSE;
    _textStyle = style;
#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        _style = GetWindowLong (_handle, GWL_STYLE);
    _style = (_style & ~(ES_LEFT | ES_CENTER | ES_RIGHT))
        | WindowsStyle (_textStyle);
    if (_handle >  0) {
        _style |= WindowsStyle (_textStyle);
        SetWindowLong (_handle, GWL_STYLE, _style);
        SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_SHOWWINDOW | 
                       SWP_NOSIZE | SWP_NOMOVE | 
                       SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
    }
    return TRUE;
#elif defined(__OS2__)
    if (_handle > 0)
        _style = WinQueryWindowULong (_handle, QWL_STYLE);
    _style = (_style & ~(DT_LEFT | DT_CENTER | DT_RIGHT))
        | OS2Style (_textStyle);
    if (_handle >  0) {
        _style |= OS2Style (_textStyle);
        WinSetWindowULong (_handle, QWL_STYLE, _style);
        if (_visible) {
            // This is how we force a redraw:
            WinShowWindow (_handle, FALSE);
            WinShowWindow (_handle, TRUE);
        }
    }
    return TRUE;
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE;
    // Since we can't set the alignment resource after widget creation, we
    // just get rid of the widget and make up a brand new one.
    XtDestroyWidget (_xwidget);
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources
    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    XtRealizeWidget (_xwidget);
    if (_visible)
        XtManageChild (_xwidget);
    XmStringFree (title);

    return TRUE;
#endif
        
}


UI_TextStyle UI_Label::TextStyle() const
{
    return _textStyle;
}



UI_WindowClass UI_Label::WindowClass () const
{
#if defined(__MS_WINDOWS__)
    return "static";
#elif defined(__X_MOTIF__)
    return xmLabelWidgetClass;
#elif defined(__OS2__)
    return WC_STATIC;
#endif
}

