



#ifndef _lineseg_h_ /* Sat Oct 29 09:53:51 1994 */
#define _lineseg_h_


#include "ui/graphic.h"

class UI_LineSegment: public  UI_GraphicObject {

public:
    UI_LineSegment (const UI_Point& p1, const UI_Point& p2);

    UI_LineSegment ();

    UI_LineSegment& operator= (const UI_LineSegment& o);

    bool Intersects (const UI_LineSegment& l) const;
    // Tell whether the given line segment intersects this one.

    void operator= (const CL_Object& o);
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point(0,0)) const;
    // Draw the line segment on the surface {\tt sfc}, translated so that
    // {\tt p} is treated as the origin of the co-ordinate system.

    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);

    bool OnBoundary (const UI_Point& p) const;

    struct EndPoints {
        UI_Point p1;
        UI_Point p2;
    };
    EndPoints Extremities () const;

    UI_Point Center () const;
    
    bool Includes (const UI_Point& p) const {return OnBoundary (p);}
    // Includes is the same as OnBoundary, because this is a line.

    bool IntersectsBoundary (const UI_Rectangle& r) const;
    
    bool IsContainedIn (const UI_Rectangle& r) const;

    UI_Rectangle BoundingRectangle() const;


    const char* ClassName () const {return "UI_LineSegment";};

    
protected:
    UI_Point _p1, _p2;

};



#endif /* _lineseg_h_ */
