




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/pen.h"
#include "ui/color.h"
#include "ui/visualob.h"
#include "ui/dsplsurf.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__)
 
#include <windows.h>
static short getPatternFromMS (UI_PenPattern );
#elif defined(__X_MOTIF__)

#include <X11/Intrinsic.h>

static long getPatternFromX (UI_PenPattern);
#endif

UI_Pen::UI_Pen (UI_DrawingSurface* ct, short sz, UI_Color cl,
                UI_PenPattern pt)
: UI_DisplayResource (ct)
{
    _size = sz;
    _color = cl;
    _pattern = pt;
    _handle = 0;
    _Setup ();
}

void UI_Pen::_Setup ()
{
#if defined(__MS_WINDOWS__)
    if(_handle) {
        SelectObject (_clientCtxt->Handle(), GetStockObject (BLACK_PEN));
        DeleteObject (_handle);
    }
    short msp = getPatternFromMS (_pattern);
    _handle = (UI_ResourceHandle) CreatePen (msp, _size, _color.NativeForm());
    SelectObject (_clientCtxt->Handle(), _handle);
    SetTextColor (_clientCtxt->Handle(), _color.NativeForm());
#elif defined(__OS2__)
    HPS hps = (HPS) _clientCtxt->Handle();
    GpiSetLineType (hps, OS2Pattern ());
    GpiSetColor (hps, _color.NativeForm());
    GpiSetLineWidth (hps, MAKEFIXED (_size, 0));
#elif defined(__X_MOTIF__)
    Display* dpy = XtDisplay (_TheApplication->Controller().ShellWidget());
    XSetLineAttributes (dpy, _clientCtxt->Handle(), _size,
                        getPatternFromX (Pattern ()),
                        CapButt, JoinMiter);
    
    if (_pattern == UIPen_Dot || _pattern == UIPen_Dash) {
        XGCValues val;
        val.dashes = _pattern == UIPen_Dot ? 2 : 4;
        XChangeGC (dpy, _clientCtxt->Handle(), GCDashList, &val);
    }
#endif
}



UI_Pen::~UI_Pen()
{
#if defined(__MS_WINDOWS__)
    if(_handle)
        DeleteObject (_handle); 

#elif defined(__X_MOTIF__)

#endif
}

void UI_Pen::Thickness (short sz)
{
    _size = sz;
    _Setup ();
}


void UI_Pen::Pattern (UI_PenPattern ptrn)
{
    _pattern = ptrn;
    _Setup ();
}

void UI_Pen::Color(UI_Color newColor)
{
    _color = newColor;
    _Setup();
}




#if defined(__MS_WINDOWS__)

short getPatternFromMS(UI_PenPattern p)
{

    switch(p){

    case UIPen_None:
        return PS_NULL;
        
    case UIPen_Solid:
        return PS_SOLID;
    
    case UIPen_Dash:
        return PS_DASH;
    
    case UIPen_Dot:
        return PS_DOT;
        
    default:
        return PS_SOLID;
    }

}

#elif defined(__OS2__)

long UI_Pen::OS2Pattern () const
{
    switch (_pattern) {
    case UIPen_None:
        return LINETYPE_INVISIBLE;

    case UIPen_Dash:
        return LINETYPE_SHORTDASH;
    
    case UIPen_Dot:
        return LINETYPE_SHORTDASH;
        
    case UIPen_Solid:
    default:
        return LINETYPE_SOLID;
    }

}

#elif defined(__X_MOTIF__)
long getPatternFromX (UI_PenPattern p)
{
    switch (p){
    case UIPen_Solid:
        return LineSolid;

    case UIPen_Dash:
        return LineOnOffDash;

    case UIPen_Dot:
        return LineOnOffDash;

    default:
        return LineSolid;
    }

}

#endif

