
#ifndef _pictureseq_h_
#define _pictureseq_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "base/map.h"
#include "base/binding.h"



//   A class representing the notion of a sequence of homogenous
//   Objects. Each contained object is of the same type and
//   dimension. The underlying data is an actual sequence of objects
//   which may or may not be owned by it - the interpretation is left upto
//   the subclasses. 



class UI_PictureSequence: public CL_Object {

public:



    virtual long NumberOfPictures() const =0;
    // Returns total number of items in sequence

    virtual long AddPicture(CL_Object& ) =0;
    // Returns the index in the sequence
    
    virtual bool InsertPicture(CL_Object&, long index ) =0;
    // Returns the index in the sequence
    
    virtual bool RemovePicture(long index)=0;

    virtual CL_Object& operator[] (long index) =0;
    // Return a copy of the  nth picture in the sequence.

protected:

     UI_PictureSequence(){};

    ~UI_PictureSequence(){};

    
};


#endif

