

#ifndef _piewedge_h_ /* Thu Jan  5 09:34:33 1995 */
#define _piewedge_h_



// This is a GraphicObject representing a pie wedge of an ellipse. This is a
// closed figure.

#include "ui/graphic.h"


class UI_Arc;
class UI_Ellipse;

class UI_PieWedge: public UI_GraphicObject {

public:
    UI_PieWedge (const UI_Rectangle& boundingRect, long startAngleDeg64, long
                 subtendedDeg64);
    // Construct a pie wedge of an ellipse. The PieWedge is part of the
    // ellipse whose
    // bounding rectangle is {\tt boundingRect}. Its starting point is at an
    // angle {$d$} degrees from the 3-o'clock position of {\tt boundingRect}
    // where $d = {\tt startAngleDeg64} * 64$, and it subtends an angle $s$
    // at the center of the ellipse, where $s = {\tt subtendedDeg64} * 64$,

    UI_PieWedge (const UI_Point &p1, const UI_Point &p2,
                 const UI_Point& origin);
    // Construct an arc of an ellipse with the points p1, p2 being the
    // start point and the end point and the origin being the center of
    // the ellipse.
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the ellipse on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill (UI_DrawingSurface& sfc) const;
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.


    UI_Rectangle BoundingRectangle() const;

    struct UI_Arc::UI_PointPair EndPoints() const;

    bool IntersectsBoundary (const UI_Rectangle& r) const;

    long StartAngle() const;

    long SubtendedAngle() const;

    UI_Ellipse Ellipse() const;

    void StartAngle (long startAngle64);

    void SubtendedAngle (long subtAngle64);

    void Origin (const UI_Point &origin);
    
    const char* ClassName() const {return "UI_PieWedge";};

protected:

    UI_Rectangle _boundingEllipse;
    UI_Rectangle _boundingRect;
    long         _startAngle  ;
    long         _subtAngle   ;
    UI_Arc       _arc         ;

};




inline long UI_PieWedge::StartAngle() const
{
    return _startAngle;
}


inline long UI_PieWedge::SubtendedAngle() const
{
    return _subtAngle;
}


#endif /* _piewedge_h_ */
