

#ifndef _point_h_
#define _point_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "base/map.h"
#include "base/binding.h"



//  This is a class representing a point in the X-Y coordinate system.



class UI_Point: public CL_Object {

public:
   
    UI_Point (long px = 0,long py = 0);
    
    UI_Point (const UI_Point& );

    long  XCoord() const {return x;};

    long  YCoord() const {return y;};

    void  AddToX (long value);

    void  AddToY (long value);

    UI_Point operator+ (const UI_Point&) const;

    void operator+=    (const UI_Point& p) {*this = *this + p;};
    
    UI_Point operator- (const UI_Point&) const;

    void operator-=    (const UI_Point& p) {*this = *this - p;};

    long operator* (const UI_Point& p) const;
    // Cross product: see Cormen, Leiserson and Rivest, p 888, for
    // definition. This is  $x_1*y_2 - x_2*y_1$.
    
    void operator= (const CL_Object&);

    void operator= (const UI_Point&);

    bool operator== (const CL_Object& p) const;

    bool operator== (const UI_Point& p) const;

    CL_String AsString() const;
    // Return a string that looks like \verb|"(23, 15)"|.
    

 

protected:
   
    long x,y;
};

#endif
