
#if defined(__MS_WINDOWS__)
#include <windows.h>
#endif

#include "ui/printjob.h"
#include "base/string.h"

UI_PrintJob::UI_PrintJob (const char* jobName)
{
    _font = new UI_Font;
#if defined(__MS_WINDOWS__)
    char printer[80];
    GetProfileString("windows", "device", "", printer, sizeof(printer) - 1);
    CL_String printerString (printer);
    CL_String device = printerString.Field (1, ",");
    CL_String driver = printerString.Field (2, ",");
    CL_String port   = printerString.Field (3, ",");
    _handle  = CreateDC (driver.AsPtr(), device.AsPtr(), port.AsPtr(), NULL);
    if (!_handle) {
        CL_Error::Warning ("UI_PrintJob constructor: printer init failed");
        return;
    }
    _horzPPM = ((float) GetDeviceCaps (_handle, LOGPIXELSX)) / 25.4;
    _vertPPM = ((float) GetDeviceCaps (_handle, LOGPIXELSY)) / 25.4;
    DOCINFO docInfo;
    docInfo.cbSize = sizeof (DOCINFO);
    docInfo.lpszDocName = jobName;
    docInfo.lpszOutput  = NULL;
    StartDoc (_handle, &docInfo);
    StartPage (_handle);

#elif defined(__OS2__)
    _handle = 0;
    static CHAR     printerData[256];
    static DRIVDATA driv = { sizeof (DRIVDATA) } ;
    CHAR            printerName[33];
    DEVOPENSTRUC    dop ;
    PrfQueryProfileString (HINI_PROFILE, "PM_SPOOLER",
                           "PRINTER", ";",
                           printerName, sizeof printerName) ;
    
    CL_StringSequence seq1 = CL_String (printerName).Split (';');
    if (seq1.Size() <= 0)
        return;
    PrfQueryProfileString (HINI_PROFILE, "PM_SPOOLER_PRINTER",
                           printerName, ";;;;",
                           printerData, sizeof achPrnData) ;

    CL_StringSequence seq2 = CL_String (printerData).Split (';');
    if (seq2.Size() <= 0)
          return;
    dop.pszLogAddress = seq2[2].AsPtr();
    dop.pszDriverName = seq2[1].AsPtr();

    if ((pchDelimiter = strchr (dop.pszDriverName, '.')) != NULL) {
        *pchDelimiter = '\0' ;
        strncpy (driv.szDeviceName, pchDelimiter + 1,
                 sizeof (driv.szDeviceName)) ;
        dop.pdriv = &driv ;
    }
    else
        dop.pdriv = NULL ;

    dop.pszDataType = "PM_Q_STD" ;
    HAB hab = _TheApplication->Controller().AnchorBlockHandle();
    _handle = DevOpenDC (hab, OD_QUEUED, "*", 4L, (PDEVOPENDATA) &dop, 0L) ;
#endif

    _brush  = new UI_Brush (this, UIColor_White, UIBrush_Solid);
    _pen    = new UI_Pen   (this);
}

UI_PrintJob::~UI_PrintJob ()
{
#if defined(__MS_WINDOWS__)
    EndPage    (_handle);
    EndDoc     (_handle);
    DeleteDC   (_handle);
#endif
}

bool UI_PrintJob::StartNewPage ()
{
#if defined(__MS_WINDOWS__)
    EndPage   (_handle);
    StartPage (_handle);
#endif
    return TRUE;
}



// 
// Query:
//     

double UI_PrintJob::HorzPixelsPerMM () const
{
    return _horzPPM;
}


double UI_PrintJob::VertPixelsPerMM () const
{
    return _vertPPM;
}



UI_Rectangle UI_PrintJob::DrawingArea() const
{
    return UI_DrawingSurface::DrawingArea ();
}



UI_Rectangle UI_PrintJob::DrawingAreaInMM () const
{
    return UI_DrawingSurface::DrawingAreaInMM ();
}


bool UI_PrintJob::DrawBitmap (const UI_Bitmap& b, const UI_Point& p)
{
#if defined (__MS_WINDOWS__)
    return UI_DrawingSurface::DrawBitmap (b, p);
#endif
}


