




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






#include "base/binding.h"
#include "ui/simple.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__)
#include <ctl3d.h>
#endif

#if defined (__X_MOTIF__)
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_SimpleVObject>;
#endif


typedef CL_Binding<UI_SimpleVObject> SimpleBind;

UI_SimpleVObject :: UI_SimpleVObject
    ( UI_VObjCollection* p, const UI_Rectangle& shape, UI_ViewID id,
      long style)
: UI_VisualObject (p,  shape, id, style)
{
   _ownModel = TRUE;
   _model = NULL;
}



#if defined(__MS_WINDOWS__)
UI_SimpleVObject :: UI_SimpleVObject
    ( UI_VObjCollection* p, UI_ViewID id, UI_ViewHandle h)
: UI_VisualObject (p, id, h)
{
   _ownModel = TRUE;
   _model = NULL;
}
#endif


UI_SimpleVObject :: UI_SimpleVObject
    ( UI_VObjCollection* p, CL_Object* md, UI_ViewID id,
      const UI_Rectangle& r, long style)
: UI_VisualObject (p, r, id, style)
{
    if (!_parent)
        CL_Error::Warning ("SimpleVObject constructor: class '%s' id %d:"
                           " NULL parent!", ClassName(), id);
   _ownModel = FALSE;
   _model = md;
}



UI_SimpleVObject :: ~UI_SimpleVObject()
{
    if (_ownModel && _model != NULL)
        delete _model;
}


bool UI_SimpleVObject::_ModelChanged (CL_Object&, long)
{
    return Paint ();
}


bool UI_SimpleVObject::MakeVisualElement ()
{
    bool b = UI_VisualObject::MakeVisualElement ();
#if defined(__MS_WINDOWS__)
    if (Has3DLook ())
        Ctl3dSubclassCtl (_handle);
#endif
    return b;
}


void UI_SimpleVObject :: _PrivateInitialize()
{
    UI_VisualObject :: _PrivateInitialize ( );

#if defined(__OS2__)
    // Mouse moves are not queued under OS/2. We need to be able to set
    // cursors for simple objects also, and this can only be done on each
    // mouse move. Therefore we subclass. Note that if we subclass in
    // MakeVisualElement, we get into trouble: a message sent to the control
    // before MakeVisualElement finishes execution will fail, because the
    // subclassing procedure's call to the Controller's op[] will fail. This
    // is why the subclassing is done here rather than in MakeVisualElement.
    if (WindowClass() != NULL) // Don't subclass menu items
        _Subclass ();
#endif
    if (_model) {
        SimpleBind b (this, &UI_SimpleVObject::_ModelChanged);
        _model->AddDependent (b, 1);
    }
    if (_font) {
        SimpleBind b (this, &UI_SimpleVObject::_FontChanged);
        _font->AddDependent (b, 1);
    }
#if defined (__MS_WINDOWS__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h && !_parent->CreatedViaResource()) {
        SendMessage (_handle, WM_SETFONT, h, TRUE);
    }
    // The following hack is needed to force the control to be shown in the
    // case where it is a child of a window of YACLWINDOW class. Without
    // this hack, the control will not be shown the first time the parent
    // window is created.
    SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_SHOWWINDOW | 
                   SWP_NOSIZE | SWP_NOMOVE | 
                   SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
#elif defined (__X_MOTIF__)
    if (_font)
        SetFont (_font);

#endif
}




bool UI_SimpleVObject :: DestroyVisualElement ()
{
    return UI_VisualObject::DestroyVisualElement();
}



static bool _SetPlatformFont (UI_ViewHandle handle, UI_Font& font)
{
#if defined (__MS_WINDOWS__)
    UI_ResourceHandle h = font.Handle();
    if (h > 0 && handle > 0) {
        return SendMessage (handle, WM_SETFONT, h, TRUE);
    }
    return TRUE;

#elif defined(__OS2__)
    CL_String fontString = CL_String (font.PointSize()) + "." +
        font.TypeFace();
    ulong style = font.Style ();
    if (style & UIFont_BoldFace)
        fontString += ".Bold";
    if (style & UIFont_Underline)
        fontString += ".Underscore";
    if (style & UIFont_StrikeOut)
        fontString += ".Strikeout";
    if (style & UIFont_Italic)
        fontString += ".Italic";
    return WinSetPresParam (handle, PP_FONTNAMESIZE, fontString.Size()+1,
                            (void*) fontString.AsPtr());
#elif defined (__X_MOTIF__)
    UI_ResourceHandle h = font.Handle();
    if (h <= 0 || !handle)
        return FALSE;

    Display *dpy = XtDisplay (handle);
    XmFontList f = XmFontListCreate (XQueryFont (dpy, h),
                                     XmSTRING_DEFAULT_CHARSET);
    Arg arg [1];
    XtSetArg       (arg [0], XmNfontList,  f);
    XtSetValues    (handle, arg, 1);
    XmFontListFree (f);
    return TRUE;
    
#endif
}



bool UI_SimpleVObject :: _FontChanged (CL_Object&, long)
{
    return _SetPlatformFont (ViewHandle(), *_font);
}



bool UI_SimpleVObject :: SetFont (UI_Font* fnt)
{
    if (!UI_VisualObject::SetFont (fnt))
        return FALSE;
    return _font ? _SetPlatformFont (ViewHandle(), *_font) : FALSE;
}




UI_WindowClass UI_SimpleVObject::WindowClass () const
{
#if defined(__MS_WINDOWS__)
    return _YACLWindowClassName;
#elif defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_MOTIF__)
    return shellWidgetClass;
#endif
}


bool UI_SimpleVObject :: SetStyleParam ( )
{
    // This is used only for resource-based construction
#if defined(__MS_WINDOWS__)
    RECT rec;

    _id = GetWindowWord    (_handle,GWW_ID);  
    _style = GetWindowLong (_handle,GWL_STYLE); 
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
    GetWindowRect (_handle, &rec);
    POINT array[2];
    array[0].x = rec.left;
    array[0].y = rec.top;
    array[1].x = rec.right;
    array[1].y = rec.bottom;
    MapWindowPoints (NULL, _parent->ViewHandle(), array, 2);
    UI_Point org(array[0].x, array[0].y);
    UI_Rectangle shp(org, array[1].x-array[0].x, array[1].y-array[0].y);
    _SetShapeRectangle (shp);

#else
    NotImplemented ("SetStyleParam");
#endif
    return TRUE;
}




#if defined(__OS2__)
MRESULT EXPENTRY UI_SimpleVObject::SubclassProc
    (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    UI_SimpleVObject* obj = (UI_SimpleVObject*) (*_Controller)[hWnd];
    if (obj) {
        MRESULT retVal = (*(obj->_oldProc)) (hWnd, msg, p1, p2);
        if (msg == WM_MOUSEMOVE)
            _Controller->SetCurrentCursor (obj->Cursor());
        return retVal;
    }
    return WinDefWindowProc (hWnd, msg, p1, p2);
}


void UI_SimpleVObject::_Subclass ()
{
    _oldProc = WinSubclassWindow (_handle, UI_SimpleVObject::SubclassProc);
}
#endif

