
#ifndef _simple_h_
#define _simple_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




//   The SimpleVObject encapsulates a VisualObject that displays either a
//   single data item or a homogeneous collection of data items. A 
//   SimpleVObject includes in its state a data structure called the {\it
//   model\/} 
//   and a selection mechanism determined by a {\it selection}. The actual 
//   interpretation of model and selection and their management is
//   left to subclasses of the SimpleVObject. The model is not owned by
//   this object but 
//   passed to it at construction by the derived class. The simple object
//   may however modify the
//   model. The parent of a simple object must be a VObjCollection.
// 
// 
//   The model has this object as a dependent and invokes
//   {\tt _ModelChanged()} when it changes.



#include "ui/visualob.h"

class UI_VObjCollection;

class UI_SimpleVObject: public UI_VisualObject {

public:

    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName() const {return "UI_SimpleVObject";};

    
protected:

    UI_SimpleVObject (UI_VObjCollection* parent, const UI_Rectangle& r,
                      UI_ViewID id = -1, long style = -1);
    // model owned

    UI_SimpleVObject (UI_VObjCollection* parent, CL_Object* model,
                      UI_ViewID = -1,
                      const UI_Rectangle& r = UI_Rectangle(),
                      long style = -1);
    // model not owned

#if defined(__MS_WINDOWS__)
    UI_SimpleVObject ( UI_VObjCollection* parent,
                       UI_ViewID id, UI_ViewHandle h 
                     );
    // [MS-Windows-specific] For resource-based construction.

#endif
                     

    ~UI_SimpleVObject(); 

    virtual bool _ModelChanged (CL_Object&, long);
    // _ModelChanged: invoked by our model when it changes. The default
    // implementation calls Paint().

    bool _FontChanged (CL_Object&, long);
    
    bool MakeVisualElement ();

    bool DestroyVisualElement ();

    void _PrivateInitialize();


    friend class UI_Controller;


public:

    // ------------- For YACL internal use only --------------

    bool SetFont (UI_Font* font);
    
    bool SetStyleParam();

protected:

    // Instance variables:
    
    bool       _ownModel;

#if defined(__OS2__)

private:
    void _Subclass ();
    // [OS/2-specific]

    PFNWP _oldProc;

    static MRESULT EXPENTRY SubclassProc (HWND hWnd, ULONG msg,
                                          MPARAM p1, MPARAM p2);
    // [OS/2-specific]
    
#endif
};








#endif
