




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#if defined(__MS_WINDOWS__)
#include <windows.h>
#include <commdlg.h>
#elif defined (__OS2__)
#include <mem.h> // For memset
#elif defined (__X_MOTIF__)
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Text.h>
#endif

#include "ui/stddlg.h"
#include "ui/applic.h"
#include "ui/cntroler.h"

#if defined(__X_MOTIF__)
class MessageBox {

public:
    MessageBox (const char* message,
                UI_SimpleDialogStyle style = UIS_Ok,
                UI_SimpleDialogIconStyle icon = UIS_Information,
                UI_VisualObject* parent = NULL,
                const char* box_title = "");
    ~MessageBox();
    
    short RunModal ();

    static void Callback (Widget w, void* client, void* call);

protected:
    Widget     _widget;
    CL_String  _callbackBtn;
    short      _terminator;
    CL_String  _msg;
    CL_String  _title;
    UI_SimpleDialogStyle _style;

    bool Filter (CL_Object&, long);

    bool Terminator (CL_Object&, long);
};


bool MessageBox::Filter (CL_Object&, long)
{
    return FALSE; // Do not dispatch any YACL events
}

bool MessageBox::Terminator (CL_Object&, long)
{
    return _terminator != -1;
}

#if defined(__GNUC__)
template class CL_Binding<MessageBox>;
#endif


void MessageBox::Callback (Widget w, void* client, void* call)
{
    MessageBox* m = (MessageBox*) client;
    XmAnyCallbackStruct* cb = (XmAnyCallbackStruct*) call;
    switch (cb->reason) {
    case XmCR_OK:
        if (m->_style == UIS_YesNo || m->_style == UIS_YesNoCancel)
            m->_terminator = UI_IDYES;
        else
            m->_terminator = UI_IDOK;
        break;

    case XmCR_CANCEL:
        if (m->_style == UIS_YesNo || m->_style == UIS_YesNoCancel)
            m->_terminator = UI_IDNO;
        else
            m->_terminator = UI_IDCANCEL;
        break;

    case XmCR_HELP:
    default:
        m->_terminator = UI_IDCANCEL; // For yes/no/cancel dialogs
        break;
    };
    
}

MessageBox::MessageBox (const char* message,
                        UI_SimpleDialogStyle style,
                        UI_SimpleDialogIconStyle icon,
                        UI_VisualObject* parent,
                        const char* box_title)
{
    _msg = message;
    _title = box_title;
    _style = style;
    Widget pw = parent ? (Widget) parent->ViewHandle()
        : _TheApplication->Controller().ShellWidget();
    switch (icon) {
    case UIS_Information:
        _widget = XmCreateInformationDialog (pw, "infoDialog", NULL, 0);
        break;
        
    case UIS_Question:
        _widget = XmCreateQuestionDialog (pw, "questionDialog", NULL, 0);
        break;
        
    case UIS_Error:
        _widget = XmCreateErrorDialog (pw, "infoDialog", NULL, 0);
        break;
        
    case UIS_Warning:
    default:
        _widget = XmCreateWarningDialog (pw, "warningDialog", NULL, 0);
        break;
    };
        
    _terminator = -1;


}


short MessageBox::RunModal ()
{
    Arg arg[6];
    short argn = 0;
    XmString msg = XmStringCreateLtoR ((char*) _msg.AsPtr(), 
                                       XmSTRING_DEFAULT_CHARSET);
    XtSetArg (arg[0], XmNmessageString,  msg);  argn++;
    
    XmString okTitle = XmStringCreateLtoR
        ("Yes", XmSTRING_DEFAULT_CHARSET);
    XmString cnTitle = XmStringCreateLtoR
        ("No",  XmSTRING_DEFAULT_CHARSET);
    XmString hlTitle = XmStringCreateLtoR
        ("Cancel", XmSTRING_DEFAULT_CHARSET);

    switch (_style) {
    case UIS_Ok:
        XtUnmanageChild (XmMessageBoxGetChild
                         (_widget, XmDIALOG_HELP_BUTTON));
        XtUnmanageChild (XmMessageBoxGetChild
                         (_widget, XmDIALOG_CANCEL_BUTTON));
        break;
        
    case UIS_YesNo:
        XtSetArg (arg[1], XmNcancelLabelString, cnTitle); argn++;
        XtSetArg (arg[2], XmNokLabelString,     okTitle); argn++;
        // Fall through...

    case UIS_OkCancel:
        XtUnmanageChild (XmMessageBoxGetChild (_widget, XmDIALOG_HELP_BUTTON));
        break;

    case UIS_YesNoCancel:
        XtSetArg (arg[1], XmNcancelLabelString, cnTitle); argn++;
        XtSetArg (arg[2], XmNokLabelString,     okTitle); argn++;
        XtSetArg (arg[3], XmNhelpLabelString,   hlTitle); argn++;
        break;

    default:
        break;
    };
        
    XtSetValues (_widget, arg, argn);
    XmStringFree (okTitle);
    XmStringFree (cnTitle);
    XmStringFree (hlTitle);

    XtVaSetValues (XtParent (_widget), XmNdialogTitle, (char*)
                   _title.AsPtr(), NULL);
    XtVaSetValues (XtParent (_widget), XmNtitle, (char*)
                   _title.AsPtr(), NULL);
    

    XtAddCallback (_widget, XmNcancelCallback, &MessageBox::Callback,
                   (XtPointer) this);
    XtAddCallback (_widget, XmNokCallback,     &MessageBox::Callback,
                   (XtPointer) this);
    XtAddCallback (_widget, XmNhelpCallback,   &MessageBox::Callback,
                   (XtPointer) this);
    XtManageChild (_widget);
    XtRealizeWidget (_widget);
    XmStringFree (msg);
    UI_Controller& controller = _TheApplication->Controller();
    CL_Binding<MessageBox> fbind (this, MessageBox::Filter);
    CL_Binding<MessageBox> tbind (this, MessageBox::Terminator);
    while (_terminator == -1) {
        controller.EventLoop (&tbind, &fbind);
    }
    return _terminator;
}


MessageBox::~MessageBox ()
{
    XtUnmanageChild (_widget);
    XtDestroyWidget (_widget);
}

#endif

UI_ViewID UI_SimpleDialog (const char* message,
                           const char* box_title,
                           UI_VisualObject* parent,
                           UI_SimpleDialogStyle style,
                           UI_SimpleDialogIconStyle icon)
{
#if defined (__MS_WINDOWS__)
    long s;
    switch (style) {
    case UIS_Ok:
        s = MB_OK;
        break;
        
    case UIS_OkCancel:
        s = MB_OKCANCEL;
        break;
        
    case UIS_YesNo:
        s = MB_YESNO;
        break;
        
    case UIS_YesNoCancel:
        s = MB_YESNOCANCEL;
        break;

    default:
        s = MB_OKCANCEL;
        break;
    }

    switch (icon) {
    case UIS_Information:
        s |= MB_ICONINFORMATION;
        break;
        
    case UIS_Error:
        s |= MB_ICONSTOP;
        break;
        
    case UIS_Question:
        s |= MB_ICONQUESTION;
        break;
        
    case UIS_Warning:
        s |= MB_ICONEXCLAMATION;
        break;

    }
    short ret_val = MessageBox (parent ? parent->ViewHandle() : NULL, message,
                                box_title, s);
    switch (ret_val) {
    case IDYES:
        ret_val = UI_IDYES;
        break;

    case IDNO:
        ret_val = UI_IDNO;
        break;

    default:
        break;
    }
    return ret_val;
            
#elif defined (__OS2__)
    ulong s = MB_MOVEABLE;
    switch (style) {
    case UIS_Ok:
        s |= MB_OK;
        break;
        
    case UIS_YesNo:
        s |= MB_YESNO;
        break;
        
    case UIS_YesNoCancel:
        s |= MB_YESNOCANCEL;
        break;

    case UIS_OkCancel:
    default:
        s |= MB_OKCANCEL;
        break;
    }

    switch (icon) {
    case UIS_Information:
        s |=  MB_INFORMATION;
        break;
        
    case UIS_Error:
        s |=  MB_ERROR;
        break;
        
    case UIS_Question:
        s |=  MB_QUERY;
        break;
        
    case UIS_Warning:
        s |=  MB_WARNING;
        break;

    }
    HWND handle = parent ? parent->ViewHandle() : HWND_DESKTOP;
//     HWND handle = HWND_DESKTOP; // Seems like the message box is invisible
//                                 // if an application window is specified.
//                                 // Don't know why.
    short ret_val = WinMessageBox
        (HWND_DESKTOP, handle, message, box_title, 0, s);
    switch (ret_val) {
    case MBID_OK:
        ret_val = UI_IDOK;
        break;

    case MBID_CANCEL:
        ret_val = UI_IDCANCEL;
        break;

    case MBID_YES:
        ret_val = UI_IDYES;
        break;

    case MBID_NO:
        ret_val = UI_IDNO;
        break;

    default:
        break;
    }
    return ret_val;
            
#endif

#if defined(__X_MOTIF__)
    MessageBox theBox (message, style, icon, parent, box_title);
    return theBox.RunModal ();
#endif
}





#if defined(__X_MOTIF__)
class FileSelectBox {

public:
    FileSelectBox (UI_VisualObject* parent,
                   const char* box_title = "");
    ~FileSelectBox();
    
    short RunModal ();

    CL_String FileName () {return _fileName;};
    
    static void Callback (Widget w, void* client, void* call);

protected:
    Widget     _widget;
    CL_String  _callbackBtn;
    short      _terminator;
    CL_String  _title;
    CL_String  _fileName;

    bool Filter (CL_Object&, long);

    bool Terminator (CL_Object&, long);
    
};



bool FileSelectBox::Filter (CL_Object&, long)
{
    return FALSE; // Do not dispatch any YACL events
}

bool FileSelectBox::Terminator (CL_Object&, long)
{
    return _terminator != -1;
}

#if defined(__GNUC__)
template class CL_Binding<FileSelectBox>;
#endif


void FileSelectBox::Callback (Widget w, void* client, void* call)
{
    FileSelectBox* m = (FileSelectBox*) client;
    XmFileSelectionBoxCallbackStruct* cb =
        (XmFileSelectionBoxCallbackStruct*) call;
    switch (cb->reason) {
    case XmCR_OK:
        m->_terminator = UI_IDOK;
        break;

    case XmCR_CANCEL:
    default:
        m->_fileName = "";
        m->_terminator = UI_IDCANCEL;
        break;
    };
    if (cb->reason != XmCR_OK)
        return;
    Widget box = XmFileSelectionBoxGetChild (m->_widget, XmDIALOG_TEXT);
    char* p = XmTextGetString (box);
    m->_fileName = p;
    XtFree (p);
    
}

FileSelectBox::FileSelectBox (UI_VisualObject* parent,
                              const char* box_title)
{
    _title = box_title;
    Widget pw = parent ? (Widget) (parent->ViewHandle())
        : _TheApplication->Controller().ShellWidget();
    _widget = XmCreateFileSelectionDialog (pw, "fileSelectionBox", NULL, 0);
    _terminator = -1;
}


short FileSelectBox::RunModal ()
{
    XtVaSetValues (XtParent (_widget), XmNtitle, (char*) _title.AsPtr(), NULL);
    
    XtAddCallback (_widget, XmNcancelCallback, &FileSelectBox::Callback,
                   (XtPointer) this);
    XtAddCallback (_widget, XmNokCallback,     &FileSelectBox::Callback,
                   (XtPointer) this);
    XtManageChild (_widget);
    XtRealizeWidget (_widget);
    UI_Controller& controller = _TheApplication->Controller();
    CL_Binding<FileSelectBox> bind (this, FileSelectBox::Filter);
    CL_Binding<FileSelectBox> tbind (this, FileSelectBox::Terminator);
    while (_terminator == -1) {
        controller.EventLoop (&tbind, &bind);
    }
    return _terminator;
}


FileSelectBox::~FileSelectBox ()
{
    XtUnmanageChild (_widget);
    XtDestroyWidget (_widget);
}

#endif

#if defined(__MS_WINDOWS__)
static FAR char file_name[256]; // Windows doesn't like this object to be
                                // on the stack!
#endif


CL_String UI_FileSelectDialog (UI_VisualObject* parent, const char* box_title)
{
#if defined(__MS_WINDOWS__)
    OPENFILENAME ofnTemp;
    long ErrVal;	// Error value
    char szTemp[] = "All files (*.*)\0*.*\0\0";
    if (!parent)
        return "";
    long hWnd = parent->ViewHandle ();
    
    ofnTemp.lStructSize = sizeof (OPENFILENAME);
    ofnTemp.hwndOwner = hWnd;	// An invalid hWnd causes non-modality
    ofnTemp.hInstance = 0;
    ofnTemp.lpstrFilter = (LPSTR)szTemp;  
    ofnTemp.lpstrCustomFilter = NULL;
    ofnTemp.nMaxCustFilter = 0;
    ofnTemp.nFilterIndex = 1;
    ofnTemp.lpstrFile = (LPSTR)file_name; // Stores the result in this variable
    ofnTemp.nMaxFile = sizeof (file_name);
    ofnTemp.lpstrFileTitle = NULL;
    ofnTemp.nMaxFileTitle = 0;
    ofnTemp.lpstrInitialDir = NULL;
    ofnTemp.lpstrTitle = box_title;	// Title for dialog
    ofnTemp.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
    ofnTemp.nFileOffset = 0;
    ofnTemp.nFileExtension = 0;
    ofnTemp.lpstrDefExt = "*";
    ofnTemp.lCustData = NULL;
    ofnTemp.lpfnHook = NULL;
    ofnTemp.lpTemplateName = NULL;
    /*
    If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
    to retrieve the type of error that occured.
    */
    if (!GetOpenFileName (&ofnTemp)) {
        ErrVal=CommDlgExtendedError();
        if (ErrVal) {	// 0 value means user selected Cancel
            UI_SimpleDialog ("Error code: " + CL_String (ErrVal));
        }
        else
            file_name[0] = '\0';

    }
    InvalidateRect (hWnd, NULL, TRUE) ;	// Repaint to display the new name
    return file_name;

#elif defined(__X_MOTIF__)
    FileSelectBox box (parent, box_title);
    box.RunModal ();
    return box.FileName();

#elif defined(__OS2__)
    FILEDLG fileDialog;
    memset (&fileDialog, 0, sizeof fileDialog); // Clear it out
    fileDialog.cbSize = sizeof fileDialog;
    fileDialog.fl     = FDS_CENTER | FDS_OPEN_DIALOG;
    fileDialog.pszTitle = (char*) box_title;
    short b = WinFileDlg (HWND_DESKTOP,
                         parent ? parent->ViewHandle() : HWND_DESKTOP,
                         &fileDialog);
    if (b != DID_OK || fileDialog.lReturn != DID_OK)
        return "";
    return fileDialog.szFullFile;
#endif
}

