




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/stred.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>
#define DEFAULT_STYLE \
    ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_TABSTOP | WS_GROUP
#elif defined(__OS2__)
#define DEFAULT_STYLE WS_VISIBLE | ES_MARGIN
#elif defined(__X_MOTIF__)
#include <Xm/Text.h> 
#endif


typedef CL_Binding<UI_StringEditor> StrEdBind;
#if defined(__GNUC__)
template class CL_Binding<UI_StringEditor>;
#endif


UI_StringEditor::UI_StringEditor
    (UI_CompositeVObject* parent, const UI_Rectangle& shape,
     UI_ViewID id, long s
    )
: UI_SimpleVObject (parent, shape, id, s)
{
    _model = new CL_String; 
    _limit = -1;
    StrEdBind bind (this, (StrEdBind::MethodPtr)
                    &UI_StringEditor::_SelectionChanged);
    _selection.AddDependent (bind, 1);
#if defined(__MS_WINDOWS__)
    if ( _style == -1 )
        _style =  DEFAULT_STYLE;
#elif defined(__OS2__)
    _style = DEFAULT_STYLE;
#endif
}



#if defined(__MS_WINDOWS__)
UI_StringEditor::UI_StringEditor (UI_CompositeVObject* parent,
                                  UI_ViewID id, UI_ViewHandle h)
: UI_SimpleVObject (parent, id, h)
{
    _model = new CL_String;
    _limit = -1;
    StrEdBind bind (this, (StrEdBind::MethodPtr)
                    &UI_StringEditor::_SelectionChanged);
    _selection.AddDependent (bind, 1);
}
#endif


UI_StringEditor::UI_StringEditor
    (UI_CompositeVObject* parent, CL_String* model,
     const UI_Rectangle& shape, UI_ViewID id, long s)
: UI_SimpleVObject(parent, model, id, shape, s)
{
    _limit = -1;
#if defined(__MS_WINDOWS__)
    if (_style == -1)
        _style = DEFAULT_STYLE;
#elif defined(__OS2__)
    _style = DEFAULT_STYLE;
#endif
    StrEdBind bind (this, (StrEdBind::MethodPtr)
                    &UI_StringEditor::_SelectionChanged);
    _selection.AddDependent (bind, 1);
}



#if defined(__X_MOTIF__)
void UI_StringEditor::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (p, argn);
    XtSetArg (arg[argn], XmNeditMode, XmSINGLE_LINE_EDIT); argn++;
}
#endif


void UI_StringEditor::_PrivateInitialize ()
{
    UI_SimpleVObject::_PrivateInitialize ();
#if defined(__MS_WINDOWS__)
    CL_String& s = *((CL_String*) _model);
    if (s.Size() > 0)
        SendMessage (_handle, EM_REPLACESEL, 0, (long) s.AsPtr());
#elif defined(__OS2__)
    CL_String& s = *((CL_String*) _model);
    if (s.Size() > 0)
        WinSetWindowText (_handle, s.AsPtr());
#elif defined(__X_MOTIF__)
    XmTextSetString (_xwidget, (char*) ((CL_String*) _model)->AsPtr());
#endif
}



UI_WindowClass UI_StringEditor::WindowClass () const
{
#if defined(__MS_WINDOWS__)
    return "edit";
#elif defined(__OS2__)
    return WC_ENTRYFIELD;
#elif defined(__X_MOTIF__)
    return  xmTextWidgetClass;
#endif
}



//
// -----------------StringEditor Event methods--------------------
//



CL_Interval& UI_StringEditor::Selection ()
{
    StrEdBind bind (this, (StrEdBind::MethodPtr)
                    &UI_StringEditor::_SelectionChanged);
    _selection.RemoveDependent (bind);
#if defined(__MS_WINDOWS__)
    DWORD pos;
    pos = SendMessage  (_handle, EM_GETSEL, 0, 0);
    _selection = CL_Interval (LOWORD(pos), HIWORD(pos)-1);

#elif defined(__OS2__)
    MPARAM pos = WinSendMsg  (_handle, EM_QUERYSEL, 0, 0);
    _selection = CL_Interval (SHORT1FROMMP(pos), SHORT2FROMMP(pos)-1);

#elif defined(__X_MOTIF__)
    XmTextPosition left, right;
    XmTextGetSelectionPosition(_xwidget, &left, &right);
    _selection = CL_Interval ((long) left, (long) right);
#endif
    _selection.AddDependent (bind, 1);
    return _selection;
}


CL_Object& UI_StringEditor::Model ()
{
    if (!ViewHandle()) {
        _SetModelValue (CL_String (""));
        return *_model;
    }
#if defined(__MS_WINDOWS__)
    long n = GetWindowTextLength (_handle);
    char* buf = new char[n+1];
    if (!buf)
        return *_model; // No memory
    GetWindowText (_handle, buf, n+1);
    _SetModelValue (CL_String (buf));
    delete buf;

#elif defined(__OS2__)
    long n = WinQueryWindowTextLength (_handle);
    char* buf = new char[n+1];
    if (!buf)
        return *_model; // No memory
    WinQueryWindowText (_handle,  n+1, buf);
    _SetModelValue (CL_String (buf));
    delete buf;
#elif defined(__X_MOTIF__)
    char* p =  XmTextGetString (_xwidget);
    _SetModelValue (CL_String (p));
    XtFree (p);
#endif
    return *_model;
}


bool UI_StringEditor::SetLengthLimit (long n)
{
#if defined (__MS_WINDOWS__)
    if (n > 0 && n <= 32767) {
        _limit = n;
        return SendMessage  (_handle, EM_LIMITTEXT, n, 0);
    }
    return FALSE;
#elif defined (__OS2__)
    if (n > 0 && n <= 32767) {
        _limit = n;
        WinSendMsg  (_handle, EM_SETTEXTLIMIT, MPFROM2SHORT(n, 0), 0);
        return TRUE;
    }
    return FALSE;
#elif defined (__X_MOTIF__)
    if (n > 0) {
        _limit = n;
        Arg arg[1];
        XtSetArg (arg[0], XmNmaxLength, n);
        XtSetValues (_xwidget, arg, 1);
    }
    return TRUE;
#endif
}


bool UI_StringEditor::_ModelChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    CL_String& s = *((CL_String*) _model);
    if (_handle > 0 && s.Size() > 0)
        SendMessage (_handle, EM_REPLACESEL, 0, (long) s.AsPtr());
#elif defined(__OS2__)
    CL_String& s = *((CL_String*) _model);
    if (_handle && s.Size() > 0)
        WinSetWindowText (_handle, s.AsPtr());
#elif defined(__X_MOTIF__)
    if (_xwidget) {
        XmTextSetString (_xwidget, (char*) ((CL_String*) _model)->AsPtr());
        XmUpdateDisplay  (_xwidget);
    }
#endif
    return TRUE;
}



bool UI_StringEditor::_SelectionChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0) {
        SendMessage (_handle, EM_SETSEL, TRUE,
                     MAKELPARAM (_selection.Low(), _selection.High()+1));
    }
#elif defined(__OS2__)
    if (_handle) {
        WinSendMsg (_handle, EM_SETSEL, MPFROM2SHORT
                    (_selection.Low(), _selection.High()+1), 0);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XmTextSetSelection (_xwidget, _selection.Low(), _selection.High(), 0);
#endif
    return TRUE;
}


