

#ifndef _stred_h_
#define _stred_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// This SimpleVObject is  designed to support the  editing of a single line
// of text  contained in its model, which  is a {\small\tt  CL_String}. The
// selection on the model is a {\small\tt CL_Interval}, i.e., the positions
// of the left and right ends of the substring currently selected.


#include "ui/simple.h"
#include "ui/interval.h"

class UI_StringEditor: public UI_SimpleVObject {

public:

    //
    // Construction:
    //

    UI_StringEditor (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                     UI_ViewID id=-1, long style=-1);
    // Own model

    UI_StringEditor (UI_CompositeVObject* parent, CL_String* model,
                     const UI_Rectangle& shape,
                     UI_ViewID id=-1, long style=-1);
    // Not own model

#if defined(__MS_WINDOWS__)
    UI_StringEditor (UI_CompositeVObject* parent, UI_ViewID id,
                     UI_ViewHandle h); 
    // Resource-based construction: only under MS-Windows

#endif

    CL_Object& Model ();
    // Override the inherited method. Applications should not remember the
    // pointer returned by this method; instead, they should call this
    // method explicitly just before the data is needed, even if the
    // application owns the model.
    
    virtual CL_Interval& Selection ();
    // Return a {\tt CL_Interval} containing the range of positions
    // selected. Modifying the return value causes a corresponding setting
    // of selection in the displayed string.

    virtual bool SetLengthLimit (long n);
    // Make the StringEditor enforce a  limit user type-in to $n$
    // characters.

    virtual long LengthLimit () const;
    // Return the current length limit. Returns -1 if there is no explicit
    // limit.

    
    const char* ClassName() const {return "UI_StringEditor";};



    virtual UI_WindowClass WindowClass () const;
    
protected:
    
    void _PrivateInitialize ();
  
    bool _ModelChanged (CL_Object&, long);
    // For YACL internal use only.
  
    bool _TitleChanged (CL_Object&, long) {return TRUE;};
    // String editors don't have titles. If we don't override it this way,
    // things don't work right under OS/2.
    
    //  Instance Variables:

    CL_Interval _selection;
    long        _limit;

#if defined(__X_MOTIF__)
    void _SetupStyle (void* arg, short& argn);
    // Motif-specific; for YACL internal use only.

#endif

private:
    virtual bool _SelectionChanged (CL_Object&, long);
    // Called when the application modifies the return value of the
    // Selection() method.
    
};




inline long UI_StringEditor::LengthLimit () const
{
    return _limit;
}


#endif
