

#ifndef _strseq_h_
#define _strseq_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "base/strgseq.h"
#include "base/objset.h"


// The class {\small\tt UI_StringSequence} serves as model for the
// {\small\tt StringView} class. It adds methods to the base class
// {\small\tt CL_StringSequence} so that it can be notified when one of
// the contained strings is modified. Also provided in this class are
// methods for adding and removing clients explicitly; these are useful to
// allow multiple {\small\tt StringView} objects to share the same model.

class UI_StringView;

class UI_StringSequence: public CL_StringSequence {

public:

    void AddClient    (UI_StringView* );

    void RemoveClient (UI_StringView* );

    virtual bool Insert (const CL_String& s, long index = -1);
    // Override the CL_StringSequence method to add dependency.

    virtual CL_String Remove (long index);

    virtual bool ShiftLeftAt  (long pos, long amount = 1);

    virtual bool ShiftRightAt (long pos, long amount = 1);

    CL_Sequence<CL_String>& operator= (const CL_Sequence<CL_String>&);

    void operator= (const CL_Object&);

    void MakeEmpty ();

    CL_Sequence<CL_String>& operator+= (const CL_Sequence<CL_String>& s);

#ifndef __GNUC__ // Temporarily disable these methods to work around
                 // the GCC bug
    void operator-= (const CL_IntegerSet& s);

#endif    // __GNUC__
  
    
    
    bool ChangeSize (long new_size);

    bool Sort ();
    
protected:


    void _InsertionUpdate (long );

    void _RemovalUpdate   (long );

    void _ChangeUpdate    (long );

    void _ReassignCodes ();
    
    bool Update (CL_Object&, long);
    // Invoked when the underlying array changes. Invokes Notify on its
    // dependents, if any.



    CL_ObjectSet      _clientSet;
    CL_String         _nullString;
};


inline void UI_StringSequence::operator= (const CL_Object& o)
{
    if (o.IsA (*this))
        *this = (const CL_Sequence<CL_String>&) o;
}

#endif

