



#ifndef _textedit_h_ /* Wed Sep 28 08:01:23 1994 */
#define _textedit_h_




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// This SimpleVObject  is designed to support  the  editing of a multi-line
// block  of   text  contained  in   its  model,  which   is  a  {\small\tt
// CL_String}. The  selection  on the model  is  a {\small\tt CL_Interval},
// i.e.,   the  positions of  the   left and  right  ends  of the substring
// currently selected.


#include "ui/stred.h"


class UI_TextEditor: public UI_StringEditor {

public:

    //
    // Construction:
    //

    UI_TextEditor (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                   UI_ViewID id = -1);

#if defined(__MS_WINDOWS__)
    UI_TextEditor (UI_CompositeVObject* parent, UI_ViewID id,
                   UI_ViewHandle h); 
    // Resource-based construction: only under MS-Windows

#endif

    CL_Interval& Selection ();
    // Return a {\tt CL_Interval} containing the range of positions
    // selected. Modifying the return value causes a corresponding setting
    // of selection in the displayed string.

    bool SetLengthLimit (long n);
    // Make the TextEditor enforce a  limit user type-in to $n$
    // characters.

    const char* ClassName() const {return "UI_TextEditor";};

    UI_WindowClass WindowClass () const;
    
#if defined(__OS2__)

private:

    virtual bool _SelectionChanged (CL_Object&, long);
    // Called when the application modifies the return value of the
    // Selection() method.

#elif defined (__X_MOTIF__)

protected:
    void _SetupStyle (void* arg, short& argn);
    // [X-Motif-specific. Internal use only]

#endif
    
};





#endif /* _textedit_h_ */
