

#ifndef _toglbtn_h_ /* Fri Mar 11 08:37:05 1994 */
#define _toglbtn_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






//  A class representing a Toggle Button. The model for this object is a
//  {\small\tt CL_Integer} whose value is either 0 or 1 depending on
//  current button state. The model can be inspected by the {\small\tt
//  Model()} method.



#include "base/integer.h"
#include "ui/simple.h"

class UI_CompositeVObject;
class UI_ToggleButton: public UI_SimpleVObject {

public:

    UI_ToggleButton (UI_VObjCollection* parent, const UI_Rectangle& shape,
                     UI_ViewID id = -1);

#if defined(__MS_WINDOWS__)
    UI_ToggleButton (UI_VObjCollection* parent, UI_ViewID id,
                     UI_ViewHandle h);
    // [MS-Windows-specific] For resource-based construction.

#endif

    CL_Object& Model ();
    // Return a reference to a {\small\tt CL_Integer} (our model).

    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName () const {return "UI_ToggleButton";};


protected:

    bool MakeVisualElement ();
    
    bool _ModelChanged (CL_Object&, long);

    ~UI_ToggleButton(){;};

    
#if defined (__X_MOTIF__)
    static void SelectionCallback (struct _WidgetRec*, void *, void *);

#endif
    
};



#endif /* _toglbtn_h_ */
