




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#ifdef __GNUC__
#pragma implementation
#endif

// ---------------------- Include files --------------------------

#include "base/clntset.h"

#include "ui/visualob.h"
#include "ui/cntroler.h"
#include "ui/composit.h"
#include "ui/dsplsurf.h"
// #include "ui/colormap.h"

#if defined(__MS_WINDOWS__)

#elif defined(__X_MOTIF__)
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/DrawingA.h>
struct _WidgetRec* UI_VisualObject::_shell;

#endif

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_VisualObject>;
#endif


typedef CL_Binding<UI_VisualObject> VObjBind;

// --------------- Initializations of static instance variables --------

UI_Controller*  UI_VisualObject::_Controller  = NULL;
UI_Application* UI_VisualObject::_Application = NULL;


//
//  -----------------Constructor---------------------
//

UI_VisualObject::UI_VisualObject
    (UI_VObjCollection* parent, 
     const UI_Rectangle& shape, UI_ViewID id, long style)
{
    _shape = shape;
#if defined(__MS_WINDOWS__) || defined(__OS2__)
    _style = style;
#elif defined (__X_MOTIF__)
    _xwidget = NULL;

#endif
    _Init (parent, id);
}



#if defined(__MS_WINDOWS__)
UI_VisualObject::UI_VisualObject (UI_VObjCollection* parent,
                                  UI_ViewID id, UI_ViewHandle hndl)
{
    _id = id;
    long n = GetWindowTextLength (hndl);
    char* buf = NULL;
    if (n) {
        buf = new char[n+1];
        GetWindowText (hndl, buf, n+1);
        _title = buf;
        delete buf;
    }
    RECT rec;

    _id = GetWindowWord    (_handle,GWW_ID);  
    _style = GetWindowLong (_handle,GWL_STYLE); 
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
    GetWindowRect (_handle, &rec);
    POINT array[2];
    array[0].x = rec.left;
    array[0].y = rec.top;
    array[1].x = rec.right;
    array[1].y = rec.bottom;
    MapWindowPoints (NULL, parent->ViewHandle(), array, 2);
    UI_Point org (array[0].x, array[0].y);
    UI_Rectangle shp (org, array[1].x-array[0].x, array[1].y-array[0].y);
    _SetShapeRectangle (shp);
    
    _Init (parent, id);
    _handle = hndl;
}
#endif


void UI_VisualObject::_SetShapeRectangle (const UI_Rectangle& r)
{
     VObjBind b (this, &UI_VisualObject::_ShapeRectChanged);
 
    _shape.RemoveDependent (b);
    _shape = r;
    _shape.AddDependent (b, 1);
}


void UI_VisualObject::_SetTitle (const char* p)
{
     VObjBind b (this, &UI_VisualObject::_TitleChanged);
 
    _title.RemoveDependent (b);
    _title = p;
    _title.AddDependent (b, 1);
}


void UI_VisualObject::_Init (UI_VObjCollection* prnt, UI_ViewID idnum)
{
    _borderShown = FALSE;
    _model = NULL;
    _displaySurface = NULL;
    _eventDependents = NULL;
    _id = idnum;
    _parent = prnt;
    _isTabStop = TRUE;

    VObjBind bind (this, &UI_VisualObject::_TitleChanged);
    _title.AddDependent (bind, 1);

    VObjBind b2 (this, &UI_VisualObject::_ShapeRectChanged);
    _shape.AddDependent (b2, 1);
    _ownFont = FALSE;
    _font = NULL;

    if (!_parent)
        _font = NULL;
    else
        _font = _parent->_font;

    _created = FALSE;
    _enabled = TRUE; // At construction time, we assume it's enabled

#if defined(__OS2__)
    _handle = 0;
    _borderHandle = 0;
#endif
    
#if defined(__MS_WINDOWS__)
    _handle = 0;
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;

#else
    _visible = TRUE; // By default, we're visible

#endif
    if (_parent)
        _parent->AddChild (this);
#if defined(__MS_WINDOWS__)
    if (!_parent || !_parent->CreatedViaResource()) {
#else
    {
#endif
        UI_Event* e1 = new UI_Event (Event_MakeInterface, this, _parent);
        _Controller->AddEvent (e1);
    }
}






UI_VisualObject::~UI_VisualObject () 
{
    if ( _parent )
        _parent->RemoveChild (this);
    if ( _displaySurface )
        delete _displaySurface;
    if ( _ownFont )
        delete _font;
    if (_eventDependents) {
        _eventDependents->DestroyContents();
        delete _eventDependents;
    }
}






//
//  -----------------Query---------------------------
//

UI_Rectangle UI_VisualObject::Area() const
{
#if defined(__MS_WINDOWS__)
    RECT msrec;
    GetWindowRect (_handle, &msrec);
    UI_Point p (msrec.left, msrec.top);
    UI_Rectangle rec (p, msrec.right - msrec.left, msrec.bottom - msrec.top);
    return rec;

#elif defined(__OS2__)
    return _shape;
#elif defined(__X_MOTIF__)
    return _shape;
#endif
}





UI_WindowClass UI_VisualObject::WindowClass () const
{
    CL_Error::Warning ("UI_VisualObject::WindowClass: derived class %s"
                       " did not override!", ClassName());
#if defined(__MS_WINDOWS__) || defined(__OS2__)
    return _YACLWindowClassName;
#elif defined(__X_MOTIF__)
    return xmDrawingAreaWidgetClass;
#endif
}

UI_DisplaySurface& UI_VisualObject::CreateDisplaySurface ()
{
    if (!_displaySurface)
        _displaySurface = new UI_DisplaySurface (this);
    _displaySurface->SetFont (_font);
    return *_displaySurface;
}



void UI_VisualObject::DestroyDisplaySurface()
{
    if ( _displaySurface ) {
        delete _displaySurface;
        _displaySurface = NULL;
    }
}


#if defined(__MS_WINDOWS__)

bool UI_VisualObject::CreatedViaResource ()
{
    return _parent &&  _parent->CreatedViaResource();
}


bool UI_VisualObject::Has3DLook () const
{
    return  _parent ? _parent->Has3DLook() : FALSE;
}

#endif


//
//------------------------Event Handling----------------
//

bool UI_VisualObject::HandleEvent (UI_Event* e)
{
    return ProcessEvent (e);
}



bool UI_VisualObject::ProcessEvent (UI_Event* e)
{
    switch (e->Type()) {
    case Event_LButtonPress:
        return ButtonDown (e->curPos.Origin(), UIM_Left,
                           e->_shiftKey, e->_ctrlKey);

    case Event_LButtonRelease:
        return ButtonUp (e->curPos.Origin(), UIM_Left);

    case Event_LButtonDblClk:
        return DoubleClick (e->curPos.Origin(), UIM_Left);

    case Event_MButtonPress:
        return ButtonDown (e->curPos.Origin(), UIM_Middle,
                           e->_shiftKey, e->_ctrlKey);

    case Event_MButtonRelease:
        return ButtonUp (e->curPos.Origin(), UIM_Middle);

    case Event_MButtonDblClk:
        return DoubleClick (e->curPos.Origin(), UIM_Middle);

    case Event_RButtonPress:
        return ButtonDown (e->curPos.Origin(), UIM_Right,
                           e->_shiftKey, e->_ctrlKey);

    case Event_RButtonRelease:
        return ButtonUp (e->curPos.Origin(), UIM_Right);

    case Event_RButtonDblClk:
        return DoubleClick (e->curPos.Origin(), UIM_Right);

    case Event_MouseMove:
        return MouseMove (e->curPos.Origin());

    case Event_ViewEnter:  
        return ViewEnter (e->curPos.Origin());

    case Event_ViewLeave:
        return ViewLeave (e->curPos.Origin());

    case Event_GetFocus:
        return GetFocus ();

    case Event_LoseFocus:
        return LoseFocus ();

    case Event_KeyTyped:
        return KeyTyped (e->key);

    case Event_Paint:
        return _created ? Paint(): FALSE;

    case Event_Reconfigure:
        return Reconfigure (e->curPos);

    case Event_ChildCreated:
        return FALSE;

    case Event_Select:
        return Select ();

    case Event_Iconify:
        return Iconify ();

    case Event_Deiconify:
        return Deiconify ();

    case Event_FullScreen:
        return FullScreen ();

    case Event_CloseDown:
        CloseDown ();
        return FALSE;
        
    default:
        return FALSE;
    }
}



//
//------------------Mouse Events----------------------
//

bool UI_VisualObject::ButtonDown (const UI_Point&, UI_MouseButton, bool, bool)
{
    return FALSE;
}
    

bool UI_VisualObject::ButtonUp (const UI_Point&, UI_MouseButton)
{
    return FALSE;
}


bool UI_VisualObject::DoubleClick (const UI_Point&, UI_MouseButton)
{
    return FALSE;
}


bool UI_VisualObject::ViewEnter (const UI_Point&)
{
    return FALSE;
}


bool UI_VisualObject::ViewLeave (const UI_Point&)
{
    return FALSE;
}

//
//-------------Key Board Events-----------------
//

bool UI_VisualObject::GetFocus()
{
    return FALSE;
}


bool UI_VisualObject::LoseFocus()
{
    return FALSE;
}

bool UI_VisualObject::KeyTyped (char )
{
    return FALSE;
}


bool UI_VisualObject::MouseMove (const UI_Point& )
{
    return FALSE;
}


bool UI_VisualObject::Reconfigure (const UI_Rectangle&)
{
    return FALSE;
}


void UI_VisualObject::CloseDown ()
{
    if (WantToQuit ())
        _Application->Destroy (this);
}


//
//--------------Display Events---------------------
//



bool UI_VisualObject::_TitleChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0) {
        SendMessage (_handle, WM_SETTEXT,  0, (long)(const char*)_title);
    }
#elif defined(__OS2__)
    if (_handle > 0) {
        WinSetWindowText (_handle, _title.AsPtr());
    }
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE; // Not yet set up
    XmString xmtitle;
    xmtitle = XmStringCreate ((char*)_title.AsPtr(),
                              XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (_xwidget, XmNlabelString, xmtitle, NULL);
    XmStringFree (xmtitle);
    XmUpdateDisplay (_xwidget);
#endif
    return TRUE;
}



void UI_VisualObject::MakeVisible ()
{
    _visible = TRUE;

#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        ShowWindow ((long) _handle, SW_SHOW);

#elif defined(__OS2__)
    if (_handle > 0)
        WinShowWindow (_handle, TRUE);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtManageChild   (_xwidget);
#endif
}



void UI_VisualObject::MakeInvisible ()
{
    _visible = FALSE;
#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        ShowWindow ((long)_handle, SW_HIDE);
#elif defined(__OS2__)
    if (_handle > 0)
        WinShowWindow (_handle, FALSE);
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtUnmanageChild (_xwidget); 
#endif
}



bool UI_VisualObject::WantToQuit()
{
    return TRUE;
}

//
//---------------other events-----------------
//


#if defined(__OS2__)
extern VOID AbortPMApp ();
#endif

bool UI_VisualObject::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__)
    short x = _shape.Left();
    short y = _shape.Top ();
    short w = _shape.Width();
    short h = _shape.Height();
    const char* label = (_title.Length() > 0) ? _title.AsPtr() : NULL;
    const char* class_name = WindowClass ();
    HINSTANCE hInst = (HINSTANCE) _Application->ProcessId();
    if (!_visible)
        _style &= ~WS_VISIBLE;
    HWND parentHandle = _parent ? _parent->ViewHandle() : 0;
//     short lowBits = _style & 0x0f;
//     if (lowBits == BS_AUTORADIOBUTTON || lowBits == BS_AUTOCHECKBOX) {
//         parentHandle = GetParent (parentHandle);
//         if (_parent) {
//             UI_Point topLeft = _parent->ClientArea().Origin();
//             x += topLeft.XCoord();
//             y += topLeft.YCoord();
//         }
//     }
    _handle = CreateWindow (class_name, label, _style, x, y, w, h,
                            parentHandle, _id, (HANDLE) hInst, NULL);
    if (!_handle) {
        CL_Error::Warning
            ("YACL: VisualObject CreateWindow failed:\nClass %s ID %d",
             class_name, _id);
        return FALSE;
    }
    return TRUE;

#elif defined(__OS2__)
    long ht = _YACLWindowHeight (_parent ? _parent->ViewHandle()
                                : HWND_DESKTOP);
    long x = _shape.Left();
    long y = ht - _shape.Top() - _shape.Height();
    long w = _shape.Width();
    long h = _shape.Height();
    const char* label = (_title.Length() > 0) ? _title.AsPtr() : NULL;
    UI_WindowClass class_name = WindowClass ();
    if (!_visible)
        _style &= ~WS_VISIBLE;
    HWND parentHandle = _parent ? _parent->ViewHandle() : HWND_DESKTOP;
    if (class_name == WC_BUTTON) {
        ushort styleBits = _style & BS_PRIMARYSTYLES;
        if (styleBits == BS_AUTORADIOBUTTON ||
            styleBits == BS_AUTOCHECKBOX) {
            UI_WindowClass pClass = _parent ? _parent->WindowClass() : 0;
            if (pClass == WC_STATIC) {
                // OS/2 PM doesn't like toggle buttons as children of button
                // groups. So we have yet another hack. Oh well...
                parentHandle = _parent->_parent ? _parent->_parent->_handle
                    : HWND_DESKTOP;
                x += _parent->_shape.Left();
                y += _YACLWindowHeight (parentHandle) -
                    _parent->_shape.Bottom ();
            }
        }
    }
    _handle = WinCreateWindow
        (parentHandle, class_name, label, _style,
         x, y, w, h, parentHandle, HWND_BOTTOM, _id, NULL, NULL);
    if (!_handle) {
        CL_Error::Warning
            ("YACL: VisualObject CreateWindow failed:\nClass %s ID %d",
             class_name, _id);
        return FALSE;
    }
    return TRUE;

#elif defined(__X_MOTIF__)

    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p ? p->ViewHandle() : NULL;

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources

    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    XmStringFree (title);
    XtRealizeWidget (_xwidget);
    return TRUE;

#endif
}


void UI_VisualObject::_PrivateInitialize()
{
    _created = TRUE;
    _Controller->AddEvent (new UI_Event (Event_ChildCreated, this, _parent));
#if defined(__MS_WINDOWS__)
    if (!_enabled)
        EnableWindow   (_handle, FALSE);
    if (!_visible)
        ShowWindow   (_handle, SW_HIDE);
//     if (Has3DLook()) {
//         COLORREF color = GetSysColor (COLOR_BTNFACE);
//         // We're using Ctl3d; otherwise  we would want COLOR_WINDOW
//         _bgColor = UI_Color (GetRValue (color)/((float) UI_MAXCOLORS),
//                              GetGValue (color)/((float) UI_MAXCOLORS),
//                              GetBValue (color)/((float) UI_MAXCOLORS));
//     }
//     else
//         _bgColor = UIColor_White; 

#elif defined(__OS2__)
    if (!_enabled)
        WinEnableWindow   (_handle, FALSE);
    if (!_visible)
        WinShowWindow   (_handle, FALSE);
    _DoShowBorder (_borderShown);
#elif defined(__X_MOTIF__)
    if (!_enabled)
        XtSetSensitive (_xwidget, FALSE);
    if (_borderShown)
        XtVaSetValues (_xwidget, XmNborderWidth, 2, NULL);
#endif        
        
#if defined(__MS_WINDOWS__)
    CL_String my_name (WindowClass());
    if (my_name(0,4) == "menu")  // Hack to fix menus
        return;
    if (_handle > 0) {
        RECT msrec;
        GetClientRect (_handle, &msrec);
        POINT ms_pt;
        ms_pt.x = ms_pt.y = 0;
        HWND parentHandle = _parent ? _parent->_handle : GetDesktopWindow();
        MapWindowPoints (_handle, parentHandle, &ms_pt, 1);
        UI_Rectangle rec (ms_pt.x, ms_pt.y, msrec.right - msrec.left + 1,
	                  msrec.bottom - msrec.top + 1);
        _SetShapeRectangle (rec);
    }
#endif

    if (_font) {
        VObjBind b (this, (VObjBind::MethodPtr)
                    &UI_VisualObject::_FontChanged);
        _font->AddDependent (b, 1);
    }
}



bool UI_VisualObject::DestroyVisualElement()
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0 && !_parent->CreatedViaResource()) {
        DestroyWindow (_handle);
        return TRUE;
    }
#elif defined(__X_MOTIF__)
    if ( _xwidget ) {
        XtUnmanageChild (_xwidget);
        XtDestroyWidget (_xwidget);
        return TRUE;
    }
#elif defined(__OS2__)
    WinDestroyWindow (_handle);
#endif
    return TRUE;
}


bool UI_VisualObject::Enable ()
{
    _enabled = TRUE;
#if defined(__MS_WINDOWS__)
    return _handle ? EnableWindow   (_handle, TRUE) : TRUE;
#elif defined(__OS2__)
    return _handle ? WinEnableWindow   (_handle, TRUE) : TRUE;
#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtSetSensitive (_xwidget, TRUE);
    return TRUE;
#endif

}



bool UI_VisualObject::Disable()
{
    _enabled = FALSE;
#if defined(__MS_WINDOWS__)
    return _handle ? EnableWindow (_handle, FALSE) : TRUE;
#elif defined(__OS2__)
    return _handle ? WinEnableWindow   (_handle, FALSE) : TRUE;

#elif defined(__X_MOTIF__)
    if (_xwidget)
        XtSetSensitive (_xwidget, FALSE);
    return TRUE;

#endif
}


void UI_VisualObject::Invalidate ()
{
#if defined(__MS_WINDOWS__)
    if (_handle)
        InvalidateRect (_handle, NULL, TRUE);
#elif defined(__OS2__)
    if (_handle) {
        RECTL rect;
        WinQueryWindowRect (_handle, &rect);
        WinInvalidateRect  (_handle, &rect, TRUE);
        WinUpdateWindow    (_handle);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget && XtIsRealized (_xwidget))
        XClearArea (XtDisplay (_xwidget), XtWindow (_xwidget),
                    0, 0, 0, 0, TRUE);
#else
    NotImplemented ("Invalidate");
#endif
}


#if defined(__X_MOTIF__)
CL_String UI_VisualObject::InstanceName()
{
    if (!_instanceName.Size())
        _instanceName = _Application->InstanceName (this);
    return _instanceName;
}
#endif

bool UI_VisualObject::_ShapeRectChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle <= 0)
        return TRUE;
    RECT rect = _shape.AsMSRect ();
    AdjustWindowRect (&rect, _style, FALSE);
    if (Has3DLook ()) 
        MoveWindow (_handle, rect.left-1, rect.top-1,
                    rect.right-rect.left+3, rect.bottom-rect.top+3, TRUE);
    else
        MoveWindow (_handle, rect.left, rect.top,
                    rect.right-rect.left+1, rect.bottom-rect.top+1, TRUE);
    // Maybe this is because need to correct for Ctl3d problems. I'm not sure
    // why Windows needs co-ordinates fixed up like this.
    return TRUE;

#elif defined(__OS2__)
    if (_handle <= 0)
        return TRUE;
    long ht = _YACLWindowHeight (_parent ? _parent->ViewHandle()
                                : HWND_DESKTOP);
    long y = ht - _shape.Top() - _shape.Height();
    WinSetWindowPos (_handle, HWND_TOP, _shape.Left(), y,
                     _shape.Width(), _shape.Height(),
                     SWP_SIZE | SWP_MOVE);
    return TRUE;
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE;
    Position  x = _shape.Origin().XCoord();
    Position  y = _shape.Origin().YCoord();
    Dimension w = _shape.Width();
    Dimension h = _shape.Height();
    XtVaSetValues (_xwidget, XtNx, x, XtNy, y, XtNwidth, w,
                   XtNheight, h, NULL);
    XmUpdateDisplay (_parent ? _parent->_xwidget : _xwidget);
    return TRUE;
#endif
}


#if defined(__MS_WINDOWS__) || defined(__OS2__)
void UI_VisualObject::TakeFocus ()
{
    _Controller->GiveFocusTo (*this);
}

#endif


UI_Font& UI_VisualObject::Font()
{
    // If someone is asking for our font, we'll assume they're trying to
    // modify our font.
    if (!_ownFont) {
        VObjBind b (this, &UI_VisualObject::_FontChanged);
        if (_font)
            _font->RemoveDependent (b);
        _MakeNewFont ();
        if ( _displaySurface )
            _displaySurface->SetFont ( _font );
        _font->AddDependent (b, 1);
    }
    return *_font;
}



UI_Font* UI_VisualObject::OurFont ()
{
    return _ownFont ? _font : _parent->OurFont();
}


bool UI_VisualObject::_FontChanged (CL_Object&, long)
{
    return FALSE;
}

bool UI_VisualObject::SetFont (UI_Font* f)
{
    if (_ownFont || _font == f)
        return FALSE;
    VObjBind b (this, &UI_VisualObject::_FontChanged);
    if (_font)
        _font->RemoveDependent (b);
    _font = f;
    if (_font)
        _font->AddDependent (b, 1);
    return TRUE;
}




void UI_VisualObject::_MakeNewFont ()
{
    if (!_ownFont) {
        if (_parent && _parent->_font)
            _font = new UI_Font (*(_parent->_font));
        else {
            _font = new UI_Font (this);
        }
        SetFont (_font);
        _ownFont = TRUE;
    }
}



void UI_VisualObject::Foreground (const UI_Color& c)
{
    _fgColor = c;
#if defined (__X_MOTIF__)
    if (!ViewHandle())
        return;
    UI_DwgSurfHandle hdc;
    ulong h ;
    XColor xcolor = c.NativeForm ();
    Display *dpy = XtDisplay (_xwidget);
    short screen_num = DefaultScreen (dpy);
    XAllocColor (dpy, DefaultColormap (dpy, screen_num), &xcolor);
    h = xcolor.pixel;
    if (!_displaySurface) {
        XGCValues xvalues;
        hdc = XCreateGC (dpy, XtWindow (_xwidget), 0, &xvalues);
        XSetForeground (XtDisplay (_xwidget), hdc, h);
        XFreeGC (XtDisplay (_xwidget), hdc);
    }
    else {
        hdc = _displaySurface->Handle();
        XSetForeground (XtDisplay (_xwidget), hdc, h);
    }
//    if (!_displaySurface) {
//         XGCValues xvalues;
//         XColor xcolor = c.NativeForm ();
//         Display *dpy = XtDisplay (_xwidget);
//         short screen_num = DefaultScreen (dpy);
//         hdc = XCreateGC (dpy, XtWindow (_xwidget), 0, &xvalues);
//         XAllocColor (dpy, DefaultColormap (dpy, screen_num), &xcolor);
//         h = xcolor.pixel;
//         XSetForeground (XtDisplay (_xwidget), hdc, h);
//         XFreeGC (XtDisplay (_xwidget), hdc);
//     }
//     else {
//         hdc = _displaySurface->Handle();
//         h   = (_displaySurface->ColorMap().Match (c));
//         XSetForeground (XtDisplay (_xwidget), hdc, h);
//     }
#endif
}



void UI_VisualObject::Background (const UI_Color& c)
{
    _bgColor = c;
#if defined (__MS_WINDOWS__)
    if (_displaySurface) {
        HDC hdc = _displaySurface->Handle();
        if (hdc)
            SetBkColor (hdc, c.NativeForm ());
    }
    
#elif defined (__X_MOTIF__)
    ulong h ;
    UI_DwgSurfHandle hdc;
    //    if (_displaySurface == NULL) {
        XGCValues xvalues;
        XColor xcolor = c.NativeForm ();
        Display *dpy = XtDisplay (_xwidget);
        short screen_num = DefaultScreen (dpy);
        hdc = XCreateGC (dpy, XtWindow (_xwidget), 0, &xvalues);
        XAllocColor (dpy, DefaultColormap (dpy, screen_num), &xcolor);
        h = xcolor.pixel;
        XSetBackground (XtDisplay (_xwidget), hdc, h);
        XFreeGC (XtDisplay (_xwidget), hdc);
//     }
//     else {
//         hdc = _displaySurface->Handle();
//         h   = (_displaySurface->ColorMap().Match (c));
//         XSetBackground (XtDisplay (_xwidget), hdc, h);
//     }
#endif
}



#if defined(__X_MOTIF__)
void UI_VisualObject::_SetupStyle (void* p, short& argn)
{
    argn = 0;
    Arg* arg = (Arg*) p;

    short x = _shape.Left   ();
    short y = _shape.Top    ();
    short w = _shape.Width  ();
    short h = _shape.Height ();

    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;
    if (_borderShown)
        XtSetArg (arg [ argn++ ], XmNborderWidth, 2);
}
#endif

#if defined (__MS_WINDOWS__)
void UI_VisualObject::SetStyle (ulong style)
{
    _style = style;
}
#endif

bool UI_VisualObject::AddEventDependent
    (UI_EventType evt, const CL_AbstractBinding& bind, long p)
{
    if (!_eventDependents)
        _eventDependents = new CL_IntPtrMap;
    if (!_eventDependents)
        return FALSE; // No memory
    CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[(long) evt];
    if (!set) {
        set = new CL_ClientSet;
        if (!set)
            return FALSE; // No memory
        _eventDependents->Add ((long) evt, set);
    }
    return set->Add (bind, p);   
}



bool UI_VisualObject::RemoveEventDependent
    (UI_EventType evt, const CL_AbstractBinding& bind)
{
    if (!_eventDependents)
        return FALSE;
    CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[(long) evt];
    if (!set)
        return FALSE;
    return set->Remove (bind);
}


bool UI_VisualObject::IsIconified ()
{
    return _parent && _parent->IsIconified();
}


bool UI_VisualObject::ShowBorder ()
{
    return _DoShowBorder (TRUE);
}


bool UI_VisualObject::HideBorder ()
{
    return _DoShowBorder (FALSE);
}

void UI_VisualObject::ScrollView
    (const UI_Rectangle& scrollArea, short xAmount, short yAmount)
{
#if defined(__MS_WINDOWS__)
    if (_handle) {
        UpdateWindow (_handle);
        RECT r = scrollArea.AsMSRect();
        ScrollWindow (_handle, xAmount, yAmount, &r, NULL);
    }
#elif defined(__OS2__)
    if (_handle) {
        UI_Rectangle area = ClientArea ();
        RECTL rect;
        rect.xLeft    = scrollArea.Left();
        rect.yBottom  = area.Height() - scrollArea.Bottom () + 1;
        rect.xRight   = scrollArea.Right();
        rect.yTop     = area.Height() + 1 - scrollArea.Top ();
        WinScrollWindow (_handle, xAmount, yAmount, &rect, NULL, NULLHANDLE,
                         NULL, SW_INVALIDATERGN);
    }
#elif defined(__X_MOTIF__)
    NotImplemented ("ScrollView");
#endif
}


bool UI_VisualObject::_DoShowBorder (bool shown)
{
    _borderShown = shown;
#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        _style = GetWindowLong (_handle, GWL_STYLE);
    _style = shown ? (_style | WS_BORDER) : (_style & ~WS_BORDER);
    if (_handle > 0) {
        SetWindowLong (_handle, GWL_STYLE, _style);
        SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_SHOWWINDOW | 
                       SWP_NOSIZE | SWP_NOMOVE | 
                       SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
    }
#elif defined(__OS2__)
    if (!shown) {
        if (_borderHandle)
            WinShowWindow (_borderHandle, FALSE);
    }
    else {
        if (!_parent)
            return FALSE; // Don't care about root window
        HWND parentHandle = _parent->ViewHandle();
        if (!_borderHandle)
            _borderHandle = WinCreateWindow
                (parentHandle, WC_STATIC, NULL, WS_VISIBLE | SS_FGNDFRAME,
                 _shape.Left() - 1,
                 _YACLWindowHeight (parentHandle) - _shape.Bottom() - 2,
                 _shape.Width()+2, _shape.Height()+2, parentHandle,
                 HWND_BOTTOM, 0, NULL, NULL);
        WinShowWindow (_borderHandle, TRUE);
    }
#elif defined(__X_MOTIF__)
    if (_xwidget) {
        XtVaSetValues (_xwidget, XmNborderWidth, shown ? 2 : 0, NULL);
    }
#endif
    return TRUE;
}


bool UI_VisualObject::_PrivateHandleEvent (UI_Event* e)
{
    if (e->Type() == Event_Reconfigure)
        _SetShapeRectangle (e->curPos);
    bool b = HandleEvent (e);
    bool p = TRUE;
    if (_eventDependents) {
        CL_ClientSet* set = (CL_ClientSet*) (*_eventDependents)[e->Type()];
        if (set)
            p = set->Permits (*e);
    }
    // b will be TRUE if this object itself handled the event. p will be
    // TRUE if all the event dependents permitted the event to proceed up
    // the view tree, because none of them handled it.
    return b || !p; // If none of the dependents handled the event, they
                    // will all return TRUE, so we return FALSE.
}



void UI_VisualObject :: _SetModelValue (const CL_Object& value)
{
    CL_Object* model = _model;
    if ( !model )
        return;
    VObjBind bnd (this, &UI_VisualObject::_ModelChanged);
    model->RemoveDependent (bnd);
    *model = value;
    model->AddDependent (bnd, 1);
}


#if defined(__OS2__)
long _YACLWindowHeight (UI_ViewHandle h)
{
    RECTL windowRect;
    if (!WinQueryWindowRect (h, &windowRect))
        return 0;
    return windowRect.yTop - windowRect.yBottom + 1;
}

#endif
