

// A small calendar program using YACL
//
// M. A. Sridhar
// Dec 25, 1993

#include "ui/ui.h"


// ======================== Class AppWindow ===========================

#define ID_NEXT 10
#define ID_PREV 11
#define ID_CAL  12


class CalendarView: public UI_MonthCalendar {
public:
    CalendarView (UI_CompositeVObject* parent, const UI_Rectangle& shape,
                  UI_ViewID id)
    : UI_MonthCalendar (parent, shape, id) {};

    void ClickOnDay (short day); // Override inherited method
};


void CalendarView::ClickOnDay (short day)
{
    CL_String msg;
    msg.AssignWithFormat ("You clicked on %d", day);
    UI_SimpleDialog (msg.AsPtr(), "Calendar");
}



class AppWindow: public UI_CompositeVObject {

public:
    AppWindow ();

    // Override the Composite's virtual method:
    bool HandleChildEvent (const UI_Event& e);

protected:
    CalendarView* cal;
    UI_PushButton* prev, *next;

};

    
AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (50, 50, 290, 320))
{
    cal  = new CalendarView  (this, UI_Rectangle (0,0, 270, 230), ID_CAL);
    prev = new UI_PushButton (this, UI_Rectangle (50, 250, 40, 30), ID_PREV);
    (prev->Title()) = "<";
    next = new UI_PushButton (this, UI_Rectangle (120, 250, 40, 30), ID_NEXT);
    (next->Title()) = ">";
}


bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() == Event_Select) {
        if (e.Origin()->ViewID() == ID_NEXT)
            cal->AdvanceMonth();
        else if (e.Origin()->ViewID() == ID_PREV)
            cal->PreviousMonth();
	return TRUE;
    }
    return FALSE;
}




// ========================== Main program ==========================


int UI_Application::Main (int, char* [])
{
    MakeTopWindow (new AppWindow);
    MainWindow()->Title() = "YACL Calendar Demo";
    Run();
    return 0;
}
