

#include "ui/ui.h"
#include "ui/interval.h"
#include "appwin.h"

#include <iostream.h> // DEBUG
#define ID_MESSAGE 10
const int MaxColor = 100;

typedef CL_Binding<AppWindow> Bind;

#if defined(__GNUC__)
template class CL_Binding<AppWindow>;
#endif

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (50, 50, 600, 300))
{
    _red      = new UI_Label (this, UI_Rectangle (260, 10, 80, 30));
    _blue     = new UI_Label (this, UI_Rectangle (360, 10, 80, 30));
    _green    = new UI_Label (this, UI_Rectangle (460, 10, 90, 30));
    _redBar   = new UI_VScrollBar (this, UI_Rectangle (300, 50, 20, 150), 10);
    _blueBar  = new UI_VScrollBar (this, UI_Rectangle (400, 50, 20, 150), 11);
    _greenBar = new UI_VScrollBar (this, UI_Rectangle (500, 50, 20, 150), 12);

    _redBar  ->Range() = CL_Interval (0, MaxColor);
    _greenBar->Range() = CL_Interval (0, MaxColor);
    _blueBar ->Range() = CL_Interval (0, MaxColor);

    Bind bind (this, (Bind::MethodPtr) &AppWindow::DoScroll);
    _redBar  ->ClientSet().Add (bind, 1);
    _greenBar->ClientSet().Add (bind, 1);
    _blueBar ->ClientSet().Add (bind, 1);

    _title = "YACL Color Demo";
}

AppWindow::~AppWindow()
{
    DestroyDisplaySurface ();
}


void AppWindow::Initialize ()
{
    CreateDisplaySurface ();
}


UI_VisualObject::ViewSize   AppWindow::MinSize () const
{
    return UI_VisualObject::ViewSize (550, 275);
}


UI_VisualObject::ViewSize   AppWindow::MaxSize () const
{
    return UI_VisualObject::ViewSize (700, 450);
}



bool AppWindow::Paint ()
{
    long red, green, blue;
    red   = ((CL_Interval&) _redBar  ->Model()).Low();
    green = ((CL_Interval&) _greenBar->Model()).Low();
    blue  = ((CL_Interval&) _blueBar ->Model()).Low();
    
    UI_Color color (red/((double) MaxColor), green/((double) MaxColor),
                    blue/((double) MaxColor));
    _displaySurface->ColorRectangle (UI_Rectangle (30, 20, 200, 200),
                                     color);
    _red  ->Title() = "Red: "   + CL_String (red);
    _blue ->Title() = "Blue: "  + CL_String (blue);
    _green->Title() = "Green: " + CL_String (green);
    return FALSE;
}

bool AppWindow::DoScroll (CL_Object&, long)
{
    return Paint ();
}


