
#include "appwin.h"
#include "ui/stddlg.h"
#include "ui/applic.h"


#define ID_BUTTON 10
#define ID_LABEL  11
#define ID_BOX    12


AppWindow::AppWindow()
: UI_Dialog (NULL, NULL, UI_Rectangle (40, 40, 400, 300))
{
    _btn   = new UI_PushButton (this, UI_Rectangle (95, 200, 75, 30),
                                ID_BUTTON);
    _lbl   = new UI_Label    (this, UI_Rectangle (55, 50, 245, 20),  ID_LABEL);
    _box   = new UI_ComboBox (this, UI_Rectangle (55, 90, 245, 100), ID_BOX,
                              FALSE);

    UI_StringSequence& model = (UI_StringSequence&) _box->Model();
    model.Add ("Word for Windows");
    model.Add ("WordPerfect");
    model.Add ("Freelance");
    model.Add ("PowerPoint");
    model.Add ("CorelDraw!");
    model.Add ("PC Anywhere");
    model.Add ("Carbon Copy");
    _btn->Title() = "Show";
    _title = "YACL ComboBox Demo";
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin() == _btn && e.Type() == Event_Select) {
        _lbl->Title() = "Selection: '" + _box->EditString() + "'";
        return TRUE;
    }
    return FALSE;
}


