

#include "appwin.h"
#include "ui/ui.h"

#define ID_LIST  101
#define ID_LABEL 102

UI_ViewDescriptor desc [] = {
{View_Label,       ID_LABEL,    10, 10, 280,  30,  FALSE, ""},
{View_StringView,  ID_LIST,     75, 50, 150, 200,  FALSE, ""},
{View_None, 0, 0}
};

AppWindow::AppWindow ()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (20, 50, 300, 300))
{
    Title () = "YACL Environment Demo";
    UI_Label& label = (UI_Label&) *((*this)[ID_LABEL]);
    label.ShowBorder ();
    label.SetTextStyle (UIText_Left);

    UI_StringSequence& strSeq = (UI_StringSequence&)
        ((*this)[ID_LIST]->Model());
    const CL_StringStringMap& env = _Application->Environment ();
    CL_StringStringMapIterator itr (env);

    while (itr.More())
        strSeq.Add (itr.Next().key);
}


bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select)
        return FALSE;
    // The only Select event we'll get is from the StringView, so we don't
    // need to check its view id.
    UI_StringViewSingleSel& strView = *(UI_StringViewSingleSel *)
        ((*this)[ID_LIST]);
    long select = strView.Selection ();
    UI_StringSequence& strseq = (UI_StringSequence&) strView.Model();
    (*this)[ID_LABEL]->Model() = (_Application->Environment())
        [strseq[select]];
    return TRUE;
}

    
