

#include "appwin.h"
#include "ui/ui.h"


#define ID_UNDERLINE 101
#define ID_STRIKEOUT 102
#define ID_POINTSIZE 103
#define ID_BUTTON    104
#define ID_FONTLIST  105


class SampleStringCanvas: public UI_Canvas {

public:
    SampleStringCanvas (UI_CompositeVObject* parent, const UI_Rectangle& r)
    : UI_Canvas (parent, r, -1) {};

    short DrawSample ();

protected:
    bool Paint ();
};

AppWindow::AppWindow ()
: UI_Dialog (NULL, NULL, UI_Rectangle (20, 50, 500, 400)),
  _allFonts (UI_Font::AvailableFonts())
{
    Title () = "YACL Font Demo";
    long n = _allFonts.Size();
    for (long i = 0; i < n; i++) {
        CL_String s = _allFonts[i].AsString();
        _strSeq.Add (s);
    }
    _strView = new UI_StringViewSingleSel
        (this, &_strSeq, UI_Rectangle (25, 20, 325, 200), ID_FONTLIST);
    _canvas = new SampleStringCanvas (this, UI_Rectangle (25, 250, 450,
                                                          70));
    _canvas->ShowBorder ();
    _label     = new UI_Label        (this, UI_Rectangle (25,  340, 450, 30));
    _pointSize = new UI_StringEditor (this, UI_Rectangle (375,  50,  30, 30),
                                      ID_POINTSIZE);
    _pointSize->Model() = CL_String ("14"); // Default point size
    UI_Label* lbl = new UI_Label (this, UI_Rectangle (410,  70,  70, 30));
    lbl->Title() = "points";
    _underline = new UI_ToggleButton (this, UI_Rectangle (375, 100, 100, 30),
                                      ID_UNDERLINE);
    _strikeOut = new UI_ToggleButton (this, UI_Rectangle (375, 130, 100, 30),
                                      ID_STRIKEOUT);
    _button    = new UI_PushButton   (this, UI_Rectangle (375, 160,  80, 30),
                                      ID_BUTTON);
    _underline->Title() = "Underline";
    _strikeOut->Title() = "Strike out";
    _button   ->Title() = "Apply";
}


bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Type() != Event_Select || e.Origin()->ViewID() != ID_BUTTON)
        return FALSE;
    long n = _strView->Selection();
    if (n < 0)
        return TRUE; // No selection

    // Set the canvas' font:
    short pointSize = _allFonts[n].IsScalable()
        ? ((CL_String&) _pointSize->Model()).AsLong()
        : _allFonts[n].PointSize();
    if (pointSize < 4) {
        UI_SimpleDialog ("Point size too small.");
        return TRUE;
    }
    ulong ul =  ((CL_Integer&) _underline->Model()) ? UIFont_Underline : 0;
    ulong so =  ((CL_Integer&) _strikeOut->Model()) ? UIFont_StrikeOut : 0;
    ulong style = _allFonts[n].Style() | ul | so;
    UI_FontDesc d (_allFonts[n].TypeFace(), pointSize, style);
    _canvas->Font() = d;

    // Draw the sample strings:
    short npxl = _canvas->DrawSample ();

    // Update the label:
    short ht   = _canvas->Font().Height() * 2;
    CL_String s;
    s.AssignWithFormat ("Text rectangle is %d x %d pixels", npxl, ht);
    _label->Title() = s;

    // All done:
    return TRUE;
}


#define _Sample1 "Pack my box with"
#define _Sample2 "five dozen liquor jugs"

short SampleStringCanvas::DrawSample ()
{
    UI_DisplaySurface& sfc = *(DisplaySurface());
    sfc.ClearDisplay ();
    short w = ClientArea().Width();
    short h = ClientArea().Height();
    sfc.WriteString (_Sample1, UI_Rectangle (0, 10, w, h), UIText_Center);
    sfc.WriteString (_Sample2, UI_Rectangle (0, 10 + sfc.Font().Height(),
                                             w, h),
                   UIText_Center);
    return maxl (sfc.TextWidth (_Sample1), sfc.TextWidth (_Sample2));
}


bool SampleStringCanvas::Paint ()
{
    if (((UI_StringViewSingleSel*) ((*Parent())[ID_FONTLIST]))->Selection()
        > 0)
        DrawSample();
    return TRUE;
}

