
#include "ui/ui.h"
#include "appwin.h"

#define MESSAGE "Click and hold mouse to begin drawing"

AppWindow::AppWindow()
: UI_CompositeVObject (NULL, NULL, FALSE, UI_Rectangle (50, 50, 500, 300))
{
    Title() = "YACL Graphics Demo 1";
    _status = new UI_Label (this, UI_Rectangle (50, 50, 400, 30));
    _status->Title() = MESSAGE;
    _inDrag = FALSE;
}

AppWindow::~AppWindow()
{
    DestroyDisplaySurface ();
}


void AppWindow::Initialize ()
{
    UI_CompositeVObject::Initialize();
    _bgColor = UIColor_White; // The Canvas class sets up its own background
                              // color, but this sample program does not use
                              // the Canvas class.
    CreateDisplaySurface ();
}



bool AppWindow::ButtonDown (const UI_Point& p, UI_MouseButton m,
                            bool, bool)
{
    if (m != UIM_Left)
        return FALSE;
    _startPt = p;
    _inDrag = TRUE;
    _Controller->GiveMouseTo (*this);
    _displaySurface->Pen().Pattern (UIPen_Dot);
    _displaySurface->Pen().Color   (UIColor_Red);
    _displaySurface->Mode (UI_DisplaySurface::GMode_Xor);
    return TRUE;
}


bool AppWindow::MouseMove (const UI_Point& p)
{
    if (!_inDrag)
        return TRUE;
    long wd = p.XCoord() - _startPt.XCoord();
    long ht = p.YCoord() - _startPt.YCoord();
    _displaySurface->DrawRectangle (_rect); // Erase the old rectangle
    UI_Rectangle r (_startPt, wd, ht);
    _displaySurface->DrawRectangle (r);        // Draw the new rectangle
    _rect = r;
    (_status->Model()) = CL_String (wd) + " x " + CL_String(ht);
    return TRUE;
}



bool AppWindow::ButtonUp (const UI_Point& p, UI_MouseButton m)
{
    if (m != UIM_Left)
        return FALSE;
    _inDrag = FALSE;
    _Controller->ReleaseMouse();
    _displaySurface->DrawRectangle (_rect);   // Erase the old rectangle
    _displaySurface->Pen().Pattern (UIPen_Solid);
    _displaySurface->Mode (UI_DisplaySurface::GMode_Copy);
    UI_Rectangle s (_startPt, p.XCoord() - _startPt.XCoord(),
                    p.YCoord() - _startPt.YCoord());
    _displaySurface->DrawRectangle (s);       // Draw a solid rectangle
    _rect = UI_Rectangle (0, 0, 0, 0);
    _status->Title() = MESSAGE;
    return TRUE;
}

