

// A second "hello, world" program using YACL


#include "ui/ui.h"
#include "ui/composit.h"


// ======================== Class AppWindow ===========================

#define ID_BUTTON 10
#define ID_LABEL  11
UI_ViewDescriptor desc[] = {
    {View_PushButton, ID_BUTTON,  75, 80, 225, 50, TRUE, "", 0},
    {View_Label,      ID_LABEL, 55, 50, 245, 20, FALSE, "",  0},
    {View_None, -1, 0, 0, 0, 0, 0, 0}
};

class AppWindow: public UI_CompositeVObject {

public:
    AppWindow ();

    // Override the Composite's virtual method:
    bool HandleChildEvent (const UI_Event& e);

    bool WantToQuit();
    
protected:
    short count;
};

    
AppWindow::AppWindow()
: UI_CompositeVObject (NULL, desc, FALSE, UI_Rectangle (50, 50, 400, 300)),
  count (5)
{
    (*this)[ID_BUTTON]->Title() =
        "Click here " + CL_String(count) + " times.";
}

bool AppWindow::HandleChildEvent (const UI_Event& e)
{
    if (e.Origin()->ViewID() == ID_BUTTON &&
        e.Type() == Event_Select) {
        count--;
        if (count == 0) {
            _Application->Destroy (this);
            // Do an _Application->End() if we want conditional termination
        }
        else {
            (*this)[ID_BUTTON]->Title() =
                "Click here " + CL_String(count) + " times.";
            switch (count) {
            case 4: {
                UI_Font& font = Font();
                font = UI_FontDesc ("Courier", 11, UIFont_Italic);
                break;
            }

            case 2: {
                UI_Font& font = e.Origin()->Font();
                font = UI_FontDesc ("Times New Roman", 14, UIFont_StrikeOut
                                    | UIFont_Italic);
                break;
            }
                
            case 1: {
                UI_Font& font = (*this)[ID_LABEL]->Font();
                font = UI_FontDesc ("Courier", 8, UIFont_Underline);
                break;
            }
                
            default:
                break;
            }
        }
        return TRUE;
    }
    return FALSE;
}


bool AppWindow::WantToQuit()
{
    return (UI_SimpleDialog ("Do you really want to quit?", UIS_YesNo,
                             UIS_Question, this) == UI_IDYES);
}



// ======================== Main program ===========================


int UI_Application::Main (int /* argc */, char* [])
{
    UI_CompositeVObject* mainWin = new AppWindow;
    MakeTopWindow (mainWin);
    (*mainWin)[ID_LABEL]->Title() = "Hello, world, this is YACL!";
    Run();
    return 0;
}



