

#include "ui/ui.h"

#include "menudrv.h"
#include "appwin.h"
#include "ids.h"

#ifdef __BORLANDC__
extern unsigned _stklen = 35000;
#endif

UI_MenuItemDescriptor App1Submenu [] = {
  {"A one",     ID_SUBMENU1, NULL}
, {"A two",     ID_SUBMENU2, NULL}
, {NULL,        0, NULL}
};

UI_MenuItemDescriptor App1Menu [] = {
  {"&Jan",      ID_JAN,    NULL}
, {"&Feb",      ID_FEB,    NULL}
, {"&Mar",      ID_MAR,    App1Submenu}
, {"---",       NULL,      NULL} // Separator
, {"&Apr",      ID_APR,    NULL}
, {"Ma&y",      ID_MAY,    NULL}
, {NULL,        0,         NULL}
};

UI_MenuItemDescriptor App2Menu [] = {
    {"Monday",      ID_MON,  NULL}
  , {"Tuesday",     ID_TUE,  NULL}
  , {"Wednesday",   ID_WED,  NULL}
  , {0,             0,   NULL}
};


UI_MenuItemDescriptor MainMenuDesc [] = {
    {"&One",   ID_APP1, App1Menu}
  , {"&Two",   ID_APP2, App2Menu}
  , {NULL,     0, NULL}
};



typedef CL_Binding<MenuDriver> MenuBinding;


// ======================== Main program ===========================


int UI_Application::Main (int, char* [])
{
    AppWindow* root = new AppWindow;
    MakeTopWindow (root);
    UI_MenuBar*     mainMenu =  new UI_MenuBar (root, MainMenuDesc);
    MenuDriver driver;
    driver.Setup (mainMenu);

    Run();
    return 0;
}

