VERSION 4.00
Begin VB.Form frmObjects 
   Caption         =   "Object Selection"
   ClientHeight    =   5775
   ClientLeft      =   1170
   ClientTop       =   1140
   ClientWidth     =   6165
   Height          =   6180
   HelpContextID   =   250
   Left            =   1110
   LinkTopic       =   "Form1"
   ScaleHeight     =   5775
   ScaleWidth      =   6165
   Top             =   795
   Width           =   6285
   Begin VB.ListBox lstQueries 
      Height          =   2760
      HelpContextID   =   420
      Left            =   3240
      MultiSelect     =   2  'Extended
      TabIndex        =   3
      Tag             =   "List of Available Queries"
      Top             =   1080
      Width           =   2775
   End
   Begin VB.CheckBox chkRelations 
      Caption         =   "Print Table Relations"
      Height          =   255
      HelpContextID   =   440
      Left            =   3720
      TabIndex        =   11
      Tag             =   "Print Table Relations"
      Top             =   240
      Width           =   1935
   End
   Begin VB.CheckBox chkGeneral 
      Caption         =   "Print General Database Information"
      Height          =   255
      HelpContextID   =   460
      Left            =   360
      TabIndex        =   10
      Tag             =   "Print General Database Information"
      Top             =   240
      Width           =   2895
   End
   Begin VB.CommandButton cmdAllTables 
      Caption         =   "Deselect All Tables"
      Height          =   375
      HelpContextID   =   480
      Index           =   1
      Left            =   360
      TabIndex        =   9
      Tag             =   "Deselect All Tables"
      Top             =   4440
      Width           =   2175
   End
   Begin VB.CommandButton cmdAllQueries 
      Caption         =   "Deselect All Queries"
      Height          =   375
      HelpContextID   =   500
      Index           =   1
      Left            =   3480
      TabIndex        =   8
      Tag             =   "Deselect All Queries"
      Top             =   4440
      Width           =   2295
   End
   Begin VB.CommandButton cmdExit 
      Cancel          =   -1  'True
      Caption         =   "Exit"
      Height          =   375
      HelpContextID   =   520
      Left            =   3480
      TabIndex        =   7
      Tag             =   "Return to the Main Menu"
      Top             =   5160
      Width           =   1935
   End
   Begin VB.CommandButton cmdRun 
      Caption         =   "Run Analysis"
      Height          =   375
      HelpContextID   =   540
      Left            =   600
      TabIndex        =   6
      Tag             =   "Print the selected database information"
      Top             =   5160
      Width           =   1935
   End
   Begin VB.CommandButton cmdAllQueries 
      Caption         =   "Select All Queries"
      Height          =   375
      HelpContextID   =   560
      Index           =   0
      Left            =   3480
      TabIndex        =   5
      Tag             =   "Select All Queries"
      Top             =   3960
      Width           =   2295
   End
   Begin VB.CommandButton cmdAllTables 
      Caption         =   "Select All Tables"
      Height          =   375
      HelpContextID   =   580
      Index           =   0
      Left            =   360
      TabIndex        =   4
      Tag             =   "Select All Tables"
      Top             =   3960
      Width           =   2175
   End
   Begin VB.ListBox lstTables 
      Height          =   2760
      HelpContextID   =   600
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   2
      Tag             =   "List of Available Tables"
      Top             =   1080
      Width           =   2655
   End
   Begin VB.Line Line3 
      X1              =   3000
      X2              =   3000
      Y1              =   720
      Y2              =   4920
   End
   Begin VB.Line Line2 
      X1              =   120
      X2              =   6000
      Y1              =   4920
      Y2              =   4920
   End
   Begin VB.Line Line1 
      X1              =   120
      X2              =   6000
      Y1              =   720
      Y2              =   720
   End
   Begin VB.Label Label2 
      Caption         =   "QueryDefs to Analyze:"
      Height          =   255
      Left            =   3960
      TabIndex        =   1
      Top             =   840
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "Tables to Analyze:"
      Height          =   255
      Left            =   600
      TabIndex        =   0
      Top             =   840
      Width           =   1455
   End
End
Attribute VB_Name = "frmObjects"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Dim Headr1 As String, Headr2 As String, ipage As Integer

Sub Header(action As Integer)
If ipage > 0 Then
    'Print the page number centered at the bottom of the page
    hdrstr = "Page " & Str(ipage)
    hdrwid = Printer.TextWidth(hdrstr)
    hdrhgt = Printer.TextHeight(hdrstr)
    Printer.CurrentY = Printer.Height - 2 * hdrhgt - 720
    Printer.CurrentX = (Printer.Width - hdrwid) / 2 - 360
    Printer.Print hdrstr
    Printer.NewPage
End If
If action > 0 Then Exit Sub
'Print database name centered at the top of the page
Printer.Font.Size = 14
Printer.Font.Bold = True
hdrwid = Printer.TextWidth(Headr1)
Printer.CurrentY = 0
Printer.CurrentX = (Printer.Width - hdrwid) / 2 - 360
Printer.Print Headr1
'Print the version number centered, below the name
Printer.Font.Size = 12
Printer.Font.Bold = False
hdrwid = Printer.TextWidth(Headr2)
Printer.CurrentX = (Printer.Width - hdrwid) / 2 - 360
Printer.Print Headr2
'Print the report date
Printer.Print
Printer.Font.Size = 10
Printer.Print "Report Date: "; Date
ipage = ipage + 1
End Sub


Private Sub cmdAllQueries_Click(Index As Integer)
Dim numqry As Integer
numqry = lstQueries.ListCount
If numqry > 0 Then
    If Index = 0 Then
        For I = 0 To numqry - 1
            lstQueries.Selected(I) = True
        Next I
    Else
        For I = 0 To numqry - 1
            lstQueries.Selected(I) = False
        Next I
    End If
End If

End Sub

Private Sub cmdAllTables_Click(Index As Integer)
Dim numtbl As Integer
numtbl = lstTables.ListCount
If numtbl > 0 Then
    If Index = 0 Then
        For I = 0 To numtbl - 1
            lstTables.Selected(I) = True
        Next I
    Else
        For I = 0 To numtbl - 1
            lstTables.Selected(I) = False
        Next I
    End If
End If
End Sub

Private Sub cmdExit_Click()
Unload Me
End Sub

Private Sub cmdRun_Click()
Dim numtbl As Integer, I As Integer, tblName As String, Fld As Field
Dim fltype As String, dbRel As Relation, relAttr As Long, SQLstr As String
Dim PrntGen As Integer, PrntRel As Integer, tblIdx As Index
ReDim flAttr(1 To 4) As Integer
Screen.MousePointer = 11
'Get database options information
PrntGen = False
PrntRel = False
If chkGeneral.VALUE = 1 Then PrntGen = True
If chkRelations.VALUE = 1 Then PrntRel = True
'Set up page header
Headr1 = "Database Name: " & OldDb.Name
Headr2 = "Jet Version Number: " & OldDb.Version
ipage = 0
'Print database information if desired
If PrntGen Then
End If
'Print table relations if desired
If PrntRel Then
    Call Header(0)
    For Each dbRel In OldDb.Relations
        Printer.Print " "
        Printer.Print " "
        Printer.Print "Relation Name: "; dbRel.Name
        Printer.Print Tab(5); "Primary Table: "; dbRel.TABLE
        Printer.Print Tab(5); "Related Table: "; dbRel.ForeignTable
        relAttr = dbRel.Attributes
        If relAttr >= dbRelationRight Then
            Printer.Print Tab(5); "Relation is a right join"
            relAttr = relAttr - dbRelationRight
        End If
        If relAttr >= dbRelationLeft Then
            Printer.Print Tab(5); "Relation is a left join"
            relAttr = relAttr - dbRelationLeft
        End If
        If relAttr >= dbRelationDeleteCascade Then
            Printer.Print Tab(5); "Relation uses cascaded deletions"
            relAttr = relAttr - dbRelationDeleteCascade
        End If
        If relAttr >= dbRelationUpdateCascade Then
            Printer.Print Tab(5); "Relation uses cascaded updates"
            relAttr = relAttr - dbRelationUpdateCascade
        End If
        If relAttr >= dbRelationDontEnforce Then
            Printer.Print Tab(5); "Referential Integrity is not enforced"
            relAttr = relAttr - dbRelationDontEnforce
        End If
        If relAttr = dbRelationUnique Then
            Printer.Print Tab(5); "Relation is a one-to-one relationship"
        End If
        'Print relationship fields
        Printer.Print " "
        Printer.Print Tab(5); "Primary field"; Tab(25); "Related Field"
        For Each Fld In dbRel.Fields
            Printer.Print Tab(5); Fld.Name; Tab(25); Fld.ForeignName
        Next Fld
    Next dbRel
End If
numtbl = lstTables.ListCount
'Print table information for each selected table.
If numtbl > 0 Then
    'Check each table to see if it is selected.
    For I = 0 To numtbl - 1
        If lstTables.Selected(I) Then
            Call Header(0)
            tblName = lstTables.List(I)
            Set Tbl = OldDb.TableDefs(tblName)
            'Print table information
            Printer.Print
            Printer.Print
            Printer.Font.Size = 12
            Printer.Font.Bold = True
            Printer.Print "Table Name: "; tblName
            Printer.Font.Size = 10
            Printer.Font.Bold = False
            Printer.Print
            Printer.Print
            Printer.Print "Created on: "; Tbl.DateCreated
            Printer.Print "Last updated on: "; Tbl.LastUpdated
            Printer.Print "Current number of records: "; Tbl.RecordCount
            If Tbl.Updatable Then
                Printer.Print "Table may be updated"
            Else
                Printer.Print "Table may not be updated"
            End If
            flvalid = Tbl.ValidationRule
            If Len(Trim(flvalid)) > 0 Then
                Printer.Print "    Table Validation:"
                Printer.Print "    Rule: "; flvalid
                Printer.Print "    Error Text: "; Fld.ValidationText
            End If
            'Print fields header
            Printer.Print
            Printer.Print
            Printer.Font.Bold = True
            Printer.Print "Fields"
            Printer.Print
            Printer.Font.Bold = False
            Printer.Font.Underline = True
            Printer.Print "Name"; Tab(15); "Type"; Tab(30); "Size"; Tab(40); _
                "Required"; Tab(50); "0 Len OK"; Tab(60); "Updatable"
            Printer.Font.Underline = False
            Printer.Print
            'Print information for each field
            For Each Fld In Tbl.Fields
                'Set initial values
                flreq = "No"
                flZero = "No"
                flUpdt = "No"
                'Get field attributes
                For J = 1 To 4
                    flAttr(J) = False
                Next J
                atrval = Fld.Attributes
                If atrval >= 32 Then
                    flAttr(4) = True
                    atrval = atrval - 32
                End If
                If atrval >= 16 Then
                    flAttr(3) = True
                    atrval = atrval - 16
                End If
                If atrval >= 2 Then
                    flAttr(2) = True
                    atrval = atrval - 2
                End If
                If atrval = 1 Then flAttr(1) = True
                'Determine field type and size
                flsize = "N/A"
                Select Case Fld.Type
                    Case 1
                        fltype = "Boolean"
                    Case 2
                        fltype = "Byte"
                    Case 3
                        fltype = "Integer"
                    Case 4
                        fltype = "Long"
                        If flAttr(3) Then fltype = "Counter"
                    Case 5
                        fltype = "Currency"
                    Case 6
                        fltype = "Single"
                    Case 7
                        fltype = "Double"
                    Case 8
                        fltype = "Date"
                    Case 10
                        fltype = "Text"
                        flsize = Str(Fld.Size)
                    Case 11
                        fltype = "Binary"
                    Case 12
                        fltype = "Memo"
                End Select
                'Set values of required, zero length, and updatable
                If Fld.Required Then flreq = "Yes"
                If Fld.AllowZeroLength Then flZero = "Yes"
                If Fld.DataUpdatable Then flUpdt = "Yes"
                Printer.Print Fld.Name; Tab(15); fltype; Tab(30); flsize; _
                    Tab(40); flreq; Tab(50); flZero; Tab(60); flUpdt
                'Print validation information
                flvalid = Fld.ValidationRule
                If Len(Trim(flvalid)) > 0 Then
                    Printer.Print "    Validation:"
                    Printer.Print "    Rule: "; flvalid
                    Printer.Print "    Error Text: "; Fld.ValidationText
                    If Fld.ValidateOnSet Then
                        Printer.Print "    Validate when field value is set."
                    Else
                        Printer.Print "    Validate when field is updated."
                    End If
                End If
            Next Fld
            'Print index information
            Printer.Print
            Printer.Print
            Printer.Font.Bold = True
            Printer.Print "Indexes"
            Printer.Font.Bold = False
            For Each tblIdx In Tbl.Indexes
                'Print index header
                Printer.Print
                Printer.Print "Index Name: "; tblIdx.Name
                If tblIdx.UNIQUE Then
                    Printer.Print Tab(5); "Unique key values are required"
                End If
                If tblIdx.PRIMARY Then
                    Printer.Print Tab(5); "This is a primary index"
                End If
                If tblIdx.Required Then
                    Printer.Print Tab(5); "Non-null key values are required"
                End If
                If tblIdx.IgnoreNulls Then
                    Printer.Print Tab(5); "Null key values are ignored"
                End If
                Printer.Print
                Printer.Print Tab(5); "Fields"
                Printer.Print
                Printer.Font.Underline = True
                Printer.Print Tab(5); "Name"; Tab(20); "Order"
                Printer.Font.Underline = False
                Printer.Print
                'Print information for each field
                For Each Fld In tblIdx.Fields
                    If Fld.Attributes = 1 Then
                        florder = "Descending"
                    Else
                        florder = "Ascending"
                    End If
                    Printer.Print Tab(5); Fld.Name; Tab(20); florder
                Next Fld
            Next tblIdx
        End If
    Next I
End If
numtbl = lstQueries.ListCount
'Print information for each selected query
If numtbl > 0 Then
    For I = 0 To numtbl - 1
        If lstQueries.Selected(I) Then
            Call Header(0)
            qryName = lstQueries.List(I)
            Set Qry = OldDb.QueryDefs(qryName)
            'Print query information
            Printer.Print
            Printer.Print
            Printer.Font.Size = 12
            Printer.Font.Bold = True
            Printer.Print "Query Name: "; qryName
            Printer.Font.Size = 10
            Printer.Font.Bold = False
            Printer.Print
            Printer.Print
            Printer.Print "Created on: "; Qry.DateCreated
            Printer.Print "Last updated on: "; Qry.LastUpdated
            If Qry.Updatable Then
                Printer.Print "Query definition may be updated"
            Else
                Printer.Print "Query definition may not be updated"
            End If
            'Print query type
            Select Case Qry.Type
                Case dbQSelect
                    Printer.Print "This is a SELECT query"
                Case dbQAction
                    Printer.Print "This is an Action query"
                Case dbQCrosstab
                    Printer.Print "This is a Cross-tab query"
                Case dbQDelete
                    Printer.Print "This is a DELETE query"
                Case dbQUpdate
                    Printer.Print "This is an UPDATE query"
                Case dbQAppend
                    Printer.Print "This is an APPEND query"
                Case dbQMakeTable
                    Printer.Print "This is a Table creation query"
                Case dbQDDL
                    Printer.Print "This is a Data Definition Language query"
                Case dbQSQLPassThrough
                    Printer.Print "This is an SQL pass-through query"
            End Select
            'Print the SQL statement
            Printer.Print
            Printer.Font.Bold = True
            Printer.Print "SQL Statement"
            Printer.Font.Bold = False
            SQLstr = Qry.SQL
            Call MmoPrnt(SQLstr)
'            Printer.Print SQLstr
            'Print the field information for the query
            'Print fields header
            Printer.Print
            Printer.Print
            Printer.Font.Bold = True
            Printer.Print "Fields"
            Printer.Print
            Printer.Font.Bold = False
            Printer.Font.Underline = True
            Printer.Print "Name"; Tab(25); "Source Field"; Tab(40); "Source Table"
            Printer.Font.Underline = False
            Printer.Print
            'Print information for each field
            For Each Fld In Qry.Fields
                Printer.Print Fld.Name; Tab(25); Fld.SourceField; Tab(40); Fld.SourceTable
            Next Fld
        End If
    Next I
End If
Call Header(1)
Printer.EndDoc
Screen.MousePointer = 0
End Sub

Private Sub Form_Load()
Dim Tbl As TableDef, Qry As QueryDef
'Load table list
For Each Tbl In OldDb.TableDefs
    If Left(Tbl.Name, 4) <> "MSys" Then
        lstTables.AddItem Tbl.Name
    End If
Next Tbl
'Load query list
For Each Qry In OldDb.QueryDefs
    lstQueries.AddItem Qry.Name
Next Qry
End Sub


