program GSDMO_02;
{------------------------------------------------------------------------------
                              DBase File Lister

       Copyright (c)  Richard F. Griffin

       20 January 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how dBase files may be listed using
       Griffin Solutions units.

       If the GSDMO_01.DBF file does not exist, the program will display a
       a message that the file was not found and to run GSDMO_01 to make
       the file.

       The program opens a dBase file and proceeds to list selected fields
       from each record.

       New procedures/functions introduced are:

                 CloseDataBases
                 dEOF
                 FieldGet
                 FileExist
                 GoTop
                 Select
                 Skip
                 Use

-------------------------------------------------------------------------------}

uses
   GSOBShel,
   {$IFDEF WINDOWS}
      WinCRT,
      WinDOS;
   {$ELSE}
      CRT,
      DOS;
   {$ENDIF}


begin
   ClrScr;
   if not FileExist('GSDMO_01.DBF') then   {Check for the file}
   begin
      writeln('File GSDMO_01.DBF not found.  Run GSDMO_01 to create.');
      halt;
   end;
                       {The 'Real' example starts here}

   Select(1);                     {Use record area 1 (the default)}
   Use('GSDMO_01');               {Assign the dBase III file GSDMO_01}
   GoTop;                         {Get the first record in the file}
   while not dEOF do              {Repeat until end-of-file}
   begin
      writeln(FieldGet('LASTNAME'),' ',       {Get field images}
              FieldGet('FIRSTNAME'),'  ',
              FieldGet('BIRTHDATE'));
      Skip(1);                    {Get the next sequential record}
   end;
   CloseDataBases;                {Close the file}
   write('Press any Key to continue:');
   repeat until KeyPressed;
end.
