program GSDMO_ED;
{------------------------------------------------------------------------------
                                 DBase Editor

       Copyright (c)  Richard F. Griffin

       14 January 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how to edit a dBase memo file using
       Griffin Solutions units.

       If the GSDMO_07.DBF file does not exist, the program will display a
       a message that the file was not found and to run GSDMO_07 to make
       the file.

-------------------------------------------------------------------------------}
{$N+,E+}          {Required for floating point number handling}

uses
   CRT,
   GSOB_EDT,
   GSOB_DSK,
   GSOBShel;
var
   MyEdit  : GSO_EditView;
   Ch      : char;

procedure EditTheMemo;
var
   ov   : string[10];
   ml   : integer;
begin
   ov := FieldGet('COMMENTS');
   MemoGet('COMMENTS');
   ml := MemoLines;
   if ml <> 0 then
   begin
      window(1,2,80,25);
      MyEdit.Init(DBFActive^.MemoFile^.MemoCollect,
                  DBFActive^.MemoFile^.Edit_Lgth);
      if MyEdit.WorkView and MyEdit.Modified then
      begin
         MemoPut('COMMENTS');
         if FieldGet('COMMENTS') <> ov then Replace;
      end;
      window(1,1,80,25);
   end;
   writeln;
end;

begin
   ClrScr;
   if not GS_FileExists('GSDMO_07.DBF') then
   begin
      Writeln('File GSDMO_07.DBF is unavailable. Run GSDMO_07.PAS');
      halt;
   end;
   Select(1);
   Use('GSDMO_07');
   MemoWidth(75);     {sets width of the memo line.  Default is 50}
   GoTop;
   while not dEOF do
   begin
      ClrScr;
      writeln(FieldGet('LASTNAME'),', ',
              FieldGet('FIRSTNAME'));
      EditTheMemo;
      Skip(1);
   end;
   CloseDataBases;
end.
