program ShowOff;
{$N+,E+}
uses
   SmplStuf,
   XtraStuf,
   GSOBShel,
   GSOB_Inx,
   GSOB_Var,
   CRT,
   DOS;

var
   NameOfFile: string;
   NameOfIndx: string;
   SelectLine: GSP_IndxColl;
   WorkStr   : string;
   lctn      : integer;
   LinItem   : longint;

Procedure MainScreenDraw;
begin
    window(1,1,80,25);
   SetScreenColors(Yellow,LightCyan,Blue,Blue,LightGray);
   SetNmMode;
   ClrScr;
   if NameOfFile <> '' then
   begin
      GotoXY(34,10);
      write('Active File:');
      GoToXY((40-length(NameOfFile) div 2),11);
      write(NameOfFile);
      if NameOfIndx <> '' then
      begin
         GotoXY(34,13);
         write('Index File:');
         GoToXY((40-length(NameOfIndx) div 2),14);
         write(NameOfIndx);
      end;
   end;
end;


Procedure InitMenuBar;
begin
   SelectLine := New(GSP_IndxColl, Init(8, NoSort));
   SelectLine^.InsertKey(1,' File');
   SelectLine^.InsertKey(2,' Index');
   SelectLine^.InsertKey(3,' Edit');
   SelectLine^.InsertKey(4,' Append');
   SelectLine^.InsertKey(5,' Browse');
   SelectLine^.InsertKey(6,' Quit');
end;

Function SelectMenuItem: longint;
var
   slct : word;
   mItem: GSP_IndxEtry;
begin
   window(1,25,80,25);
   SetScreenColors(Yellow,White,Red,Blue,LightGray);
   SetNmMode;
   ClrScr;
   slct := 1;
   mItem := GS_Pick_Line(SelectLine,slct);
   if mItem <> nil then
      SelectMenuItem := mItem^.Tag
   else
      SelectMenuItem := 0;
end;

Function SelectAFile(fpath, wcard : string; alldir : boolean): string;
var
   s : string;
begin
   window(25,3,54,20);
   SetScreenColors(Black,Yellow,Green,White,Green);
   SetNmMode;
   ClrScr;
   MakeABox('Select File');
   s := GS_FindFiles(fpath,wcard,alldir);
   lctn := pos('.',s);
   if lctn > 0 then delete(s,lctn,4);
   SelectAFile := s;
end;

begin
   TextBackGround(Blue);
   ClrScr;
   InitMenuBar;
   NameOfFile := '';
   NameOfIndx := '';
   Select(1);

   repeat
      MainScreenDraw;
      LinItem := SelectMenuItem;
      case LinItem of
         1 : begin                          {Get a file}
                WorkStr := SelectAFile('','*.DBF',true);
                MainScreenDraw;
                if WorkStr <> '-' then
                begin
                   NameOfFile := WorkStr;
                   NameOfIndx := '';
                   Use(NameOfFile);
                   SetDBFCacheOn;
                end
                else
                   NameOfFile := '';
             end;
         2 : begin                          {Get a file}
                if NameOfFile <> '' then
                begin
                   WorkStr := NameOfFile;
                   lctn := length(WorkStr);
                   while lctn > 0 do
                   begin
                      if WorkStr[lctn] <> '\' then
                         system.delete(WorkStr,lctn,1)
                      else lctn := 0;
                      dec(lctn);
                   end;
                   NameOfIndx := SelectAFile(WorkStr,'*.NDX',false);
                   MainScreenDraw;
                   if NameOfIndx <> '-' then
                      Index(NameOfIndx)
                   else
                      NameOfIndx := '';
                end;
             end;
         3 : begin                          {Do Edit}
                if NameOfFile <> '' then
                begin
                   MainScreenDraw;
                   lctn := RecNo;
                   if RecNo < 1 then GoTop else Go(RecNo);
                   while (FieldUpDateScreen) and (not dEOF) do
                   begin
                      if RecChanged and (GS_KeyI_Chr <> Kbd_Esc) then Replace;
                      if GS_KeyI_Chr = Kbd_PgUp then
                         Skip(-1)
                      else
                         Skip(1);
                   end;
                   MainScreenDraw;
                end;
             end;
         4 : begin                          {Do Append}
                if NameOfFile <> '' then
                begin
                   SetDBFCacheOff;
                   MainScreenDraw;
                   while (FieldAppendScreen(true)) and (not dEOF) do
                      if GS_KeyI_Chr <> Kbd_Esc then Append;
                   MainScreenDraw;
                   SetDBFCacheOn;
                   Go(RecCount);
                end;
             end;
         5 : begin                          {Do Browse}
                if NameOfFile <> '' then
                begin
                   SetDBFCacheOff;
                   MainScreenDraw;
                   FieldBrowseScreen;
                   MainScreenDraw;
                   SetDBFCacheOn;
                end;
             end;
      end;
   until LinItem > 5;
   Dispose(SelectLine, Done);
   CloseDataBases;
end.



