;  ----------------------      ADLIB.INC      ----------------------
;  Adlib routines.
;  (C) 1994 JCAB/VangeliSTeam




; ===========================
; Data.

ADL_Instrument STRUC

        ADL_MFlMult     DB ?
        ADL_CFlMult     DB ?
        ADL_MKsrLoud    DB ?
        ADL_CKsrLoud    DB ?
        ADL_MAttDec     DB ?
        ADL_CAttDec     DB ?
        ADL_MSusRel     DB ?
        ADL_CSusRel     DB ?
        ADL_MWavef      DB ?
        ADL_CWavef      DB ?
        ADL_Mode        DB ?

ENDS                          

ADL_ChanData STRUC

        ADL_CVol        DB ?
        ADL_MReg        DB ?
        ADL_CReg        DB ?

ENDS

ADL_Channels    ADL_ChanData <0,00h,03h>
                ADL_ChanData <0,01h,04h>
                ADL_ChanData <0,02h,05h>
                ADL_ChanData <0,08h,0Bh>
                ADL_ChanData <0,09h,0Ch>
                ADL_ChanData <0,0Ah,0Dh>
                ADL_ChanData <0,10h,13h>
                ADL_ChanData <0,11h,14h>
                ADL_ChanData <0,12h,15h>

ADL_NoteTable DW 363, 385, 408, 432, 458, 485, 514, 544, 577, 611, 647, 686

ADL_Regs  DB 256 DUP(0)
ADL_FRegs DB 256 DUP(0)

ADL_InsCount DW 0



; ===========================
; Wait loop. CX IN's from DX

ADL_Loop:       MOV     DX,3C0h
        @@lp:    IN      AL,DX
                 LOOP    @@lp
;SetBorder 0,0,0
                RET

; ===========================
; Write AdLib register. AL=reg, AH=val

ADL_SendReg:    MOV     BX,AX
                XOR     BH,BH
                MOV     ADL_FRegs[BX],AH
                MOV     DX,388h
                OUT     DX,AL
                MOV     CX,6
                CALL    ADL_Loop
;SetBorder 63, 63, 0
                MOV     DX,389h
                MOV     AL,AH
                OUT     DX,AL
                MOV     CX,35
                JMP     ADL_Loop

; ===========================
; Reset routine.

ADL_Reset:      MOV     BX,1
        @@lp:    MOV    AX,BX
                 AND    AL,0E0h
                 CMP    AL,40h
                 JNZ    SHORT @@1
                  MOV   AH,63
        @@1:     MOV    AL,BL
                 CALL   ADL_SendReg
                 INC    BL
                 JNZ    SHORT @@lp
                RET

; ===========================
; Dumps an instrument to the card.

ADL_DumpInstrument:

                ; ----------------------- MPU stuff below!!!

                PUSH    AX
                ADD     AL,0C0h
                CALL    MPU_Send
                POP     AX
                PUSH    AX
                MOV     BL,AH
                XOR     BH,BH
                MOV     AL,MPU_Patches[BX]
                CALL    MPU_Send
                POP     AX

                ; -----------------------

                XOR     AH,AH
                PUSH    AX
                MOV     AH,SIZE ADL_ChanData
                MUL     AH
                MOV     DI,AX
                ADD     DI,OFFSET ADL_Channels
                POP     AX
                MOV     BX,AX
                MOV     AH,ADL_Mode[SI]
                MOV     ADL_Regs[BX+0C0h],AH
                MOV     AH,ADL_Regs[BX+0B0h]
                AND     AH,11011111b
                CALL    ADL_SendReg

                MOV     AH,ADL_CKsrLoud[SI]
                NOT     AH
                AND     AH,63
                MOV     ADL_CVol[DI],AH

                MOV     BL,ADL_MReg[DI]
                XOR     BH,BH
                ADD     BX,OFFSET ADL_Regs
                MOV     AH,ADL_MKsrLoud[SI]
                MOV     [BX+40h],AH
                MOV     AH,ADL_MFlMult[SI]
                MOV     [BX+20h],AH
                MOV     AH,ADL_MAttDec[SI]
                MOV     [BX+60h],AH
                MOV     AH,ADL_MSusRel[SI]
                MOV     [BX+80h],AH
                MOV     AH,ADL_MWavef[SI]
                MOV     [BX+0E0h],AH

                                        ; This is to make this more
                INC     SI              ; compressable. The offsets below
                                        ; refer to the carrier, not the
                                        ; modulator!!!
                
                MOV     BL,ADL_CReg[DI]
                XOR     BH,BH
                ADD     BX,OFFSET ADL_Regs
                MOV     AH,ADL_MKsrLoud[SI]
                AND     AH,11000000b
                OR      AH,00111111b
                AND     BYTE PTR [BX+40h],00111111b
                OR      [BX+40h],AH
                MOV     AH,ADL_MFlMult[SI]
                MOV     [BX+20h],AH
                MOV     AH,ADL_MAttDec[SI]
                MOV     [BX+60h],AH
                MOV     AH,ADL_MSusRel[SI]
                MOV     [BX+80h],AH
                MOV     AH,ADL_MWavef[SI]
                MOV     [BX+0E0h],AH
                RET

; ===========================
; Initialize the instruments of the song.

ADL_StartSong:  MOV     SI,OFFSET CMF_Instruments
                MOV     CX,9
        @@lp:    PUSH   CX
                 PUSH   SI
                 MOV    AL,CH
                 MOV    AH,AL
                 CALL   ADL_DumpInstrument
                 POP    SI
                 ADD    SI,SIZE ADL_Instrument
                 POP    CX
                 INC    CH
                 DEC    CL
                 JNZ    SHORT @@lp
                CALL    ADL_Dump
                RET

; ===========================
; Dump the changed registers to the FM chip.

ADL_Dump:       MOV     SI,OFFSET ADL_Regs
                MOV     DI,OFFSET ADL_FRegs
                MOV     CX,256
        @@dumpl: REPE CMPSB
                 JCXZ   SHORT @@dumpe
                 MOV    AH,[SI-1]
                 MOV    AL,255
                 SUB    AL,CL
                 PUSH   CX
                 CALL   ADL_SendReg
                 POP    CX
                 JMP    SHORT @@dumpl
        @@dumpe:RET
                
; ===========================
; Execute a tick of the song.

ADL_DoSong:     PUSH    AX BX CX DX SI DI BP DS ES
                MOV     AX,CS
                MOV     DS,AX
                MOV     ES,AX

;SetBorder 0, 0, 63

                MOV     BP,OFFSET CMF_Offsets
                MOV     [ADL_InsCount],CMF_NInstruments

        @@otra:
;SetBorder 63, 0, 0
                DEC     WORD PTR CS:[BP]
                JNZ     @@Fin

;SetBorder 0, 63, 0

                MOV     SI,CS:[BP+2]
        @@lp:    LODSB
                 MOV    AH,AL
                 AND    AH,0F0h
                 CMP    AH,90h
                 JC     SHORT @@kon
                 JZ     @@koff
                 CMP    AH,0D0h
                 JZ     @@normd
                 CMP    AH,0E0h
                 JZ     @@longd

                 ; Song end.

                 MOV    SI,CS:[BP+4]
                 JMP    SHORT @@lp

        @@kon:   SHR    AH,4
;SetBorder 0, 0, 63

                 PUSH   AX
                 MOV    AL,AH
                 ADD    AL,0B0h
                 XOR    AH,AH
                 CALL   ADL_SendReg
                 POP    AX
                 AND    AL,15
;SetBorder 0, 63, 0
                 JZ     SHORT @@yains
                  PUSH  AX
                  PUSH  SI
                  DEC   AL
                  MOV   BH,AH
                  PUSH  AX
                  MOV   AH,SIZE ADL_Instrument
                  MUL   AH
                  MOV   SI,AX
                  ADD   SI,OFFSET CMF_Instruments
                  MOV   AL,BH
                  POP   BX
                  MOV   AH,BL
                  CALL  ADL_DumpInstrument
                  POP   SI
                  POP   AX
        @@yains: LODSB
                 PUSH   AX
                 AND    AL,7Fh
                 SUB    AL,13
                 XOR    AH,AH
                 MOV    BL,12
                 DIV    BL
                 MOV    BL,AH
                 XOR    BH,BH
                 ADD    BX,BX
                 MOV    DX,ADL_NoteTable[BX]
                 ADD    AL,AL
                 ADD    AL,AL
                 OR     DH,AL
                 OR     DH,00100000b
                 POP    AX
                 PUSH   AX
                 MOV    BL,AH
                 XOR    BH,BH
                 MOV    ADL_Regs[BX+0A0h],DL
                 MOV    ADL_Regs[BX+0B0h],DH
                 ADD    AL,AL
                 JNC    SHORT @@novol
                  PUSH  AX
                  MOV   AL,SIZE ADL_Channels
                  MUL   AH
                  MOV   DI,AX
                  ADD   DI,OFFSET ADL_Channels
                  LODSB
                  MUL   ADL_CVol[DI]
                  XOR   AH,3Fh
                  XOR   BH,BH
                  MOV   BL,ADL_CReg[DI]
                  AND   ADL_Regs[BX+40h],11000000b
                  OR    ADL_Regs[BX+40h],AH
                  POP   AX
        @@novol:

                 ; ----------------------- MPU stuff below!!!
;SetBorder 63, 0, 0

                 POP    AX
                 PUSH   AX

                 MOV    BL,AH
                 XOR    BH,BH
                 ADD    BX,OFFSET MPU_Notes
                 MOV    AL,[BX]
                 AND    AL,AL
                 JZ     @@nooff

                 POP    AX
                 PUSH   AX
                 MOV    AL,AH
                 ADD    AL,80h
                 CALL   MPU_Send
                 POP    AX
                 PUSH   AX
                 MOV    AL,[BX]
                 CALL   MPU_Send
                 MOV    AL,7Fh
                 CALL   MPU_Send
        @@nooff:
                 POP    AX
                 PUSH   AX
                 MOV    AL,AH
                 ADD    AL,90h
                 CALL   MPU_Send
                 POP    AX
                 AND    AL,7Fh
                 MOV    [BX],AL
                 CALL   MPU_Send
                 MOV    AL,7Fh
                 CALL   MPU_Send
        @@nompu:

                 ; -----------------------

;SetBorder 0, 0, 0
                 JMP    @@lp

        @@koff:  AND    AL,15
                 XOR    AH,AH
                 MOV    BX,AX
                 AND    ADL_Regs[BX+0B0h],11011111b
                 JMP    @@lp

        @@longd: AND    AL,15
                 MOV    AH,AL
                 LODSB
                 INC    AX
                 MOV    DX,5
                 MUL    DX
                 MOV    CS:[BP],AX
                 JMP    SHORT @@finish

        @@normd: AND    AL,15
                 INC    AX
                 MOV    AH,5
                 MUL    AH
                 MOV    CS:[BP],AX

        @@finish:
;SetBorder 0, 0, 0
                MOV     CS:[BP+2],SI

        @@Fin:
                ADD     BP,6
                DEC     [ADL_InsCount]
                JNZ     @@otra

                CALL    ADL_Dump
                
;SetBorder 0, 0, 0
                POP     ES DS BP DI SI DX CX BX AX
                RET




;  ----------------------   End of ADLIB.INC  ----------------------
