;  ----------------------       MPU.INC       ----------------------
;  MPU routines.
;  (C) 1994 JCAB/VangeliSTeam




; ===========================
; Data.

MPU_Port  DW 331h
MPU_Count DW 1
MPU_Notes DW 9 DUP(0)




; ===========================
; Wait loop for the MPU card.

MPU_Loop:       NOP
;SetBorder 63,63,63
                XOR     AH,AH
        @@lp:    DEC    AH
                 JZ     @@err
                 IN     AL,DX
                 SHL    AL,CL
                 JC     @@lp
;SetBorder 0,0,0
        @@ret:  RET
        @@err:  MOV     AL,BYTE PTR CS:[@@ret]
                MOV     BYTE PTR CS:[MPU_Loop],AL
                RET

; ===========================
; Reset the MPU card.

MPU_Reset:      MOV     DX,CS:[MPU_Port]
                MOV     AL,0FFh
                OUT     DX,AL
                MOV     CL,1
                CALL    MPU_Loop
                DEC     DX
                IN      AL,DX
                INC     DX
                MOV     AL,3Fh
                OUT     DX,AL
                CALL    MPU_Loop
                DEC     DX
                IN      AL,DX
                MOV     AL,0FFh
                CALL    MPU_Send
                RET

; ===========================
; Send a byte.

MPU_Send:       MOV     DX,CS:[MPU_Port]
                MOV     CL,2
                PUSH    AX
                CALL    MPU_Loop
                POP     AX
                DEC     DX
                OUT     DX,AL
                RET




;  ----------------------    End of MPU.INC   ----------------------
