UNIT ANMPLAY;
{
  DELUXE PAINT ANIM PLAYER by Bjarke Viksoe
  Begun: Dec 1995
  Last revised: Dec 1995

  - wow, a Deluxe Paint ][ Animation replayer
  -- and it's pretty neat, if i'd have to say so
  --- worst part is really that TP cannot handle memory sizes at
		65536 bytes! Bommer. We exactly need 65536 bytes. Well, we'll
		just have to do with 65535 then, won't we.
}

{$X+,P+}

INTERFACE

USES
	PICTURE;


Function AnmInit(const filename : string) : Boolean;
Function AnmDone : Boolean;
Function AnmReadFrame(const framenumber : word) : Boolean;
Function AnmDisplayFrame(const framenumber : word; dst : pointer) : Boolean;

TYPE
	ANMHEADER = RECORD
	 id           : array[0..3] of char;
	 maxLps       : word;
	 nLps         : word;
	 nRecords     : longint;
	 maxRecsPerLp : word;
	 TableOffset  : word;
	 ContentType  : array[0..3] of char;
	 width        : word;
	 height       : word;
	 variant      : byte;
	 version      : byte;
	 HasLastDelta : bytebool;
	 LastDelta    : bytebool;
	 PixelType    : byte;
	 compression  : byte;
	 other        : byte;
	 bitmap       : byte;
	 recordTypes  : array[1..32] of byte;
	 nFrames      : longint;
	 FramesPrSec  : word;
	 pad          : array[1..29] of word;
	end;

VAR
	header : ANMHEADER;


IMPLEMENTATION

TYPE
	ANMLPAGE = RECORD
	  base     : word;
	  nRecords : word;
	  size     : word;
	end;
	AnmBuffer = array[0..65534] of byte;
	pIntArray = ^IntArray;
	IntArray  = array[0..255] of word;


VAR
	f : FILE;
	LP : array[0..255] of ANMLPAGE;
	curlp : ANMLPAGE;
	curpage : word;
	buffer : ^AnmBuffer;
	bFrameRead : Boolean; {sanity check}

{$I-}

{Forward me}
Procedure AnmPlayRunSkipDump(src : pointer; dst : pointer); forward;


(*========================================================*)


Function AnmConvertId( c : array of char ) : string;
Var
	Tmp : string[4];
Begin
	Tmp[0]:=#4;
	Tmp[1]:=c[0];
	Tmp[2]:=c[1];
	Tmp[3]:=c[2];
	Tmp[4]:=c[3];
	AnmConvertId:=Tmp;
End;

Function AnmReadHeader : Boolean;
Var
	Result,i,j : word;
	fill : array[1..128] of byte;
Begin
	AnmReadHeader:=FALSE;
	BlockRead(f, header, SizeOf(ANMHEADER), Result );
	if IOResult<>0 then exit;
	with header do begin
		{sanity check}
		If AnmConvertId(header.id)<>'LPF ' then exit;
		If AnmConvertId(header.ContentType)<>'ANIM' then exit;
		if (variant<>0) OR (pixeltype<>0) OR (bitmap<>1) OR (other<>0) OR (compression<>1) then exit;
	end;
	{skip cycle buffer}
	BlockRead(f, fill, 128, Result );
	{read colour map}
	j:=1;
	for i:=1 to 256 do begin
		BlockRead(f, fill, 4, Result );
		CMAP[j]:=fill[3] SHR 2;
		CMAP[j+1]:=fill[2] SHR 2;
		CMAP[j+2]:=fill[1] SHR 2;
		inc(j,3);
	end;
	{read long-page array}
	BlockRead(f, LP, 256*SizeOf(ANMLPAGE), Result );
	if IOResult<>0 then exit;
	{all done...}
	AnmReadHeader:=TRUE;
End;

Function AnmInit(const filename : string) : Boolean;
Var
	Result : word;
Begin
	AnmInit:=FALSE;
	buffer:=NIL;
	{open file}
	Result:=IOResult; {Clear IOResult}
	Assign(F, filename);
	Reset(F,1);
	if IOResult<>0 then exit;
	if NOT AnmReadHeader then exit;
	{reset variables}
	if MaxAvail<SizeOf(AnmBuffer) then exit;
	New( buffer );
	if Ofs(buffer^)<>0 then exit; {AnimBuffer must be at segment-border!}
	curpage:=$FFFF;
	bFrameRead:=FALSE;
	{all ok...}
	AnmInit:=TRUE;
End;

Function AnmDone : Boolean;
Begin
	AnmDone:=FALSE;
	if Assigned(buffer) then Dispose( buffer );
	buffer:=NIL;
	Close(f);
	if IOResult<>0 then exit;
	AnmDone:=TRUE;
End;


(*========================================================*)


Function AnmFindPage(const num : integer) : word;
Var
	i : word;
Begin
	for i:=0 to header.nLps-1 do
		if (LP[i].base <= num) AND (LP[i].base + LP[i].nRecords > num) then begin
			AnmFindPage:=i;
			exit;
		end;
	AnmFindPage:=i;
End;

Function AnmLoadPage(const page : word) : Boolean;
Var
	Result, Tmp : word;
	size : longint;
Begin
	if curpage<>page then begin
		curpage:=page;
		seek(f, longint($B00) + (longint(page)*$10000)); {find page}
		BlockRead( f, curlp, SizeOf(ANMLPAGE), Result ); {read LP}
		BlockRead( f, Tmp, 2, Result );                  {skip word with 0 value}
		size:=curlp.size+(curlp.nRecords*2);
		if size<$10000 then
			BlockRead( f, buffer^, size, Result )
		else begin
			{Bommer. Size is exactly 65536 bytes! TP cannot handle this!!!}
			BlockRead( f, buffer^, 65535, Result );
			BlockRead( f, buffer^[65534], 1, Result );
		end;
	end;
End;


Function AnmReadFrame(const framenumber : word) : Boolean;
Begin
	AnmReadFrame:=FALSE;
	AnmLoadPage( AnmFindPage(framenumber) );
	AnmReadFrame:=TRUE;
End;


Function AnmDisplayFrame(const framenumber : word; dst : pointer) : Boolean;
Var
	Offset, i, pos : word;
	destframe : word;
	pInt : pIntArray;
Begin
	AnmDisplayFrame:=FALSE;
	destframe := framenumber - curlp.base;
	pInt := @buffer^;
	Offset := 0; {buffer base is 0}
	if destframe>0 then
		for i:=0 to destframe-1 do Inc( Offset, pInt^[i] );

	pos := curlp.nRecords*2 + offset;
	if buffer^[pos]<>66 then exit; {sanity check}

	if buffer^[pos+1]<>0 then begin
		pInt:=@buffer^[pos];
		Inc( pos, (4 + (pInt^[1] + (pInt^[1] AND 1))) );
	end
	else
		Inc( pos, 4 );

	AnmPlayRunSkipDump(@buffer^[pos], dst);
	AnmDisplayFrame:=TRUE;
End;


(*========================================================*)


Procedure AnmPlayRunSkipDump(src : pointer; dst : pointer);
{This is a total rip-off of the original PD code}
Begin
  asm
	push	ds			         { Save DS }
	les	di,dst
	lds	si,src
	cld

	sub	ch,ch			      { SET CH = 0.}
	jmp   @nextOp

@skip:
	sub	cl,80h				{ Strip off sign bit, leaving skip cnt.}
	jz	   @longOp				{ cnt==0 indicates a long op.}
{--- shortSkip ---}
	add	di,cx					{ skip # pixels.  (CH=0)}
{--- variation on NEXTOP inline to minimize jmp's ---}
@nextOp:							{ Get and decode next op.}
	mov	cl,[si]
	inc	si
	jcxz	@run
	or	   cl,cl					{ Test CL's sign bit.}
	jl	   @skip
@dump:
	rep movsb					{ copy # pixels.  (CH=0)}
{--- variation on NEXTOP inline to minimize jmp's ---}
	mov	cl,[si]
	inc	si
	or	   cl,cl					{ Test CL's sign bit.}
	jl   	@skip
	jg	   @dump
@run:
	mov	cl,[si]				{ 8-bit unsigned count.}
	inc	si
	lodsb						   { pixel value.}
	rep stosb					{ set # pixels to value.  (CH=0)}
{--- variation on NEXTOP inline to minimize jmp's ---}
	mov	cl,[si]
	inc	si
	jcxz	@run
	or	   cl,cl			  	   { Test CL's sign bit.}
	jl	   @skip
	jmp	@dump

@longOp:		  			      { NOTE: if load into CX, must clear CH afterwards.}
	lodsw					   	{ 16-bit unsigned count.}
	or	   ax,ax					{ set flags.}
	jle	@notLongSkip
@longSkip:
	add	di,ax				   { skip # pixels.}
	jmp   @nextOp
{		 longSkip only used for > 2*127, so can't be very many,}
{		 so don't bother saving one jmp with inline NEXTOP.}

@notLongSkip:
	jz	   @stop			      { long count of zero means "stop code".}
	mov	cx,ax				   { may SET CH non-zero.}
	sub	ch,80h				{ Clear sign bit.}
	cmp	ch,40h
	jge	@longRun
{ --- For maximum speed on longDump, caller should insure src & dst are}
{ aligned.  To do so, caller must calculate whether}
{ src DATA will begin on same (odd or even) alignment as dst data.}
{ If not, first put a 1-byte Dump, which occupies 2 src bytes, thereby}
{ shifting relative alignment (src moves 2, dst moves 1).}
{ longDump}
	test	si,1
			{ Insure src word-aligned.}
			{ In case caller didn't sync src & dst, we chose}
			{ to align src because we know it is of benefit --}
			{ aligning dst on 8-bit video cards might not be of}
			{ any benefit.}
	jz	   @dumpWordAligned
	movsb							{ get to word boundary.}
	dec	cx
@dumpWordAligned:
	shr	cx,1					{ Convert byte count to word count.}
	jc	   @dumpOddByte
	rep   movsw					{ Word-aligned.}
@longOpDone:
	sub	ch,ch					{ SET CH = 0.}
	jmp	@nextOp

@dumpOddByte:
	rep movsw					{ Word-aligned.}
	movsb
	jmp   @longOpDone

@longRun:
	sub	ch,40h				{ Clear "longRun" bit.}
	lodsb
	mov	ah,al				   { Replicate byte to word value.}
	test	di,1				   { Insure dst word-aligned.}
	jz	   @runWordAligned
	stosb
	dec	cx
@runWordAligned:
	shr	cx,1					{ Convert byte count to word count.}
	jc	   @runOddByte
	rep stosw					{ Word-aligned.}
	jmp	@longOpDone

@runOddByte:
	rep stosw					{ Word-aligned.}
	stosb
	jmp   @longOpDone

@stop:
	pop	ds					   { Restore DS }
  end;
End;


End.
