Program Tube;
{$M 4096,0,0}
{$L Tube}
Uses Crt;
Var Err:Byte;
    X,Y,N,OutputSeg,RadiusSeg,RadiusSegP,ColorSeg,ColorSegP,Rotate,
     Moving,Width,Height:Word;
    Line:Array[0..319] Of Byte;
    Palette:Array[0..767] Of Byte;
    Fil:File;
Procedure VoxelTubeInit; External;
Procedure VoxelTube; External;
Procedure DrawVoxelTube; External;
Procedure VoxelTubeFree; External;
Begin
 Asm Mov Ax,0003h; Int 10h; End;
 Asm Mov   Err,01h
     Call  VoxelTubeInit
     Jc    @1
     Mov   OutputSeg,Ax
     Mov   Err,00h
     Mov   Ah,48h            { Allocate memory for radius and color tables }
     Mov   Bx,2000h
     Int   21h
     Mov   RadiusSeg,Ax
     Jnc   @1
     Mov   Err,01h
     Call  VoxelTubeFree
 @1:
 End;
 If Err>0 Then Begin WriteLn('Not enough memory!!!'); Halt(1); End;
 ColorSeg:=RadiusSeg+$1000;
 {$I-}
 Assign(Fil,'TUBE.DAT'); Reset(Fil,1);
 If IOResult<>0 Then Begin WriteLn('TUBE.DAT not found!'); Halt(1); End;
 BlockRead(Fil,Mem[OutputSeg+$1000:0],64000); Close(Fil);

 For N:=0 to 65535 Do Mem[ColorSeg:N]:=62;
 Assign(Fil,'TUBE.COL'); Reset(Fil,1);
 If IOResult<>0 Then Begin WriteLn('TUBE.COL not found!'); Halt(1); End;
 BlockRead(Fil,Palette,768); BlockRead(Fil,Width,2); BlockRead(Fil,Height,1);
 For Y:=0 to Height-1 Do Begin
  BlockRead(Fil,Line,Width);
  For X:=0 to Width-1 Do Begin
   Mem[ColorSeg:(Y+00)*512+X*2+0]:=Line[X];
   Mem[ColorSeg:(Y+00)*512+X*2+1]:=Line[X]; End;
  For X:=0 to Width-1 Do Begin
   Mem[ColorSeg:(Y+64)*512+X*2+0]:=Line[X];
   Mem[ColorSeg:(Y+64)*512+X*2+1]:=Line[X]; End; End; Close(Fil);

 WriteLn('Please wait, calculating tube radiuses...');
 For Y:=0 to 127 Do For X:=0 to 511 Do Begin
  Mem[RadiusSeg:Y*512+X]:=128+Round(80*(Sin(Y*Pi/8)*Sin(X*Pi/64))); End;

 Asm Mov Ax,0013h; Int 10h; End;
 Port[$3C8]:=0; For N:=0 to 767 Do Port[$3C9]:=Palette[N];

 Rotate:=0;
 Moving:=0;
 Repeat
{ Asm Mov   Dx,03DAh
 @1: In    Al,Dx
     And   Al,08h
     Jz    @1
 @2: In    Al,Dx
     And   Al,08h
     Jnz   @2
     Mov   Dx,03C0h
     Mov   Al,31h
     Out   Dx,Al
     Out   Dx,Al
 End;}
  Asm Mov   Es,[OutputSeg]   { Clear output segment }
      Mov   Di,65532
  @1: Db    66h,33h,0C0h
      Db    26h,66h,89h,05h
      Sub   Di,04h
      Jnc   @1
  End;
  ColorSegP:=ColorSeg+Moving;
  RadiusSegP:=RadiusSeg+Moving;
  Asm Push  Ds
      Mov   Dx,Rotate        { Tube rotate value (0-511) }
      Dw    02E8Eh,ColorSegP { Mov Gs,[ColorSeg] }
      Mov   Ds,[RadiusSegP]
      Call  VoxelTube
      Pop   Ds
  End;
  Inc(Rotate,1); If Rotate>511 Then Dec(Rotate,512);
  Inc(Moving,32); If Moving>2016 Then Dec(Moving,2048);
  DrawVoxelTube;
{ Asm
     Mov   Dx,03C0h
     Mov   Al,31h
     Out   Dx,Al
     Xor   Al,Al
     Out   Dx,Al
 End;}

{ For Y:=0 to 127 Do For X:=0 to 319 Do
  Mem[$A000:Y*320+X]:=Mem[OutputSeg:Y*512+X];}

 Until KeyPressed;
 Asm Mov Ax,0003h; Int 10h; End;
 VoxelTubeFree;
End.
