.Model Small
.Stack
Data                         Segment   Para Use16

; Messages and file names
         MemoryErrMsg        Db        'Not enough memory!$'
         TubeTranslateFile   Db        'TUBE.DAT',00h
         TubeBitmapFile      Db        'TUBE.MAP',00h
         AntialiasDataFile   Db        'TUBEANTI.DAT',00h
         FileNotFoundMsg01   Db        'File TUBE.DAT not found!$'
         FileNotFoundMsg02   Db        'File TUBE.MAP not found!$'
         FileNotFoundMsg03   Db        'File TUBEANTI.DAT not found!$'
         FileReadErrorMsg01  Db        'Error in file TUBE.DAT!$'
         FileReadErrorMsg02  Db        'Error in file TUBE.MAP!$'
         FileReadErrorMsg03  Db        'Error in file AALIAS.DAT!$'
         WaitMessage         Db        'Please wait, calculating radiuses...$'
         ByeByeMessage       Db        'You made that!$'

         RADIUSFILE DB 'TUBE.RAD',00H

; Program variables
         ColorSegment        Dw        ?
         RadiusSegment       Dw        ?
         VideoSegment        Dw        ?
         FileHandle          Dw        ?
         LandscapeSegment    Dw        ?
         PixelPointerSegment Dw        ?
         Palette             Db        0300h Dup (?)
         BitmapWidth         Dw        ?
         BitmapHeight        Db        ?
         BitmapLine          Db        0200h Dup (?)
         ColorTranslateSeg   Dw        ?
         Rotate              Dw        ?
         Moving              Dw        ?
         XangleDec           Dw        ?
         YangleDec           Dw        ?

; Program constants
         Sin                 Equ       00000h
         Cos                 Equ       00100h
         Trigon              Dw        00000h,0023Ch,00478h,006B3h,008EEh
                             Dw        00B28h,00D61h,00F99h,011D0h,01406h
                             Dw        0163Ah,0186Ch,01A9Dh,01CCBh,01EF7h
                             Dw        02121h,02348h,0256Ch,0278Eh,029ACh
                             Dw        02BC7h,02DDFh,02FF3h,03203h,03410h
                             Dw        03618h,0381Ch,03A1Ch,03C17h,03E0Eh
                             Dw        03FFFh,041ECh,043D4h,045B6h,04793h
                             Dw        0496Ah,04B3Ch,04D08h,04ECDh,0508Dh
                             Dw        05246h,053F9h,055A5h,0574Bh,058EAh
                             Dw        05A82h,05C13h,05D9Ch,05F1Fh,0609Ah
                             Dw        0620Dh,06379h,064DDh,06639h,0678Dh
                             Dw        068D9h,06A1Dh,06B59h,06C8Ch,06DB7h
                             Dw        06ED9h,06FF3h,07104h,0720Ch,0730Bh
                             Dw        07401h,074EEh,075D2h,076ADh,0777Fh
                             Dw        07847h,07906h,079BBh,07A67h,07B0Ah
                             Dw        07BA2h,07C32h,07CB7h,07D33h,07DA5h
                             Dw        07E0Dh,07E6Ch,07EC0h,07F0Bh,07F4Bh
                             Dw        07F82h,07FAFh,07FD2h,07FEBh,07FFAh
                             Dw        07FFFh,07FFAh,07FEBh,07FD2h,07FAFh
                             Dw        07F82h,07F4Bh,07F0Bh,07EC0h,07E6Ch
                             Dw        07E0Dh,07DA5h,07D33h,07CB7h,07C32h
                             Dw        07BA2h,07B0Ah,07A67h,079BBh,07906h
                             Dw        07847h,0777Fh,076ADh,075D2h,074EEh
                             Dw        07401h,0730Bh,0720Ch,07104h,06FF3h
                             Dw        06ED9h,06DB7h,06C8Ch,06B59h,06A1Dh
                             Dw        068D9h,0678Dh,06639h,064DDh,06379h
                             Dw        0620Dh,0609Ah,05F1Fh,05D9Ch,05C13h
                             Dw        05A82h,058EAh,0574Bh,055A5h,053F9h
                             Dw        05246h,0508Dh,04ECDh,04D08h,04B3Ch
                             Dw        0496Ah,04793h,045B6h,043D4h,041ECh
                             Dw        04000h,03E0Eh,03C17h,03A1Ch,0381Ch
                             Dw        03618h,03410h,03203h,02FF3h,02DDFh
                             Dw        02BC7h,029ACh,0278Eh,0256Ch,02348h
                             Dw        02121h,01EF7h,01CCBh,01A9Dh,0186Ch
                             Dw        0163Ah,01406h,011D0h,00F99h,00D61h
                             Dw        00B28h,008EEh,006B3h,00478h,0023Ch
                             Dw        00000h,0FDC4h,0FB88h,0F94Dh,0F712h
                             Dw        0F4D8h,0F29Fh,0F067h,0EE30h,0EBFAh
                             Dw        0E9C6h,0E794h,0E563h,0E335h,0E109h
                             Dw        0DEDFh,0DCB8h,0DA94h,0D872h,0D654h
                             Dw        0D439h,0D221h,0D00Dh,0CDFDh,0CBF0h
                             Dw        0C9E8h,0C7E4h,0C5E4h,0C3E9h,0C1F2h
                             Dw        0C000h,0BE14h,0BC2Ch,0BA4Ah,0B86Dh
                             Dw        0B696h,0B4C4h,0B2F8h,0B133h,0AF73h
                             Dw        0ADBAh,0AC07h,0AA5Bh,0A8B5h,0A716h
                             Dw        0A57Eh,0A3EDh,0A264h,0A0E1h,09F66h
                             Dw        09DF3h,09C87h,09B23h,099C7h,09873h
                             Dw        09727h,095E3h,094A7h,09374h,09249h
                             Dw        09127h,0900Dh,08EFCh,08DF4h,08CF5h
                             Dw        08BFFh,08B12h,08A2Eh,08953h,08881h
                             Dw        087B9h,086FAh,08645h,08599h,084F6h
                             Dw        0845Eh,083CEh,08349h,082CDh,0825Bh
                             Dw        081F3h,08194h,08140h,080F5h,080B5h
                             Dw        0807Eh,08051h,0802Eh,08015h,08006h
                             Dw        08001h,08006h,08015h,0802Eh,08051h
                             Dw        0807Eh,080B5h,080F5h,08140h,08194h
                             Dw        081F3h,0825Bh,082CDh,08349h,083CEh
                             Dw        0845Eh,084F6h,08599h,08645h,086FAh
                             Dw        087B9h,08881h,08953h,08A2Eh,08B12h
                             Dw        08BFFh,08CF5h,08DF4h,08EFCh,0900Dh
                             Dw        09127h,09249h,09374h,094A7h,095E3h
                             Dw        09727h,09873h,099C7h,09B23h,09C87h
                             Dw        09DF3h,09F66h,0A0E1h,0A264h,0A3EDh
                             Dw        0A57Eh,0A716h,0A8B5h,0AA5Bh,0AC07h
                             Dw        0ADBAh,0AF73h,0B133h,0B2F8h,0B4C4h
                             Dw        0B696h,0B86Dh,0BA4Ah,0BC2Ch,0BE14h
                             Dw        0C000h,0C1F2h,0C3E9h,0C5E4h,0C7E4h
                             Dw        0C9E8h,0CBF0h,0CDFDh,0D00Dh,0D221h
                             Dw        0D439h,0D654h,0D872h,0DA94h,0DCB8h
                             Dw        0DEDFh,0E109h,0E335h,0E563h,0E794h
                             Dw        0E9C6h,0EBFAh,0EE30h,0F067h,0F29Fh
                             Dw        0F4D8h,0F712h,0F94Dh,0FB88h,0FDC4h
                             Dw        00000h,0023Ch,00478h,006B3h,008EEh
                             Dw        00B28h,00D61h,00F99h,011D0h,01406h
                             Dw        0163Ah,0186Ch,01A9Dh,01CCBh,01EF7h
                             Dw        02121h,02348h,0256Ch,0278Eh,029ACh
                             Dw        02BC7h,02DDFh,02FF3h,03203h,03410h
                             Dw        03618h,0381Ch,03A1Ch,03C17h,03E0Eh
                             Dw        03FFFh,041ECh,043D4h,045B6h,04793h
                             Dw        0496Ah,04B3Ch,04D08h,04ECDh,0508Dh
                             Dw        05246h,053F9h,055A5h,0574Bh,058EAh
                             Dw        05A82h,05C13h,05D9Ch,05F1Fh,0609Ah
                             Dw        0620Dh,06379h,064DDh,06639h,0678Dh
                             Dw        068D9h,06A1Dh,06B59h,06C8Ch,06DB7h
                             Dw        06ED9h,06FF3h,07104h,0720Ch,0730Bh
                             Dw        07401h,074EEh,075D2h,076ADh,0777Fh
                             Dw        07847h,07906h,079BBh,07A67h,07B0Ah
                             Dw        07BA2h,07C32h,07CB7h,07D33h,07DA5h
                             Dw        07E0Dh,07E6Ch,07EC0h,07F0Bh,07F4Bh
                             Dw        07F82h,07FAFh,07FD2h,07FEBh,07FFAh
                             Dw        07FFFh,07FFAh,07FEBh,07FD2h,07FAFh
                             Dw        07F82h,07F4Bh,07F0Bh,07EC0h,07E6Ch
                             Dw        07E0Dh,07DA5h,07D33h,07CB7h,07C32h
                             Dw        07BA2h,07B0Ah,07A67h,079BBh,07906h
                             Dw        07847h,0777Fh,076ADh,075D2h,074EEh
                             Dw        07401h,0730Bh,0720Ch,07104h,06FF3h
                             Dw        06ED9h,06DB7h,06C8Ch,06B59h,06A1Dh
                             Dw        068D9h,0678Dh,06639h,064DDh,06379h
                             Dw        0620Dh,0609Ah,05F1Fh,05D9Ch,05C13h
                             Dw        05A82h,058EAh,0574Bh,055A5h,053F9h
                             Dw        05246h,0508Dh,04ECDh,04D08h,04B3Ch
                             Dw        0496Ah,04793h,045B6h,043D4h,041ECh
                             Dw        04000h,03E0Eh,03C17h,03A1Ch,0381Ch
                             Dw        03618h,03410h,03203h,02FF3h,02DDFh
                             Dw        02BC7h,029ACh,0278Eh,0256Ch,02348h
                             Dw        02121h,01EF7h,01CCBh,01A9Dh,0186Ch
                             Dw        0163Ah,01406h,011D0h,00F99h,00D61h
                             Dw        00B28h,008EEh,006B3h,00478h,0023Ch
                             Dw        00000h,0FDC4h,0FB88h,0F94Dh,0F712h
                             Dw        0F4D8h,0F29Fh,0F067h,0EE30h,0EBFAh
                             Dw        0E9C6h,0E794h,0E563h,0E335h,0E109h
                             Dw        0DEDFh,0DCB8h,0DA94h,0D872h,0D654h
                             Dw        0D439h,0D221h,0D00Dh,0CDFDh,0CBF0h
                             Dw        0C9E8h,0C7E4h,0C5E4h,0C3E9h,0C1F2h
                             Dw        0C000h,0BE14h,0BC2Ch,0BA4Ah,0B86Dh
                             Dw        0B696h,0B4C4h,0B2F8h,0B133h,0AF73h
                             Dw        0ADBAh,0AC07h,0AA5Bh,0A8B5h,0A716h
                             Dw        0A57Eh,0A3EDh,0A264h,0A0E1h,09F66h
                             Dw        09DF3h,09C87h,09B23h,099C7h,09873h
                             Dw        09727h,095E3h,094A7h,09374h,09249h
                             Dw        09127h,0900Dh,08EFCh,08DF4h,08CF5h
                             Dw        08BFFh,08B12h,08A2Eh,08953h,08881h
                             Dw        087B9h,086FAh,08645h,08599h,084F6h
                             Dw        0845Eh,083CEh,08349h,082CDh,0825Bh
                             Dw        081F3h,08194h,08140h,080F5h,080B5h
                             Dw        0807Eh,08051h,0802Eh,08015h,08006h
                             Dw        08001h,08006h,08015h,0802Eh,08051h
                             Dw        0807Eh,080B5h,080F5h,08140h,08194h
Data                         EndS

Code                         Segment   Para Use16
                             .486
                             Assume    Cs:Code,Ds:Data

         Begin:              Mov       Ax,Seg Data
                             Mov       Ds,Ax

; Initialize voxel tube routine and store important segments
                             Db        9Ah
                             Dw        Offset VoxelTubeInit
                             Dw        Seg VoxelTubeInit
                             Mov       Dx,Offset MemoryErrMsg
                             Jc        ErrExitProg
                             Mov       [LandscapeSegment],Ax
                             Add       Ax,1000h
                             Mov       [PixelPointerSegment],Ax

; Allocate memory for bitmap, radiuses and video segment
                             Mov       Ah,48h
                             Mov       Bx,3FB4h
                             Int       21h
                             Jc        ErrExitProg
                             Mov       [ColorSegment],Ax
                             Add       Ax,1000h
                             Mov       [RadiusSegment],Ax
                             Add       Ax,1000h
                             Mov       [ColorTranslateSeg],Ax
                             Add       Ax,1000h
                             Mov       [VideoSegment],Ax
                             Add       Ax,0FA0h
                             Mov       Es,Ax
                             Xor       Eax,Eax
                             Mov       Di,13Ch
         ClearLastVideoLine: Mov       Es:[Di],Eax
                             Sub       Di,04h
                             Jnc       ClearLastVideoLine


; Open voxel tube landscape->screen tranformation pointer file
                             Mov       Ax,3D00h
                             Mov       Dx,Offset TubeTranslateFile
                             Int       21h
                             Mov       Dx,Offset FileNotFoundMsg01
                             Jc        ErrExitProg
                             Mov       [FileHandle],Ax
                             Mov       Bx,Ax

; Read pointers for half of screen (320x100)
                             Mov       Ah,3Fh
                             Mov       Cx,0FA00h
                             Push      Ds
                             Mov       Ds,[PixelPointerSegment]
                             Xor       Dx,Dx
                             Int       21h
                             Pop       Ds
                             Mov       Dx,Offset FileReadErrorMsg01
                             Jc        ErrExitProgCF
                             Mov       Ah,3Eh
                             Int       21h

; Open voxel tube bitmap file
                             Mov       Ax,3D00h
                             Mov       Dx,Offset TubeBitmapFile
                             Int       21h
                             Mov       Dx,Offset FileNotFoundMsg02
                             Jc        ErrExitProg
                             Mov       [FileHandle],Ax
                             Mov       Bx,Ax

; Load palette and bitmap size
                             Mov       Ah,3Fh
                             Mov       Cx,0303h
                             Mov       Dx,Offset Palette
                             Int       21h
                             Mov       Dx,Offset FileReadErrorMsg02
                             Jc        ErrExitProgCF
                             Cmp       Ax,Cx
                             Jne       ErrExitProgCF

; Clear bitmap segment with back ground color
                             Mov       Bp,[ColorSegment]
                             Mov       Es,Bp
                             Xor       Di,Di
                             Mov       Al,3Eh
         SetBitmapBGColor:   Mov       Es:[Di],Al
                             Dec       Di
                             Jnz       SetBitmapBGColor

; Load bitmap line by line
                             Mov       Bx,[FileHandle]
         LoadBitmap:         Mov       Ah,3Fh
                             Mov       Cx,[BitmapWidth]
                             Mov       Dx,Offset BitmapLine
                             Int       21h
                             Mov       Dx,Offset FileReadErrorMsg02
                             Jc        ErrExitProgCF
                             Cmp       Ax,Cx
                             Jne       ErrExitProgCF

; Move bitmap line to color segment and double the width
                             Mov       Si,[BitmapWidth]
                             Dec       Si
                             Mov       Di,Si
                             Add       Si,Offset BitmapLine
;                             Add       Di,Di
                             Mov       Es,Bp
                             Add       Bp,+20h
         FixBitmapLine:      Mov       Al,[Si]
                             Mov       Ah,Al
                             Mov       Es:[Di],Ax
                             Dec       Si
                             Sub       Di,01h
                             Jnc       FixBitmapLine
                             Dec       [BitmapHeight]
                             Jnz       LoadBitmap

; Copy bitmap to the higher part of segment for tube scroll
                             Mov       Es,[ColorSegment]
                             Mov       Si,32764
         CopyBitmap:         Mov       Eax,Es:[Si]
                             Mov       Es:[Si+8000h],Eax
                             Sub       Si,04h
                             Jnc       CopyBitmap

; Close bitmap file
                             Mov       Bx,[FileHandle]
                             Mov       Ah,3Eh
                             Int       21h

; Load color translating values for antialiasing
                             Mov       Ax,3D00h
                             Mov       Dx,Offset AntialiasDataFile
                             Int       21h
                             Mov       Dx,Offset FileNotFoundMsg03
                             Jc        ErrExitProg
                             Mov       [FileHandle],Ax
                             Mov       Bx,Ax
                             Mov       Ah,3Fh
                             Mov       Cx,8000h
                             Xor       Dx,Dx
                             Push      Ds
                             Mov       Ds,[ColorTranslateSeg]
                             Int       21h
                             Pop       Ds
                             Mov       Dx,Offset FileReadErrorMsg03
                             Jc        ErrExitProgCF
                             Cmp       Ax,Cx
                             Jne       ErrExitProgCF

                             Mov       Ah,3Fh
                             Xor       Dx,Dx
                             Push      Ds
                             Mov       Bp,[ColorTranslateSeg]
                             Add       Bp,0800h
                             Mov       Ds,Bp
                             Int       21h
                             Pop       Ds
                             Mov       Dx,Offset FileReadErrorMsg03
                             Jc        ErrExitProgCF
                             Cmp       Ax,Cx
                             Jne       ErrExitProgCF
                             Mov       Ah,3Eh
                             Int       21h

; Clear screen and write wait message to the screen
                             Mov       Ax,0003h
                             Int       10h
                             Mov       Ah,09h
                             Mov       Dx,Offset WaitMessage
                             Int       21h

; Calculate tube radiuses

                             Mov       Ax,3D00h
                             Mov       Dx,Offset RadiusFile
                             Int       21h
                             Mov       Ah,3Fh
                             Mov       Cx,8000h
                             Xor       Dx,Dx
                             Push      Ds
                             Mov       Ds,[RadiusSegment]
                             Int       21h
                             Pop       Ds
                             Mov       Ah,3Eh
                             Int       21h
                             Mov       Es,[RadiusSegment]
                             Mov       Si,7FFFh
         CopyRadiuses:       Mov       Al,Es:[Si]
                             Mov       Es:[Si+8000h],Al
                             Dec       Si
                             Jns       CopyRadiuses



                             Mov       Es,[RadiusSegment]
                             Mov       Si,0FE00h       ; y
                             Xor       Di,Di           ; y int
                             Mov       [YangleDec],Di  ; y dec
         MakeRadiusTable1:   Mov       Bx,01FFh        ; x
                             Xor       Bp,Bp           ; x int
                             Mov       [XangleDec],Bp  ; x dec
         MakeRadiusLine1:    Add       Bp,Bp
                             Mov       Ax,Ds:[Bp+Sin]
                             Shr       Bp,01h
                             Add       Di,Di
;                             Imul      Ds:[Di+Sin]
                             Shr       Di,01h
                             Mov       Ax,400
                             Imul      Dx
                             Add       Dl,128
;                             Mov       Es:[Bx+Si],Dl

                             Add       [XangleDec],23040  ; x sinus
                             Adc       Bp,0
                             Cmp       Bp,360
                             Jb        NoXangleFix1
                             Sub       Bp,360
         NoXangleFix1:       Dec       Bx
                             Jns       MakeRadiusLine1
                             Add       [YangleDec],40960  ; y sinus
                             Adc       Di,5
                             Cmp       Di,360
                             Jb        NoYangleFix1
                             Sub       Di,360
         NoYangleFix1:       Sub       Si,0200h
                             Jnc       MakeRadiusTable1


                             Mov       Si,0FE00h       ; y
                             Xor       Di,Di           ; y int
                             Mov       [YangleDec],Di  ; y dec
         MakeRadiusTable2:   Mov       Bx,01FFh        ; x
                             Xor       Bp,Bp           ; x int
                             Mov       [XangleDec],Bp  ; x dec
         MakeRadiusLine2:    Add       Bp,Bp
                             Mov       Ax,Ds:[Bp+Sin]
                             Shr       Bp,01h
                             Add       Di,Di
                             Imul      Ds:[Di+Trigon+Sin]
                             Shr       Di,01h
                             Mov       Ax,400
                             Imul      Dx
;                             Add       Es:[Bx+Si],Dl

                             Add       [XangleDec],60416  ; x sinus
                             Adc       Bp,4
                             Cmp       Bp,360
                             Jb        NoXangleFix2
                             Sub       Bp,360
         NoXangleFix2:       Dec       Bx
                             Jns       MakeRadiusLine2
                             Add       [YangleDec],32768  ; y sinus
                             Adc       Di,22
                             Cmp       Di,360
                             Jb        NoYangleFix2
                             Sub       Di,360
         NoYangleFix2:       Sub       Si,0200h
                             Jnc       MakeRadiusTable2


; Set screen to video mode (320x200x256) and change new palette
                             Mov       Ax,0013h
                             Int       10h

                             Mov       Dx,03C4h    ; Sequencer registers
                             Mov       Ax,0100h    ;  Synchronous reset while
                             Out       Dx,Ax       ;  switching clocks
                             Mov       Dx,03C2h    ; Miscellaneous registers
                             Mov       Al,0E7h     ;  Select 28 MHz dot clock
                             Out       Dx,Al       ;  & 60 Hz scanning rate
                             Mov       Dx,03C4h    ; Sequencer registers
                             Mov       Ax,0300h    ;  Undo reset
                             Out       Dx,Ax       ;  (Restart sequencer)

                             Mov       Dx,03D4h    ; CRTC registers
                             Mov       Al,11h      ;  Enable write to
                             Out       Dx,Al       ;  registers 0-7
                             Inc       Dx
                             In        Al,Dx
                             And       Al,7Fh
                             Out       Dx,Al

                             Dec       Dx
                             Mov       Ax,0D06h
                             Out       Dx,Ax
                             Mov       Ax,2E07h
                             Out       Dx,Ax
                             Mov       Ax,0109h
                             Out       Dx,Ax
                             Mov       Ax,0EA10h
                             Out       Dx,Ax
                             Mov       Ax,0AC11h
                             Out       Dx,Ax
                             Mov       Ax,0DF12h
                             Out       Dx,Ax
                             Mov       Ax,0b615h
                             Out       Dx,Ax
                             Mov       Ax,02816h
                             Out       Dx,Ax
                             Mov       Ax,2818h
                             Out       Dx,Ax

; Wait until screen is ready (2 seconds)
                             Mov       Cl,120    ; Wait 2 seconds
                             Mov       Dx,03DAh
         WaitForVR:          In        Al,Dx
                             And       Al,08h
                             Jz        WaitForVR
         WaitForDE:          In        Al,Dx
                             And       Al,08h
                             Jnz       WaitForDE
                             Dec       Cl
                             Jnz       WaitForVR

; Set palette
                             Mov       Si,Offset Palette
                             Cld
                             Mov       Cx,0300h
                             Mov       Dx,03C8h
                             Xor       Al,Al
                             Out       Dx,Al
                             Inc       Dx
                             Rep       OutsB

; Set initial values of the tube
                             Mov       [Rotate],0000h
                             Mov       [Moving],0000h

; Introduction loop
; /////////////////

; Clear landscape segment
         IntroLoop:          Call      DrawAndMoveTube

; Check if key pressed, if not, loop
                             Mov       Ah,01h
                             Int       16h
                             Jz        IntroLoop
                             Xor       Ah,Ah
                             Int       16h

         WaitRightPosLoop:   Call      DrawAndMoveTube
                             Cmp       [Moving],0000h
                             Jne       WaitRightPosLoop

                             Mov       Ax,[RadiusSegment]
                             Add       Ax,07E0h
                             Mov       Es,Ax
                             Xor       Eax,Eax
                             Mov       Di,01F0h
         MakeTubeEndLine:    Mov       Es:[Di],Eax
                             Mov       Es:[Di+04h],Eax
                             Mov       Es:[Di+08h],Eax
                             Mov       Es:[Di+0Ch],Eax
                             Sub       Di,10h
                             Jnc       MakeTubeEndLine

         ScrollTubeToEnd:    Call      DrawAndMoveTube
                             Cmp       [Moving],0000h
                             Jne       ScrollTubeToEnd

; Change back to text mode, output end message to the screen and leave
                             Mov       Ax,0003h
                             Int       10h
                             Mov       Ah,09h
                             Mov       Dx,Offset ByeByeMessage
                             Int       21h
                             Mov       Ax,4C00h
                             Int       21h

; Close file at the error when file is open
         ErrExitProgCF:      Mov       Ah,3Eh
                             Mov       Bx,[FileHandle]
                             Int       21h

; Exit program with error message
         ErrExitProg:        Mov       Ah,09h
                             Int       21h
                             Mov       Ax,4C01h
                             Int       21h


         DrawAndMoveTube     Proc      Near

; Clear landscape segment
                             Xor       Eax,Eax
                             Mov       Es,[LandscapeSegment]
                             Mov       Di,0FFF0h
         ClearLandscapeSeg:  Mov       Es:[Di],Eax
                             Mov       Es:[Di+04h],Eax
                             Mov       Es:[Di+08h],Eax
                             Mov       Es:[Di+0Ch],Eax
                             Sub       Di,10h
                             Jnc       ClearLandscapeSeg

; Draw tube landscape
                             Push      Ds
                             Mov       Dx,[Rotate]
                             Mov       Ax,[ColorSegment]
                             Add       Ax,[Moving]
                             Mov       Gs,Ax
                             Mov       Ax,[RadiusSegment]
                             Add       Ax,[Moving]
                             Mov       Ds,Ax
                             Db        9Ah
                             Dw        Offset VoxelTube
                             Dw        Seg VoxelTube
                             Pop       Ds

; Draw tube landscape to the video segment by twisting it around a cylinter
                             Mov       Es,[VideoSegment]
                             Db        9Ah
                             Dw        Offset DrawVoxelTube
                             Dw        Seg DrawVoxelTube

; Move video segment to the screen via antialiasing routine
                             Push      Ds
                             Mov       Fs,[VideoSegment]
                             Mov       Ds,[ColorTranslateSeg]
                             Db        9Ah
                             Dw        Offset Antialias320
                             Dw        Seg Antialias320
                             Pop       Ds

; Normal video segment to screen memory move
;                             Mov       Ax,0A000h
;                             Mov       Es,Ax
;                             Mov       Fs,[VideoSegment]
;                             Mov       Di,64000-4
;         MoveVideoToScreen:  Mov       Eax,Fs:[Di]
;                             Mov       Es:[Di],Eax
;                             Sub       Di,04h
;                             Jnc       MoveVideoToScreen

; Change tube parameters
                             Mov       Ax,[Rotate]
                             Add       Ax,+02h
                             Cmp       Ax,0200h
                             Jb        NoRotateFix
                             Sub       Ax,0200h
         NoRotateFix:        Mov       [Rotate],Ax

                             Mov       Ax,[Moving]
                             Add       Ax,+20h
                             Cmp       Ax,0800h
                             Jb        NoMovingFix
                             Sub       Ax,0800h
         NoMovingFix:        Mov       [Moving],Ax
                             Ret
         DrawAndMoveTube     EndP

Code                         EndS

Include TUBE.ASM
Include AALIAS.ASM
                             End       Begin
