{$M 30720,0,655360}

(* Double Screen Rotation (C) '95 By Paradise *)

Unit DbRotate;

Interface

 Procedure DbRotate_Init;
 Procedure DbRotate_Setup(SDelayed : LongInt);
 Procedure DbRotate_Run;
 Procedure DbRotate_Done;

Implementation

Uses Crt,Vga,FP,DbRGFX;

Var
 I                            : Integer;
 Degree, Scale, Direction     : Integer;
 Degree2, Scale2, Direction2  : Integer;
 BigSpr                       : Pointer;
 Step, Steps                  : LongInt;
 PalTik                       : Byte;

(* Oryginal by The Faker, optimized by me *)
Procedure PutTextureGlenz(Off : Word; IncX, IncY:Integer; P:Pointer; GSeg : Word; IncColor : Byte);
Var
 X,Y,PosX,PosY,PX,PY : Integer;
Begin
 PosX:=-(150 div 2)*IncX; PosY:=-(50 div 2)*IncY;
 For Y:=0 to 99 do
 Begin
  PX:=PosX;  PY:=PosY;
  Asm
   push ds
   mov ax,GSeg
   mov es,ax
   mov ax,y
   xchg al,ah
   mov di,ax
   shr di,2
   add di,ax
   add di,Off
   mov cx,150
   lds si,p
   cld
   mov ax,incx
   db 66h; shl ax,16
   mov ax,incy
   db 66h; mov si,ax
   mov dx,px
   db 66h; shl dx,16
   mov dx,py
@1:
   db 66h; add dx,si
   db 66h; mov bx,dx
   db 66h; shr bx,16
   mov bl,dh
   mov al,[bx]
   db 66h; add dx,si
   db 66h; mov bx,dx
   db 66h; shr bx,16
   mov bl,dh
   mov ah,[bx]
   or  al, al
   jz  @s1
   add al, IncColor
   mov es:[di], al
@s1:
   inc di
   or  ah, ah
   jz  @s2
   add ah, IncColor
   mov es:[di], ah
@s2:
   inc di
   dec cx
   jnz @1
   pop ds
  End;
  Inc(PosX,IncY);  Inc(PosY,-IncX);
 End;
End;

Procedure LoadSprite;
Begin
 Move(@Pent256Palette^,StdPal,768);
 UnPackPent256a(BigSpr^);
 UnPackPent256b(Ptr(Seg(BigSpr^),Ofs(BigSpr^)+32768)^);
End;

Type
 PalType  = Array [0..255,1..3] of Byte;

Var
 TrackX, TrackY : Array [0..400] of Real;
 Off1, Off2, tick : Word;

Var
 ZeroPal,
 MainPal,
 Palette,
 SprPal,
 Target   : PalType;
 IncPal   : Array [0..255,1..3] of LongInt;

Procedure CalcFading(P1, P2 : PalType; FFSteps : Integer);
Var
 i : Integer;
Begin
 For i:=0 to 255 do
 Begin
  IncPal[i,1]:=FixedDiv(I2L(P2[i,1]-P1[i,1]),I2L(FFSteps));
  IncPal[i,2]:=FixedDiv(I2L(P2[i,2]-P1[i,2]),I2L(FFSteps));
  IncPal[i,3]:=FixedDiv(I2L(P2[i,3]-P1[i,3]),I2L(FFSteps));
 End;
 MainPal:=P1;
 Palette:=P1;
 SetPalette(@Palette);
End;

Procedure UpdateFading(Frame : Integer);
Var
 i : Integer;
Begin
 For i:=0 to 255 do
 Begin
  Palette[i,1]:=L2I(I2L(MainPal[i,1])+FixedMul(IncPal[i,1],I2L(Frame)));
  Palette[i,2]:=L2I(I2L(MainPal[i,2])+FixedMul(IncPal[i,2],I2L(Frame)));
  Palette[i,3]:=L2I(I2L(MainPal[i,3])+FixedMul(IncPal[i,3],I2L(Frame)));
 End;
 SetPalette(@Palette);
End;

Procedure RenderOnce;
Begin
 ClearFake(VSeg);
 PutTextureGlenz(Off1,Round(TrackX[Degree]*Scale*4),Round(TrackY[Degree]*Scale*4),BigSpr,VSeg,128);
 PutTextureGlenz(Off2,Round(TrackX[Degree2]*Scale2*4),Round(TrackY[Degree2]*Scale2*4),BigSpr,VSeg,0);
 ShowFake(VSeg);
End;

Procedure DbRotate_Init;
Begin
 InitVPage;
 FillChar(ZeroPal,768,0);
 SetPalette(@ZeroPal);
 GetMem(BigSpr,65535);
 FillChar(BigSpr^,65535,0);
 LoadSprite;
 Move(StdPal,SprPal,768);
 CalcFading(ZeroPal,SprPal,30);
 Degree:=160;    Direction:=4;   Scale:=70;
 Degree2:=320;   Direction2:=4;  Scale2:=70;
 For I:=0 to 400 do
 Begin
  TrackX[I]:=Cos(I/180*Pi*2);
  TrackY[I]:=Sin(I/180*Pi);
 End;
 Off1:=10; Off2:=320*100+10; tick:=0; Step:=0; Steps:=500; PalTik:=0;
End;

Procedure DbRotate_Setup(SDelayed : LongInt);
Begin
 Steps:=SDelayed;
End;

Procedure DbRotate_Run;
Begin
 While Step<Steps do
 Begin
  If (PalTik<31) then
  Begin
   UpdateFading(PalTik);
   Inc(PalTik);
  End;
  If (Step=Steps-31) then
  Begin
   FillChar(IncPal,SizeOf(IncPal),0);
   SetPalette(@SprPal);
   CalcFading(SprPal,ZeroPal,30);
   PalTik:=0;
  End;
  RenderOnce;
  Inc(Degree,2); Dec(Degree2,2);
  Inc(Scale,Direction); Dec(Scale2,Direction2);
  If (Degree>=360) then Degree:=Degree-360;
  If (Degree2<0) then Degree2:=360+Degree2;
  If (Scale>400) or (Scale<60) then Direction:=-Direction;
  If (Scale2>400) or (Scale2<60) then Direction2:=-Direction2;
  If tick>50 then
  Begin
   If Off1<50*320+10 then Inc(Off1,640);
   If Off2>50*320+10 then Dec(Off2,640);
  End else Inc(tick);
  Inc(Step);
 End;
End;

Procedure DbRotate_Done;
Begin
 FreeMem(BigSpr,65535);
 DoneVPage;
End;

End.

