{$M 32000,0,655360}
{}
{        Tube Mapping         (C) '95 By Paradise (Marcin Jaskowiak)         }
{}
Unit Tube;

Interface

 Procedure Tube_Init;
 Procedure Tube_Setup(HowLong : Word);
 Procedure Tube_Run;
 Procedure Tube_Done;

Implementation

Uses Crt, Dos, Vga, TubeGFX1, TubeGFX2, TubeGFX3, DAC;

Const
 IncX                  : Byte = 0;
 IncY                  : Byte = 0;
 On                    = True;
 Off                   = False;

Var
 TubeXPtr, TubeYPtr,
 Texture               : Pointer;
 Plik                  : File;
 B, Num                : Byte;
 Step, Steps           : LongInt;
 TubePal, ZeroPal      : Array [0..255,1..3] of Byte;

{}
{ TubeInit() - allocate memory and load an arrays.                           }
{}
Procedure TubeInit(Nazwa : String);
Begin
 GetMem(TubeXPtr, 64000);
 GetMem(TubeYPtr, 64000);
 UnpackTubeX(TubeXPtr^);
 UnpackTubeY(TubeYPtr^);
End;

{}
{ TubeDone() - deallocate memory.                                            }
{}
Procedure TubeDone;
Begin
 FreeMem(TubeXPtr, 64000);
 FreeMem(TubeYPtr, 64000);
End;

{}
{ TextureInit() - allocate memory, load a texture and sets palette.          }
{}
Procedure TextureInit(Nazwa : String);
Begin
 GetMem(Texture, 65535);
 UnpackGround1(Texture^);
 UnpackGround2(Ptr(Seg(Texture^),Ofs(Texture^)+32768)^);
 Move(@GroundPalette^,TubePal,768);
 FillChar(ZeroPal,768,0);
End;

{}
{ TextureDone() - deallocate memory.                                         }
{}
Procedure TextureDone;
Begin
 FreeMem(Texture, 65535);
End;

{}
{ TextureMap() - map texture on 'OutSeg', using word mode.                   }
{}
Procedure TextureMap(OutSeg : Word); Assembler;
Asm
                  push   ds
                  mov    dl, IncX
                  shl    dx, 8
                  add    dl, IncY
                  mov    ax, OutSeg
                  mov    es, ax
                  xor    di, di
                  mov    ax, word ptr [TubeXPtr+2]
 db 8Eh,0E0h     {mov    fs, ax}
                  mov    ax, word ptr [TubeYPtr+2]
 db 8Eh,0E8h     {mov    gs, ax}
                  mov    ax, word ptr [Texture+2]
                  mov    ds, ax
                  mov    cx, 32000
                @@inner_loop:
 db 64h,08Ah,1Dh {mov    bl, fs:[di]}
 db 65h,08Ah,3Dh {mov    bh, gs:[di]}
                  add    bx, dx
                  mov    si, bx
                  inc    di
 db 64h,08Ah,1Dh {mov    bl, fs:[di]}
 db 65h,08Ah,3Dh {mov    bh, gs:[di]}
                  add    bx, dx
                  inc    di
                  mov    al, ds:[si]
                  mov    ah, ds:[bx]
                  mov    es:[di-2], ax
                  dec    cx
                  jnz    @@inner_loop
                  pop    ds
End;

{}
{ PaletteFix() - fix standard palette to make some kewl effects.             }
{}
Procedure PaletteFix(DoRed, DoGreen, DoBlue : Boolean);
Begin
 For Num:=0 to 255 do
 Begin
  B:=StdPal[Num*3];
  If DoRed   then StdPal[Num*3+0]:=B else StdPal[Num*3+0]:=0;
  If DoGreen then StdPal[Num*3+1]:=B else StdPal[Num*3+1]:=0;
  If DoBlue  then StdPal[Num*3+2]:=B else StdPal[Num*3+2]:=0;
 End;
 SetPalette(@StdPal);
End;

{}
{ Main.                                                                      }
{}

Procedure Tube_Init;
Begin
 TubeInit('Tube2');
 TextureInit('Ground');
 PaletteFix(On,Off,Off);
 Step:=0;
 Steps:=300;
End;

Procedure Tube_Setup(HowLong : Word);
Begin
 Steps:=HowLong;
End;

Procedure Tube_Done;
Begin
 TextureDone;
 TubeDone;
End;

Procedure Tube_Run;
Begin
 DAC_SetFading(@ZeroPal,@TubePal,20);
 While Step<Steps do
 Begin
  DAC_UpdateFading;
  TextureMap($A000);
  Inc(IncX,2);
  Inc(IncY,2);
  Inc(Step);
  If Step=Steps-21 then
  Begin
   DAC_SetFading(@TubePal,@ZeroPal,20);
  End;
 End;
End;

End.
