(* DAC 256-Color Palette Interface (C) '95 By Paradise *)

Unit DAC;

Interface

 Var
  DAC_Palette  : Array [0..255,1..3] of Byte;
  Fading       : Boolean;
  FadeTick,
  FadeSteps    : Word;

 Procedure DAC_SetColor(Number, Red, Green, Blue : Byte);
 Procedure DAC_SetPalette(P : Pointer);
 Procedure DAC_SetFading(FromP, ToP : Pointer; Steps : Word);
 Procedure DAC_UpdateFading;

Implementation
Uses FP;

Var
 DEST_Palette,
 SRC_Palette  : Array [0..255,1..3] of Byte;
 DAC_Fade     : Array [0..255,1..3] of LongInt;
 Count        : Word;

Procedure DAC_SetColor(Number, Red, Green, Blue : Byte); Assembler;
Asm
 mov  dx, 03C8h
 mov  al, Number
 out  dx, al
 inc  dx
 mov  al, Red
 out  dx, al
 mov  al, Green
 out  dx, al
 mov  al, Blue
 out  dx, al
End;

Procedure DAC_SetPalette(P : Pointer); Assembler;
Asm
 push ds
 mov ax, word ptr [P+2]
 mov ds, ax
 mov si, word ptr [P]
 mov cx, 768
 mov dx, 03C8h
 xor ax, ax
 out dx, al
 inc dx
 rep outsb
 pop ds
End;

Procedure DAC_SetFading(FromP, ToP : Pointer; Steps : Word);
Begin
 Move(FromP^,SRC_Palette,768);
 Move(ToP^,DEST_Palette,768);
 Move(SRC_Palette,DAC_Palette,768);
 FadeSteps:=Steps;
 For Count:=0 to 255 do
 Begin
  DAC_Fade[Count,1]:=FixedDiv(I2L(DEST_Palette[Count,1]-SRC_Palette[Count,1]),I2L(Steps));
  DAC_Fade[Count,2]:=FixedDiv(I2L(DEST_Palette[Count,2]-SRC_Palette[Count,2]),I2L(Steps));
  DAC_Fade[Count,3]:=FixedDiv(I2L(DEST_Palette[Count,3]-SRC_Palette[Count,3]),I2L(Steps));
 End;
 Fading:=True;
 FadeTick:=0;
End;

Procedure DAC_UpdateFading;
Begin
 If not Fading then Exit;
 If FadeTick=FadeSteps then Fading:=False;
 For Count:=0 to 255 do
 Begin
  DAC_Palette[Count,1]:=L2I(I2L(SRC_Palette[Count,1])+FixedMul(DAC_Fade[Count,1],I2L(FadeTick)));
  DAC_Palette[Count,2]:=L2I(I2L(SRC_Palette[Count,2])+FixedMul(DAC_Fade[Count,2],I2L(FadeTick)));
  DAC_Palette[Count,3]:=L2I(I2L(SRC_Palette[Count,3])+FixedMul(DAC_Fade[Count,3],I2L(FadeTick)));
 End;
 Inc(FadeTick);
 DAC_SetPalette(@DAC_Palette);
End;

Begin
 Fading:=False;
 FadeTick:=0;
 FadeSteps:=0;
End.