Unit VGA; { VGA handling procedures by Paradise (alias The Crow) }
          { (paradise@bachus.umcs.lublin.pl)    }

Interface

 Var
  VPage   : Pointer;
  VSeg    : Word;
  StdPal  : Array [0..767] of Byte;
  YOfs    : Array [0..199] of Word;

 Procedure InitVga;
 Procedure Mode80x50;
 Procedure CloseVga;
 Procedure InitVPage;
 Procedure DoneVPage;
 Procedure InitYOfs;
 Procedure SetColor(Num,Red,Green,Blue : Byte);
 Procedure SetPalette(What : Pointer);
 Procedure ClearFake(FakeSeg : Word);
 Procedure ShowFake(FakeSeg : Word);
 Procedure CopyFake(Src,Dest : Word);
 Procedure Plot(X,Y : Integer; Color : Byte; GSeg : Word);
 Procedure VRet;
 Procedure Line(X1,Y1,X2,Y2 : Integer; Color : Byte; GSeg : Word);

Implementation

Procedure InitVga; Assembler;
Asm
 mov ax,13h
 int 10h
End;

Procedure CloseVga; Assembler;
Asm
 mov ax,03h
 int 10h
End;

Procedure InitVPage;
Begin
 GetMem(VPage,64000);
 VSeg:=Seg(VPage^);
 ClearFake(VSeg);
End;

Procedure DoneVPage;
Begin
 FreeMem(VPage,64000);
End;

Procedure SetColor(Num,Red,Green,Blue : Byte); Assembler;
Asm
 mov dx, 3c8h
 mov al, Num
 out dx, al
 inc dx
 mov al, Red
 out dx, al
 mov al, Green
 out dx, al
 mov al, Blue
 out dx, al
End;

Procedure SetPalette(What : Pointer); Assembler;
Asm
 cld
 push ds
 mov ax, word ptr [What+2]
 mov ds, ax
 mov si, word ptr [What]
 mov cx, 768
 mov dx, 3c8h
 xor ax, ax
 out dx, al
 inc dx
 rep outsb
 pop ds
End;

Procedure ClearFake(FakeSeg : Word); Assembler;
Asm
 db 66h; xor ax, ax
 mov cx, 16000
 mov es, [FakeSeg]
 xor di, di
 cld
 db 66h; rep stosw
End;

Procedure ShowFake(FakeSeg : Word); Assembler;
Asm
 push [SegA000]
 pop es
 push ds
 mov ds, [FakeSeg]
 xor si, si
 xor di, di
 mov cx, 16000
 cld
 db 66h
 rep movsw
 pop ds
End;

Procedure CopyFake(Src,Dest : Word); Assembler;
Asm
 push ds
 mov ax, Src
 mov ds, ax
 mov ax, Dest
 mov es, ax
 xor si, si
 xor di, di
 mov cx, 16000
 cld
 db 66h
 rep movsw
 pop ds
End;

Procedure Plot; Assembler;
Asm
 mov ax, GSeg
 mov es, ax
 mov ax, Y
 mov bx, ax
 shl ax, 6
 shl bx, 8
 mov di, ax
 add di, bx
 add di, X
 mov al, Color
 mov es:[di], al
End;

Procedure VRet; Assembler;
Asm
 mov dx, 3dah
@1:
 in al, dx
 test al, 8h
 jnz @1
@2:
 in al, dx
 test al, 8h
 jz @2
End;

Procedure Line(X1,Y1,X2,Y2 : Integer; Color : Byte; GSeg : Word);
Var X_, LgDelta, ShDelta, LgStep, ShStep, Cycle, PointAddr : Integer;
Procedure Swap(Var a, b : Integer);
Var t : Integer; Begin t:=a; a:=b; b:=t; End;
begin
 LgDelta := X2 - X1;
 ShDelta := Y2 - Y1;
 If LgDelta < 0 then
 Begin
  LgDelta := -LgDelta;
  LgStep := -1;
 End else LgStep := 1;
 If ShDelta < 0 then
 Begin
  ShDelta := -ShDelta;
  ShStep := -1;
 End else ShStep := 1;
 If LgDelta > ShDelta then
 Begin
  Cycle := LgDelta shr 1;
  While X1 <> X2 do
  Begin
   Mem[GSeg:Y1*320+X1] := Color;
   Inc(X1, LgStep);
   Inc(Cycle, ShDelta);
   If Cycle > LgDelta then
   Begin
    Inc(Y1, ShStep);
    Dec(Cycle, LgDelta);
   End;
  End;
 End else
 Begin
  Cycle := ShDelta shr 1;
  Swap(LgDelta, ShDelta);
  Swap(LgStep, ShStep);
  While Y1 <> Y2 do
  Begin
   Mem[GSeg:Y1*320+X1] := Color;
   Inc(Y1, LgStep);
   Inc(Cycle, ShDelta);
   If Cycle > LgDelta then
   Begin
    Inc(X1, ShStep);
    Dec(Cycle, LgDelta);
   End;
  End;
 End;
End;

Procedure Mode80x50; Assembler;
Asm
 mov   dx,3c4h
 mov   ax,604h   { Enter unchained mode }
 out   dx,ax
 mov   ax,0F02h  { All planes }
 out   dx,ax
 mov   dx,3D4h
 mov   ax,14h    { Disable dword mode}
 out   dx,ax
 mov   ax,0E317h { Enable byte mode.}
 out   dx,ax
 mov   al,9
 out   dx,al
 inc   dx
 in    al,dx
 and   al,0E0h   { Duplicate each scan 8 times.}
 add   al,7      { <- 7 }
 out   dx,al
 mov   ax,0A000h
 mov   es,ax
 xor   di,di
 xor   ax,ax
 mov   cx,64000/2
 rep   stosw
End;

Procedure InitYOfs;
Var w : Word;
Begin
 For w:=0 to 199 do YOfs[w]:=(w*320);
End;

End.