{$M 30720,0,655360}
{$G+}
(* REFLECTOR (C) '95 By Paradise  *)

Unit Reflect;

Interface

 Procedure Reflect_Init;
 Procedure Reflect_Setup(NSteps : LongInt);
 Procedure Reflect_Run;
 Procedure Reflect_Done;

Implementation

Uses Crt, Dos, Vga, Palette, RefGFX;

Const
 RedPalette   = 1;
 FirePalette  = 0;
 WhitePalette = 2;

Var
 i, c      : Integer;
 Spr       : Array [0..127,0..127] of Byte;
 Pic       : Pointer;
 PicSeg    : Word;
 Lissa     : Array [0..700] of Record X,Y : Integer; End;
 LissaPos  : Word;
 PPalNrm   : Array [0..767] of Byte;
 WPal,
 FPal,PPal : PaletteType;
 Steps,
 Step      : LongInt;

Procedure FirePaletteData; Assembler;
(* Obliczone 256-kolorow palety RGB dla efektu ognia. *)
Asm
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,3,0,0,5,0,0,7,1,0,9,1,0,11,1,0,14,2,0,16,2,0,18,2,0,20,3,0,22,3,1,24,4,1,26
 db 4,1,28,5,1,30,5,1,33,5,1,35,6,1,37,7,1,39,8,1,41,8,1,42,9,1,44,11,1,46,11,1,48,13,2,50,14,2
 db 52,15,2,53,16,2,55,17,2,57,18,3,59,20,3,61,21,3,63,23,4,63,25,5,63,27,6,63,29,7,63,31,8,63,34,9,63,35
 db 9,63,36,10,63,38,11,63,39,11,63,40,12,63,42,13,63,43,13,63,44,14,63,45,15,63,46,15,63,47,16,63,49,17,63,50,18,63
 db 50,18,63,52,19,63,53,20,63,53,22,63,54,24,63,54,27,63,55,29,63,55,32,63,56,34,63,56,36,63,57,39,63,58,41,63,58,43
 db 63,59,46,63,59,48,63,60,51,63,60,53,63,61,55,63,61,58,63,62,60,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
End;

Procedure Reflektor(X,Y : Integer; GSeg : Word); Assembler;
Asm
 push ds
 push bp
 mov ax, GSeg
 mov es, ax
 mov ax, PicSeg
 mov ds, ax
 mov ax, Y
 mov bx, ax
 shl ax, 6
 shl bx, 8
 mov di, ax
 add di, bx
 add di, X
 mov si, offset Spr
 mov ax, seg Spr
 db $8e, $e0        { mov fs, ax }
 mov cx, 128
@yloop:
 push cx
 mov cx, 128
@xloop:
 db $64, $8a, $04   { mov al, fs:[si] }
 mov ah, al
 cmp ah, 0
 jz @nodraw
 mov al, ds:[di]
 db $0f, $b6, $d4   { movzx dx, ah }
 db $0f, $b6, $d8   { movzx bx, al }
 sub bx, dx
 jng @nodraw
 sub al, ah
 mov es:[di], al
@nodraw:
 inc si
 inc di
 dec cx
 jnz @xloop
 add di, 192
 pop cx
 dec cx
 jnz @yloop
 pop bp
 pop ds
End;

Procedure LoadSpr;
Begin
 UnPackBall(Spr);
End;

Procedure LoadLissa;
Begin
 UnPackLissa(Lissa);
End;

Procedure Blur(GSeg : Word); Assembler;
Asm
 cld
 mov ax, GSeg
 mov es, ax
 mov di, 10*320
@blurpixel:
 xor ah, ah
 mov al, es:[di-320]
 mov bx, ax
 mov al, es:[di+320]
 add bx, ax
 mov al, es:[di-1]
 add bx, ax
 mov al, es:[di+1]
 add bx, ax
 shr bx, 2
 mov es:[di], bl
 inc di
 cmp di, 190*320
 jnz @blurpixel
End;

Procedure SetColors(Typ : Byte);
Begin
 Case Typ of
  FirePalette : Begin
                 Move(Mem[Seg(FirePaletteData):Ofs(FirePaletteData)],FPal,768);
                 For i:=0 to 255 do
                 Begin
                  PPal[i,0]:=FPal[i div 2,0];
                  PPal[i,1]:=FPal[i div 2,1];
                  PPal[i,2]:=FPal[i div 2,2];
                 End;
                End;
 WhitePalette : Begin
                 Move(PPalNrm,PPal,768);
                End;
   RedPalette : Begin
                 Move(PPalNrm,PPal,768);
                 For i:=0 to 255 do
                 Begin PPal[i,1]:=0; PPal[i,2]:=0; End;
                End;
 End;
 SetFadingIn(PPal,3);
End;

Procedure ShowScreen(SS: Word);
Procedure DrawBoxes(Stp : Byte);
Procedure OneBox(pX,pY : Integer; Filled : Byte);
Var X, Y : Integer; Off : Word; Color : Byte; Begin Off:=pY*320+pX;
For Y:=0 to 9 do Begin For X:=0 to 9 do  Begin
Color:=Mem[SS:Off]; If X<Filled then Inc(Color,128);
Mem[VSeg:Off]:=Color; Inc(Off);
End; Inc(Off,310); End; End;
Function Rng(i : Integer): Byte; Begin If i<0 then Rng:=0 else Rng:=i; End;
Var tX, tY : Integer;
Begin For tY:=0 to 19 do For tX:=0 to 31 do
OneBox(tX*10,tY*10,Rng(Stp - tX shr 1)); End;
Var i : Integer; Begin For i:=0 to 27 do Begin
DrawBoxes(i); ShowFake(VSeg); End; End;

Procedure EndPart;
Var W : Word;
Begin
 While KeyPressed do ReadKey;
 UnpackItpLogo(Pic^);
 Move(@ItpLogoPalette^,StdPal,768);
 Move(StdPal,PPal,768);
 FillChar(WPal,768,63);
 SetPalette(@WPal);
 ShowFake(PicSeg);
 SetFadingBetween(WPal,PPal,2);
 While DoFade do VRet;
 CopyFake($A000,VSeg);
 ShowScreen(PicSeg);
 SetFadingOut(PPal,2);
 While DoFade do VRet;
End;

Procedure Reflect_Init;
Begin
 InitVPage;
 LoadLissa;
 LoadSpr;
 GetMem(Pic,64000); PicSeg:=Seg(Pic^);
 UnpackPentagram(Pic^);
 Move(@PentagramPalette^,PPalNrm,768);
 SetColors(WhitePalette);
 Blur(PicSeg); Blur(PicSeg);
 LissaPos:=20;
 Steps:=200;
 Step:=0;
End;

Procedure Reflect_Setup(NSteps : LongInt);
Begin
 Steps:=NSteps;
End;

Procedure Reflect_Done;
Begin
 FreeMem(Pic,64000);
 DoneVPage;
End;

Procedure Reflect_Run;
Begin
 While Step<Steps do
 Begin
  DoFade;
  ClearFake(VSeg);
  Inc(LissaPos); If (LissaPos>700) then LissaPos:=0;
  Reflektor(Lissa[LissaPos].X,Lissa[LissaPos].Y,VSeg);
  ShowFake(VSeg);
  VRet;
  Inc(Step);
 End;
 EndPart;
End;

End.