(* 
  This piece of sourcecode is meant for "educational" purposes, in other
  words, don't rip the entire source to make a full LawGator clone.

  Pieces of this code may be used, but give credit where credit is due.

  There are some comments in the source, but without knowledge of pascal
  and a lot of knowledge of RA you won't get really far...

  Grtx, MadCat
*)
Uses Radu,RaStruct,MiscRadu;
Const
  MaxAreas = 1400;                                           { Maximum areas }
Type
  ListerRecord = record
                   Name : string[40];                            { Area Name }
                   Nr   : word;                                { Area Number }
                 End;
  ListerType = array[1..MaxAreas] of ListerRecord;
  GConfigRecord = record
                    PageLen : byte;             { How much names on one page }
                    LineLen : byte;                 { How long can a name be }
                    Text    : array[1..2] of byte;           { Color of text }
                    Bar     : array[1..2] of byte;       { Color of Menu bar }
                    WPos    : array[1..2] of byte;         { Starting at X,Y }
                    Free    : array[1..28] of byte;             { Free space }
                  End;
Var
  List          : ^ListerType;
  Mailing       : Boolean;                         { Doing mail groups/areas }
  Filing        : Boolean;                         { Doing file groups/areas }
  AreaOnly      : Boolean;                          { Only select from areas }
  Centering     : Boolean;                                     { Center text }
  Config        : GConfigrecord;
  TempResult    : word;
  TempSelection : word;
  Dummy         : byte;
  CurGroup      : word;

Label SelectFileGroup,SelectMailGroup;

Procedure Color(fg,bg: byte); { Used to set fg and bg color with one command }
Begin
  TextColor(fg);
  TextBackGround(bg);
End;

{ This function strips a parameter from the leading character (these are:
  "/" or "-") if found }
Function StripParam(S: string): string;
Begin
  If (s[1]='-') or (s[1]='/') then Delete(s,1,1);
  StripParam :=s;
End;

Procedure ParseParams;                                { The parameter parser }
Var
  Tel : byte;
Begin
  Filing :=TRUE;                           { If no param found, assume files }
  Mailing :=FALSE;                                       { See prev. comment }
  AreaOnly :=FALSE;                   { If no param found, assume areas only }
  Centering :=FALSE;                                  { No centering of text }
  If ParamCount=0 then Exit;  { No params found so no need for further crap }
  For Tel :=1 to ParamCount do
  Begin
    If SUpCase(StripParam(ParamStr(tel)))='CENTER' then Centering :=TRUE;
    If SUpCase(StripParam(ParamStr(tel)))='MAIL' then
    Begin
      Mailing :=TRUE;
      Filing :=FALSE;
    End;
    If SUpCase(StripParam(ParamStr(tel)))='FILE' then
    Begin
      Filing :=TRUE;
      Mailing :=FALSE;
    End;
    If SUpCase(StripParam(ParamStr(tel)))='AREA' then AreaOnly :=TRUE;
  End;
End;

Function AllocateMem: Boolean;                         { Initialize the list }
Begin
  AllocateMem :=FALSE;
  If MaxAvail<SizeOf(List^) then Exit;                   { Not enough memory }
  New(List);
  FillChar(List^,SizeOf(List^),0);                              { Empty list }
  AllocateMem :=TRUE;
End;

{ The following function reads the group file "FGROUPS.RA" or "MGROUPS.RA"
  since their structure is the same.

  If the parameter "Files" is true, read "FGROUPS.RA".

  Returns "FALSE" if files couldn't be read or error occured
}
Function ReadGroups(Files: Boolean): Boolean;
Var
  Temp      : GroupRecord;
  GroupFile : File Of GroupRecord;
  Tel       : word;                                      { The record number }
  Ins       : word;                                       { The list counter }
Begin
  ReadGroups :=FALSE;
  If Files then Assign(GroupFile,ForceBack(RaSystem)+'FGROUPS.RA')
  else Assign(GroupFile,ForceBack(RaSystem)+'MGROUPS.RA');
  {$i-}
  Reset(GroupFile);
  {$i+}
  If IOResult<>0 then Exit;
  ReadGroups :=TRUE;
  Tel :=0;
  Ins :=1;
  While (not Eof(GroupFile)) and (Tel<>1399) do
  Begin
    Seek(GroupFile,Tel);                               { For added precision }
    Read(GroupFile,Temp);
    If Temp.Name<>'' then                                { Group isn't empty }
    Begin
      if Temp.Security<=ExitInfo.UserInfo.Security then    { User can select }
      Begin
        List^[ins].Name :=Copy(Temp.Name,1,Config.LineLen);
        List^[ins].Nr :=tel+1;                     { The actual group number }
        Inc(Ins);                         { Point to next free entry in list }
      End;
    End;
    Inc(tel);                                             { Read next record }
  End;
  Close(GroupFile);
End;

Function ReadFileAreas: Boolean;                   { Same idea as ReadGroups }
Var
  Tel     : word;
  Ins     : word;
  Temp    : FilesRecord;
  FileFile: File of FilesRecord;
Begin
  ReadFileAreas :=FALSE;
  Assign(FileFile,ForceBack(RaSystem)+'FILES.RA');
  {$i-}
  Reset(FileFile);
  {$i+}
  If IOResult<>0 then Exit;
  ReadFileAreas :=TRUE;
  Tel :=0;
  Ins :=1;
  While (not Eof(FileFile)) and (tel<>1399) do
  Begin
    Seek(FileFile,Tel);
    Read(FileFile,Temp);
    If Temp.Name<>'' then
    Begin
      If (Temp.Group=CurGroup) or (Temp.AltGroup[1]=CurGroup) or (temp.AltGroup[2]=CurGroup) or (Temp.AltGroup[3]=CurGroup)
      or (Temp.Attrib2=1) then if (temp.Security<=ExitInfo.userInfo.Security) then
      { The above 2 lines check if the area is in the current group and if
        the user has axx to that area }
      Begin
        List^[Ins].Name :=Copy(Temp.Name,1,Config.LineLen);
        List^[Ins].Nr :=tel+1;
        Inc(Ins);
      End;
    End;
    Inc(Tel);
  End;
  Close(FileFile);
End;

Function ReadMailAreas: Boolean;                   { Same idea as ReadGroups }
Var
  Tel     : word;
  Ins     : word;
  Temp    : MessageRecord;
  MailFile: File of MessageRecord;
Begin
  ReadMailAreas :=FALSE;
  Assign(MailFile,ForceBack(RaSystem)+'MESSAGES.RA');
  {$i-}
  Reset(MailFile);
  {$i+}
  If IOResult<>0 then Exit;
  ReadMailAreas :=TRUE;
  Tel :=0;
  Ins :=1;
  While (Not Eof(MailFile)) and (tel<>1399) do
  Begin
    Seek(MailFile,tel);
    Read(MailFile,Temp);
    If Temp.Name<>'' then
    Begin
      If (Temp.Group=CurGroup) or (Temp.AltGroup[1]=CurGroup) or (temp.AltGroup[2]=CurGroup) or (Temp.AltGroup[3]=CurGroup)
      or (Temp.Attribute2=1) then If (temp.WriteSecurity<=ExitInfo.UserInfo.Security)
      { The above 2 lines check if the area is in the current group and
        if the user has axx to that area }
      and (Temp.ReadSecurity<=ExitInfo.UserInfo.Security) then
      Begin
        List^[Ins].Name :=Copy(Temp.Name,1,Config.LineLen);
        List^[ins].Nr :=tel+1;
        Inc(Ins);
      End;
    End;
    Inc(Tel);
  End;
  Close(MailFile);
End;

Procedure ClearList;                        { This procedure clears the list }
Begin
  FillChar(List^,SizeOf(List^),0);
End;

Function GetMaxPage: Word;             { Get the amount of pages in the list }
Var
  Tel : word;
  Ctr : byte;
  Page: word;
Begin
  Page :=1;
  Ctr :=0;
  For Tel :=1 to 1400 do
  Begin
    If List^[tel].Name<>'' then Inc(Ctr);    { Entry isn't empty so increase }
    if Ctr-1=Config.PageLen then                           { Okay, next page }
    Begin
      Ctr :=0;
      Inc(Page);
    End;
  End;
  GetMaxPage :=Page;
End;

Function Expand(s: string;len: byte): string;    { Expands a string to "len" }
Begin
  While length(s)<len do s:=s+' ';
  Expand :=s;
End;

Procedure CenterWriteLn(X1,X2,Y: byte;s: string); { Guess =] }
Var
  len : byte;
  a   : byte;
  tel : byte;
Begin
  len :=x2-x1;
  if length(s)>len then delete(s,len,length(s)-len+1);       { write between }
  a :=(len div 2)-(length(s) div 2);                       { start text here }
  GotoXy(x1,y);
  for tel :=1 to a do write(' ');
  Write(s);
  while wherex<>x2 do write(' ');
End;

{ The following procedure displays a complete page. The variable "PageLimit"
  returns the number of entrys displayed on the page }
Procedure DisplayPage(Page: byte;Var PageLimit: byte);
Var
  Tel : word;
Begin
  Color(Config.Text[1],Config.Text[2]);
  PageLimit :=0;
  For Tel :=1 to Config.PageLen do
  Begin
    With Config do GotoXy(WPos[1],WPos[2]+tel-1);
    If List^[(Page*Config.PageLen)-Config.PageLen+Tel].Name<>'' then
    Begin
      If Not Centering then WriteLn(Expand(List^[(Page*Config.PageLen)-Config.PageLen+Tel].Name,Config.LineLen))
      else With Config do
      CenterWriteLn(WPos[1],WPos[1]+LineLen,WPos[2]+Tel-1,List^[(Page*Config.PageLen)-Config.PageLen+Tel].Name);
      Inc(PageLimit);
    End else WriteLn(Expand(' ',Config.LineLen));
  End;
End;

Procedure ClearPageArea(StartX,StartY: byte);    { Clears the area of a page }
Var
  Tel : word;
  Tel2: word;
Begin
  For Tel :=1 to Config.PageLen do
  Begin
    GotoXy(StartX,StartY+Tel-1);
    Color(7,0);
    For Tel2 :=1 to Config.LineLen do Write(' ');
  End;
End;

Function Lister_Selector(Var Result: byte): word;      { The actual selector }
Var
  MPos     : byte;                                         { Bar current pos }
  Opos     : byte;                                           { Bar prev. pos }
  Page     : word;                                            { Current page }
  MaxPage  : word;                                              { Max. Pages }
  PageLimit: byte;                                           { Lines on page }
  Tel      : byte;                                 { <---\                   }
  Ch       : Char;                                 { <-----\                 }
  A        : byte;                                 { <------> Temporary stuff}
  T        : string;                               { <-----/                 }
Begin
  With Config do ClearPageArea(WPos[1],WPos[2]);
  MaxPage :=GetMaxPage;
  MPos :=1;
  OPos :=1;
  Page :=1;
  DisplayPage(Page,PageLimit);
  With Config do GotoXy(WPos[1],WPos[2]+PageLen+1);
  Write('`a8:[`a7:Page `a15:'+FStr(Page)+'`a7: of `a15:'+FStr(MaxPage)+'`a8:] [`a15:H`a8:]`a7:elp');
  While True Do
  Begin
    Delay(10);
    if OPos<>MPos then
    Begin
      Color(Config.Text[1],Config.Text[2]);
      With Config do GotoXy(WPos[1],WPos[2]+OPos-1);
      If Not Centering then WriteLn(Expand(List^[(Page*Config.PageLen)-Config.PageLen+OPos].Name,Config.LineLen))
      else With Config do
      CenterWriteLn(WPos[1],WPos[1]+LineLen,WPos[2]+OPos-1,List^[(Page*Config.PageLen)-Config.PageLen+OPos].Name);
    End;
    Color(Config.Bar[1],Config.Bar[2]);
    With Config do GotoXy(WPos[1],WPos[2]+MPos-1);
    If Not Centering then WriteLn(Expand(List^[(Page*Config.PageLen)-Config.PageLen+MPos].Name,Config.LineLen))
    else With Config do
    CenterWriteLn(WPos[1],WPos[1]+LineLen,WPos[2]+MPos-1,List^[(Page*Config.PageLen)-Config.PageLen+MPos].Name);
    With Config do GotoXy(WPos[1]+LineLen-1,WPos[2]+MPos-1);
    OPos :=MPos;
    Delay(15);
    Case UpCase(ReadKey) of
      'H': Begin
             Color(7,0);
             ClrScr;
             Write('`a1:`d196,80:');
             WriteLn('`c:`a11:HELP');
             Write('`a1:`d196,80:');
             WriteLn;
             WriteLn('`c:`a7:[`a15:`a7:]   `a11:- `a3:Move bar one position down ');
             WriteLn('`c:`a7:[`a15:`a7:]   `a11:- `a3:Move bar one position up   ');
             WriteLn('`c:`a7:[`a15:`a7:]   `a11:- `a3:Next Page (if any)         ');
             WriteLn('`c:`a7:[`a15:`a7:]   `a11:- `a3:Previous Page (if any)     ');
             WriteLn('`c:`a7:[`a15:ESC`a7:] `a11:- `a3:Back to BBS or one level up');
             WriteLn('`c:`a7:[`a15:`a7:] `a11:- `a3:Select Group/Area          ');
             WriteLn;
             WriteLn('`c:`a7:This program is `a15:probably`a7: the first and certainly');
             WriteLn('`c:`a7:not the last that uses lightbars to select areas.');
             WriteLn('`c:`a7:The idea (`a15:again`a7:) was taken from PCBoard, where');
             WriteLn('`c:`a7:these utils are allready available.');
             WriteLn;
             Write('`a1:`d196,80:');
             Write('`c:`a7:Press [`a15:ANY`a7:] key to continue:');
             If ReadKey=#0 then ReadKey;
             Color(7,0);
             ClrScr;
             If DorDisplay(ForceBack(DorPath)+'LAWGATOR.ANS','',FALSE)=#1 then RaLog('GATOR: No background found....');
             DisplayPage(Page,PageLimit);
             With Config do GotoXy(WPos[1],WPos[2]+PageLen+1);
             Write('`a8:[`a7:Page `a15:'+FStr(Page)+'`a7: of `a15:'+FStr(MaxPage)+'`a8:] [`a15:H`a8:]`a7:elp');
           End;
      #0 : Case ReadKey of
            #72: If MPos>1 then Dec(Mpos) else MPos :=PageLimit;
            #80: if MPos<PageLimit then Inc(Mpos) else MPos :=1;
            #75: If Page>1 then
                 Begin
                   Dec(Page);
                   {With Config do ClearPageArea(WPos[1],WPos[2]);}
                   DisplayPage(Page,PageLimit);
                   With Config do GotoXy(WPos[1],WPos[2]+PageLen+1);
                   Write('`a8:[`a7:Page `a15:'+FStr(Page)+'`a7: of `a15:'+FStr(MaxPage)+'`a8:] [`a15:H`a8:]`a7:elp');
                   MPos :=PageLimit;
                   OPos :=PageLimit;
                 End;
            #77: If Page<MaxPage then
                 Begin
                   Inc(Page);
                   {With Config do ClearPageArea(WPos[1],WPos[2]);}
                   DisplayPage(Page,PageLimit);
                   With Config do GotoXy(WPos[1],WPos[2]+PageLen+1);
                   Write('`a8:[`a7:Page `a15:'+FStr(Page)+'`a7: of `a15:'+FStr(MaxPage)+'`a8:] [`a15:H`a8:]`a7:elp');
                   MPos :=1;
                   OPos :=1;
                 End;
           End;
     #27:  Begin
             Lister_Selector :=0;
             Result :=1;
             Exit;
           End;
     #13:  Begin
             Result :=0;
             Lister_Selector :=List^[(Page*Config.PageLen)-Config.PageLen+MPos].Nr;
             Exit;
           End;
    End;
  End;
End;

Function ReadConfig: Boolean;                            { Reads config file }
Var
  ConfigFile : File of GConfigRecord;
Begin
  Assign(ConfigFile,ForceBack(DorPath)+'LAWGATOR.CFG');
  {$i-}
  Reset(ConfigFile);
  Read(ConfigFile,Config);
  Close(ConfigFile);
  {$i+}
  ReadConfig :=(IOResult=0);
End;

Begin
  NoRalFoundErrorDisplay :=TRUE;
  DorInit;
  DorStatus(10);
  LockStatus :=TRUE;
  DorExtKeys[ExtKey_CtrlPgUp]:=DorExtKeys[ExtKey_Up];
  DorExtKeys[ExtKey_CtrlPgDn]:=DorExtKeys[ExtKey_Down];
  DorExtKeys[ExtKey_Up]:=DorNullProc;
  DorExtKeys[ExtKey_Down]:=DorNullProc;
  ParseParams;
  If Not ReadConfig then
  Begin
    Write('`a15: `a7:Could not read config file, returning to `a14:',RaConfig.SystemName);
    Delay(1000);
    Halt;
  End;
  If Not AllocateMem then
  Begin
    Write('`a15: `a7:Not enough memory, returning to `a14:',RaConfig.SystemName);
    Delay(1000);
    Halt;
  End;
  Color(7,0);
  ClrScr;
  If DorDisplay(ForceBack(DorPath)+'LAWGATOR.ANS','',FALSE)=#1 then RaLog('GATOR: No background found....');
  If Mailing then CurGroup :=ExitInfo.UserInfo.MsgGroup
  else CurGroup :=ExitInfo.UserInfo.FileGroup;
  If Filing then
  Begin
    If Not AreaOnly then
    Begin
    SelectFileGroup:
      ClearList;
      If not ReadGroups(True) then
      Begin
        Write('`a15: `a7:Could not read groups file, returning to `a14:',Raconfig.SystemName);
        Delay(1000);
        Dispose(List);
        Halt;
      End;
      TempResult :=Lister_Selector(Dummy);
      If Dummy=1 then
      Begin
        Dispose(List);
        Halt;
      End;
      If Dummy=0 then ExitInfo.UserInfo.FileGroup :=TempResult;
      CurGroup :=TempResult;
      ClearList;
    End;
    If not ReadFileAreas then
    Begin
      Write('`a15: `a7:Could not read area file, returning to `a14:',RaConfig.SystemName);
      Delay(1000);
      Dispose(List);
      Halt;
    End;
    TempResult :=Lister_Selector(Dummy);
    If Dummy=1 then If AreaOnly then
    Begin
      Dispose(List);
      Halt
    End else Goto SelectFileGroup;
    If Dummy=0 then ExitInfo.UserInfo.FileArea :=TempResult;
  End;
  If Mailing then
  Begin
    If Not AreaOnly then
    Begin
    SelectMailGroup:
      ClearList;
      If not ReadGroups(False) then
      Begin
        Write('`a15: `a7:Could not read groups file, returning to `a14:',Raconfig.SystemName);
        Delay(1000);
        Dispose(List);
        Halt;
      End;
      TempResult :=Lister_Selector(Dummy);
      if Dummy=1 then
      Begin
        Dispose(List);
        Halt;
      End;
      If Dummy=0 then ExitInfo.UserInfo.MsgGroup :=TempResult;
      CurGroup :=TempResult;
      ClearList;
    End;
    If not ReadMailAreas then
    Begin
      Write('`a15: `a7:Could not read area file, returning to `a14:',RaConfig.SystemName);
      Delay(1000);
      Dispose(List);
      Halt;
    End;
    TempResult :=Lister_Selector(Dummy);
    If Dummy=1 then If AreaOnly then
    Begin
      Dispose(List);
      Halt
    End else Goto SelectMailGroup;
    If Dummy=0 then ExitInfo.UserInfo.MsgArea :=TempResult;
  End;
  ClrScr;
  Dispose(List);
End.




