;-------------------------------------------------
;Horizontal starfield, written by MAD from ITPG. -
;-------------------------------------------------
dosseg
.model small
.386
.stack 100h
.data

number_of_levels equ 6
number_of_stars  equ 800

label silevel word                     ;table to lookup start-of-SI
firstoffset      dw 0                  ;when level=0 SI MUST start at 0
number0          dw 200                ;number of stars at level0
number1          dw 450                 
number2          dw 650                 
number3          dw 725                
number4          dw 775                
number5          dw 800            

screen_height    equ 200
screen_width     equ 320

star   struc                           ;structure of the stars
   ypos   dw 0
   xpos   dd 0
   oldpos dw 0
star   ends

screen_segment   dw 0a000h             
current_level    dw 0

;include  "sintable.inc"               ;not yet...
include stars.inc                      ;random file with stars

speed0   dd   10000h                   ;level0 (far) goes slow 
speed1   dd   18000h
speed2   dd   20000h
speed3   dd   28000h
speed4   dd   30000h
speed5   dd   38000h                   

;colour_table db   0, 255, 255         ;colours used for testing
;             db   255, 255, 0         ;(unused now) 
;             db   255, 0, 255          
;             db   0, 0, 255            
;             db   0, 255, 0            
;             db   255, 0, 0            

colour_table  db    10,  10,  10       ;tha real colourz
              db    20,  20,  20
              db    30,  30,  30
              db    40,  40,  40              
              db    50,  50,  50
              db    63,  63,  63

clear_colour  db 0                     ;colour to clear stars. should be 0

label y_offset word                    ;table to lookup offset
  i=0
  rept screen_height 
    dw i * screen_width
    i=i+1
  endm

.code
main   proc
   mov   ax,dgroup                     ;init segments
   mov   ds,ax
   mov   es,ax

   mov   ax,13h                        ;switch to 320x200x256
   int   10h

   mov   ax,1012h                      ;init. palete
   mov   bx,01                         ;start colour reg. 1
   mov   cx,number_of_levels           ;number of colours
   mov   dx,offset colour_table        ;tha colourz in ES:DX
   int   10h

mainloop:
   mov     dx,3dah                     ;wait for vertical retrace
vrt:
   in      al,dx                       ;wait for start
   test    al,8
   jnz     vrt         
novrt:
   in      al,dx                       ;wait for end
   test    al,8
   jz      novrt       
   
   xor   si,si
   call  starprint                     ;print 'em

   mov   [current_level],0
   mov   ah,0bh                        ;check if key
   int   21h
   cmp   al,0                          ;no?
   je    mainloop                      ;start again

   mov   ah,07                         ;yes? read it
   int   21h
   cmp   al," "                        ;check if space
   jne   stop                          ;no? end program
   neg   [speed0]                      ;invert speeds
   neg   [speed1]
   neg   [speed2]
   neg   [speed3]
   neg   [speed4]
   neg   [speed5]
   jmp   mainloop

stop:   
   mov   ax,03h                        ;yes? go back to 80x25
   int   10h

   mov   ax,4c00h                      ;and exit with 0 (no error)
   int   21h
main   endp

starprint   proc
   mov   es,screen_segment   
   
   mov   bx,[current_level]            ;number of current level 
   mov   ax,bx                         ;get colour for that level
   inc   ax                            ;first colour is in reg. 1
   add   bx,bx                         ;make word offset
   push  bx                            ;keep offset
   add   bx,bx                         ;make double word offset
   mov   edx,[speed0+bx]               ;get speed
   pop   bx                            ;restore word offset
   
   mov   di,[stars.oldpos + si]        ;get old position
   mov   cl,clear_colour
   mov   byte ptr es:[di],cl           ;and erase pixel
   
   mov   edi,[stars.xpos + si]
   rol   edi,16                        ;make type like xxxx,----h
   add   edi,edx                       ;add speed
   ror   edi,16                        ;make high-word low-word
   cmp   di,screen_width               ;check if in bounds
   jl    in_bounds1                    ;yes? proceed
   sub   di,screen_width               ;no? set back to start of screen
in_bounds1:
   cmp   di,0
   jnl   in_bounds2
   add   di,screen_width
in_bounds2:
   mov   [stars.xpos + si],edi         ;store x-pos

   push  bx
   mov   bx,[stars.ypos + si]          ;get y-pos
   add   bx,bx                         ;make word offset
   add   di,[y_offset + bx]            ;add y-offset to x-offset
   pop   bx

   mov   [stars.oldpos + si],di        ;store position
   mov   byte ptr es:[di],al           ;set pixel on screen

   mov   di,offset number0
   add   di,bx                         ;level offset
   mov   ax,[di]                       ;get number of stars for this level
   mov   bx,size star
   mul   bx                            ;multiply AX with BX
   sub   ax,size star                  ;1 star less (SI starts at 0)
   cmp   si,ax
   jnge  not_yet                       ;no comment...

   cmp   [current_level],number_of_levels - 1  ;last level?
   je    einde                         ;yes? screen finished
   
   inc   [current_level]               ;no? proceed with next level
   add   si,size star                  ;AND NEXT STAR!!!!
   jmp   starprint                     ;engage!

not_yet:                              
   add   si,size star                  ;proceed with next star
   jmp   starprint                     ;make it so number one...

einde:   
   ret
starprint   endp

end main
