;-----------------------------------------------------------------------------
;This is just a small demo to test my vector routines. I think it can be 
;optimized for speed. If you use this code in any of your productions, please
;credit me. May the Force be with you !!!
;
;<=MAD from ITPG=>  E-mail: smit@dds.nl Homepage: http://huizen.dds.nl/~smit/
;-----------------------------------------------------------------------------
dosseg
jumps
.model small
.386
.stack 32
.data
data_start   equ $
number_of_points   equ   92 * 4
distance           equ   256
video_segment      dw  0a000h

vector   struc
   x   dw 0
   y   dw 0
   z   dw 0
vector   ends

points   label  word                   
zp=-15
rept 4
vector <-85,25,zp>,<-75,25,zp>,<-45,25,zp>,<-35,25,zp>,<-5,25,zp>
vector <5,25,zp>,<15,25,zp>,<45,25,zp>,<55,25,zp>,<65,25,zp>
vector <75,25,zp>
vector <-70,20,zp>,<-50,20,zp>,<-10,20,zp>,<20,20,zp>,<80,20,zp>
vector <-85,15,zp>,<-75,15,zp>,<-65,15,zp>,<-55,15,zp>,<-45,15,zp>,<-35,15,zp>
vector <-15,15,zp>,<0,15,zp>,<5,15,zp>,<10,15,zp>
vector <25,15,zp>,<45,15,zp>,<55,15,zp>,<65,15,zp>,<85,15,zp>
vector <-70,10,zp>,<-60,10,zp>,<-50,10,zp>,<-5,10,zp>,<15,10,zp>,<70,10,zp>
vector <-85,5,zp>,<-75,5,zp>,<-65,5,zp>,<-55,5,zp>,<-45,5,zp>,<-35,5,zp>
vector <-15,5,zp>,<0,5,zp>,<5,5,zp>,<10,5,zp>,<25,5,zp>
vector <45,5,zp>,<55,5,zp>,<75,5,zp>,<85,5,zp>
vector <-60,0,zp>
vector <-85,-5,zp>,<-75,-5,zp>,<-45,-5,zp>,<-35,-5,zp>,<-15,-5,zp>,<-5,-5,zp>
vector <5,-5,zp>,<15,-5,zp>,<25,-5,zp>,<45,-5,zp>,<55,-5,zp>,<75,-5,zp>
vector <85,-5,zp>
vector <70,-10,zp>
vector <-85,-15,zp>,<-75,-15,zp>,<-45,-15,zp>,<-35,-15,zp>,<-15,-15,zp>
vector <-5,-15,zp>,<15,-15,zp>,<25,-15,zp>,<45,-15,zp>,<55,-15,zp>,<65,-15,zp>
vector <85,-15,zp>
vector <80,-20,zp>
vector <-85,-25,zp>,<-75,-25,zp>,<-45,-25,zp>,<-35,-25,zp>,<-15,-25,zp>
vector <-5,-25,zp>,<15,-25,zp>,<25,-25,zp>,<45,-25,zp>,<55,-25,zp>
vector <65,-25,zp>,<75,-25,zp>
zp=zp+10
endm

pallet   label   byte
  c=63
  db 0,0,0
    rept 63
    db   0,0,c, 0,0,c, 0,0,c, 0,0,c
    c=c-1
    endm
    db   0,0,0, 0,0,0, 0,0,0

cosx   dw 0
cosy   dw 0
cosz   dw 0

sinx   dw 0
siny   dw 0
sinz   dw 0

xangle dw 128
yangle dw 0
zangle dw 0

xd     dw 0
yd     dw 0
zd     dw 0
speed  dw 1
x_offset   dw 160
y_offset   dw 100

oldpoints   dw number_of_points dup (0)
counter   dw 0
include   sintable.inc

file_name   db "sound.inc",0
handle      dw 0
f_size      dw 0

music_call      DW 0
music_seg       DW 0
mod_name        DB "thalamus.mod",0
sample_name     db "sample1.sam",0

message         db "This demo is written in 100% hardcore ASSEMBLY !!!",0dh,0ah
db "Sound-system by Frontman of Crew242, demo by MAD from ITPG.",0dh,0ah
db "Press any key to launch.",0dh,0ah,"$"

random_seed     dw 1234h

data_end   equ $
.code
main   proc
  
  mov   ah,4ah
  mov   dx,(offset data_end - data_start)/16
  inc   dx
  mov   bx,(offset einde - offset main + 30fh)/16
  add   bx,dx
  int   21h                            ;give back unused memory

  mov   ax,dgroup
  mov   ds,ax
  mov   es,ax
  
  mov   ah,09
  lea   dx,message
  int   21h
  mov   ah,07
  int   21h

  call  init_sound_player             
  call  start_player
  
  mov   ax,dgroup
  mov   ds,ax
  mov   es,ax
  mov   ax,13h                         ;switch to 320x200x256
  int   10h

  mov   ax,1012h                       ;load pallet
  xor   bx,bx
  mov   cx,256
  lea   dx,pallet
  int   10h
  
  mov   es,[video_segment]

  mov   cx,16000                       ;clear screen
  xor   si,si
clear_loop:
  mov   dword ptr es:[si],0
  add   si,4
  loop  clear_loop
;---
start:  
  mov   ax,[speed]                     ;calculate the angles
  add   [xangle],ax
  and   [xangle],11111111b

  mov   ax,[speed]
  add   [yangle],ax
  and   [yangle],11111111b

  mov   ax,[speed]
  add   [zangle],ax
  and   [zangle],11111111b

  lea   si,sintable                    ;get sin and cos of xangle
  mov   ax,[xangle]
  add   si,ax
  movsx bx,[si]
  mov   [sinx],bx
  add   ax,64
  and   ax,11111111b
  lea   si,sintable
  add   si,ax
  movsx ax,[si]
  mov   [cosx],ax
  
  lea   si,sintable                    ;get sin and cos of yangle
  mov   ax,[yangle]
  add   si,ax
  movsx bx,[si]
  mov   [siny],bx
  add   ax,64
  and   ax,11111111b
  lea   si,sintable
  add   si,ax
  movsx ax,[si]
  mov   [cosy],ax
  
  lea   si,sintable                    ;get sin and cos of zangle
  mov   ax,[zangle]
  add   si,ax
  movsx bx,[si]
  mov   [sinz],bx
  add   ax,64
  and   ax,11111111b
  lea   si,sintable
  add   si,ax
  movsx ax,[si]
  mov   [cosz],ax
;-------------------------------------------------------------------------
  mov   dx,3dah                        ;wait for vertical retrace
vrt:
  in    al,dx                          ;wait for start
  test  al,8
  jnz   vrt         
novrt:
  in    al,dx                          ;wait for end
  test  al,8
  jz    novrt       
  
  lea   si,oldpoints
  mov   cx,number_of_points
del_loop:                              ;clear old points
  mov   di,[si]
  mov   byte ptr es:[di],0             
  inc   si
  inc   si
  loop  del_loop
  
  mov   [counter],0
  
  xor   si,si
  mov   cx,number_of_points
;--------------------------start writing screen-------------------------------  
calc_pos:  
  push  cx
  
  mov   ax,[points.y + si]             ;y=y*cos(xangle)-z*sin(xangle)
  imul  ax,[cosx]
  mov   bp,ax
  mov   ax,[points.z + si]
  imul  ax,[sinx]
  sub   bp,ax
  
  mov   ax,[points.y + si]             ;z=y*sin(xangle)+z*cos(xangle)
  imul  ax,[sinx]
  mov   di,ax
  mov   ax,[points.z + si]
  imul  ax,[cosx]
  add   di,ax

  sar   bp,7
  sar   di,7
  mov   [yd],bp
  mov   [zd],di

  mov   ax,[points.x + si]             ;x=x*cos(yangle)-z*sin(yangle)
  imul  ax,[cosy]
  mov   bp,ax
  mov   ax,[zd]
  imul  ax,[siny]
  sub   bp,ax
  
  mov   ax,[points.x + si]             ;z=x*sin(yangle)+z*cos(yangle)
  imul  ax,[siny]
  mov   di,ax
  mov   ax,[zd]
  imul  ax,[cosy]
  add   di,ax

  sar   bp,7
  sar   di,7
  mov   [xd],bp
  mov   [zd],di

  mov   ax,[xd]                        ;x=x*cos(zangle)-y*sin(zangle)
  imul  ax,[cosz]
  mov   bp,ax
  mov   ax,[yd]
  imul  ax,[sinz]
  sub   bp,ax
  
  mov   ax,[xd]                        ;y=x*sin(zangle)+y*cos(zangle)
  imul  ax,[sinz]
  mov   di,ax
  mov   ax,[yd]
  imul  ax,[cosz]
  add   di,ax

  sar   bp,7
  sar   di,7
  mov   [xd],bp
  mov   [yd],di         

print:
  mov   ax,distance                         ;y=(y*d)/(z+d); d=distance
  mov   bx,[yd]
  imul  bx
  mov   bx,[zd]
  add   bx,distance
  cmp   bx,0
  jne   nozero1
  inc   bx
nozero1:
  idiv  bx
  mov   bp,ax

  mov   ax,distance                         ;x=(d*x)/(d+z)
  mov   bx,[xd]
  imul  bx
  mov   bx,[zd]
  add   bx,distance
  cmp   bx,0
  jne   nozero2
  inc   bx
nozero2:  
  idiv  bx
  mov   di,ax

  add   bp,[y_offset]                    ;offset on screen
  add   di,[x_offset]
  xor   cx,cx
  cmp   di,319                         ;check if in bounds
  jg    skip_printing
  cmp   di,0
  jl    skip_printing
  cmp   bp,199
  jg    skip_printing
  cmp   bp,0
  jl    skip_printing

  imul  bp,320                         ;calc offset
  add   di,bp
  
  mov   ax,[zd]
  add   ax,128
  mov   byte ptr es:[di],al            ;colour from z-coordinate + 128
  mov   cx,di

skip_printing:  
  mov   bx,[counter]
  add   bx,bx
  mov   [oldpoints + bx],cx            ;store offset in oldpoints
  inc   [counter]
  
  add   si,size vector                 ;next point
  pop   cx
  loop  calc_pos
;---------------------------screen finished-----------------------------------
  
  mov   ah,0bh                         ;check if key
  int   21h
  cmp   al,0                           ;no?
  je    start                          ;start again
    
  mov   ah,07
  int   21h
  cmp   al,"="
  jne   trynext1
  inc   [speed]
  jmp   start
trynext1:
  cmp   al,"-"
  jne   trynext2
  dec   [speed]
  jmp   start
trynext2:
  cmp   al,"o"
  jne   trynext3
  mov   di,-1
  xor   bp,bp
  call  move
  jmp   start
trynext3:
  cmp   al,"p"
  jne   trynext4
  mov   di,1
  xor   bp,bp
  call  move
  jmp   start
trynext4:
  cmp   al,"a"
  jne   trynext5
  dec   x_offset
  jmp   start
trynext5:
  cmp   al,"d"
  jne   trynext6
  inc   x_offset
  jmp   start
trynext6:
  cmp   al,"w"
  jne   trynext7
  dec   y_offset
  jmp   start
trynext7:
  cmp   al,"x"
  jne   trynext8
  inc   y_offset
  jmp   start
trynext8:
  cmp   al,"s"
  jne   trynext9
  mov   [y_offset],100
  mov   [x_offset],160
  jmp   start
trynext9:
  cmp   al,"q"
  jne   stoptry
  call  sample_player
  jmp   start
stoptry:

  mov   ax,03h                         ;switch to 80x25 text mode
  int   10h
  
  call  stop_music
  call  end_sample
  call  end_music
  
  mov   ax,4c00h                       ;exit with zero
  int   21h
main   endp

init_sound_player   proc

  mov   ax,3d02h
  lea   dx,file_name
  int   21h
  mov   bx,ax
  mov   [handle],ax

  mov   ah,48h
  mov   bx,0fffh                       ;64K
  int   21h
  mov   [music_seg],ax

  mov   ah,3fh
  mov   bx,[handle]
  mov   cx,0ffffh
  push  ds
  mov   dx,[music_seg]
  mov   ds,dx
  mov   dx,100h                        ;load .com at offset 100h
  int   21h
  pop   ds

  ret
init_sound_player   endp

start_player   proc
        
        CALL    CONFIG_INIT             ;GET CONFIG
        MOV     AX,22222                ;SET MAXIMUM SAMPLERATE
        CALL    SET_SAMPLERATE
        MOV     AL,255                  ;SET MAXIMUM VOLUME
        MOV     BL,AL
        MOV     BH,AL
        CALL    SET_VOLUME

        MOV     DX,OFFSET MOD_NAME      ;FIRST, TRY LOADING
        CALL    LOAD_MOD
        
  mov   dx,offset sample_name                 
  mov   cl,80h                  ;pc sample
  call  load_sample
        
        CALL    PLAY_MUSIC              ;TRY STARTING
        ret
;-------------------------------function library------------------------------
CONFIG_INIT:
        MOV     BP,104H
        JMP     NEXT_STEP
LOAD_MOD:
        MOV     BP,108H
        JMP     NEXT_STEP
PLAY_MUSIC:
        MOV     BP,10CH
        JMP     NEXT_STEP
STOP_MUSIC:
        MOV     BP,110H
        JMP     NEXT_STEP
END_MUSIC:
        MOV     BP,114H
        JMP     NEXT_STEP
LOAD_SAMPLE:
        MOV     BP,118H
        JMP     NEXT_STEP
PLAY_SAMPLE:
        MOV     BP,11CH
        JMP     NEXT_STEP
END_SAMPLE:
        MOV     BP,120H
        JMP     NEXT_STEP
SET_SAMPLERATE:                         ;SB ONLY
        MOV     BP,124H
        JMP     NEXT_STEP
GET_VOLUME:
        MOV     BP,128H
        JMP     NEXT_STEP
SET_VOLUME:
        MOV     BP,12CH
        JMP     NEXT_STEP
SET_SONGLOOP:
        MOV     BP,130H
        JMP     NEXT_STEP
GET_SONGPOSITION:
        MOV     BP,134H
        JMP     NEXT_STEP
SET_SONGPOSITION:
        MOV     BP,138H
        JMP     NEXT_STEP
GET_SONGMOD:
        MOV     BP,13CH
        JMP     NEXT_STEP
SET_SONGMOD:
        MOV     BP,140H
        JMP     NEXT_STEP
DSP_OFF:
        MOV     BP,144H
        JMP     NEXT_STEP
DSP_RESET:
        MOV     BP,148H
        JMP     NEXT_STEP

NEXT_STEP:
        MOV     MUSIC_CALL,BP
        PUSHA
        PUSH    DS
        CALL    DWORD PTR DS:[MUSIC_CALL]
        POP     DS
        POPA
        RET
start_player   endp

random   proc
   mov   ax,[random_seed]
   mov   bx,8405h
   mul   bx
   inc   ax
   mov   [random_seed],ax
   ret
random   endp

sample_player   proc

  xor   bx,bx                   ;HANDLE
  mov   cx,22222                ;FREQUENCE
  call  play_sample
  ret
sample_player   endp

move   proc
  lea   si,points
  mov   cx,number_of_points
move_loop:  
  add   si,bp
  add   [si],di
  add   si,size vector
  loop  move_loop
  ret
einde   equ   $
move   endp

end main
