
#include "pump.h"

PRIVATE byte (*ctable)[256] = NULL;

PRIVATE byte FindNearestClr(sint32 tr, sint32 tg, sint32 tb) {
    int i, found_best = -1, found_best_dist = 0x7FFFFFFF;

    for (i = 0; i < 256; i++) {
        sint32 dist, x, y, z;
        x = tr - (((sint32) GL_Pal[i*3]) << 8);
        y = tg - (((sint32) GL_Pal[i*3+1]) << 8);
        z = tb - (((sint32) GL_Pal[i*3+2]) << 8);
        dist = x*x + y*y + 3*z*z;
        if (dist < found_best_dist) {
            found_best = i;
            found_best_dist = dist;
        }
    }
    if (found_best == -1) found_best = 0;
    return found_best;
}

#define TRUQUILLO
#define WEIGHT_NEW 1
#define WEIGHT_OLD 7

PRIVATE void InitCTable(void) {
    int i, j;

    if (ctable == NULL) {
        ctable = NEW(256*256);
        if (ctable == NULL)
            BASE_Abort("Alloc ctable");
    }
    if (JCLIB_Load("pal.mix", ctable, 256*256) < 256*256) {
        FILE *fd;
        for (i = 0; i < 256; i++) {
            for (j = 0; j < 256; j++) {
                sint32 tr, tg, tb;
                byte nearest;
                tr =
                    (
                        (
                                WEIGHT_NEW * (((uint32)GL_Pal[i*3]) << 8)
                            +   WEIGHT_OLD * (((uint32)GL_Pal[j*3]) << 8)
                        )
                    / (WEIGHT_NEW + WEIGHT_OLD)
                );
                tg =
                    (
                        (
                                WEIGHT_NEW * (((uint32)GL_Pal[i*3+1]) << 8)
                            +   WEIGHT_OLD * (((uint32)GL_Pal[j*3+1]) << 8)
                        )
                    / (WEIGHT_NEW + WEIGHT_OLD)
                );
                tb =
                    (
                        (
                                WEIGHT_NEW * (((uint32)GL_Pal[i*3+2]) << 8)
                            +   WEIGHT_OLD * (((uint32)GL_Pal[j*3+2]) << 8)
                        )
                    / (WEIGHT_NEW + WEIGHT_OLD)
                );
                nearest = FindNearestClr(tr, tg, tb);
#ifdef TRUQUILLO
                if (nearest == j)
                    nearest = i;
#endif
                ctable[i][j] = nearest;
            }
        }
        fd = fopen("pal.mix", "wb");
        if (!fd) {
            BASE_Abort("Create pal.mix");
        }
        if (fwrite(ctable, 1, 256*256, fd) != 256*256) {
            BASE_Abort("Write pal.mix");
        }
        fclose(fd);
    }
}

PRIVATE int start_scan = 0;

PRIVATE void DumpScr(void) {
    int i;
    byte *pScr = ((byte *)0xA0000) + (start_scan?320:0);

    for (i = start_scan; i < 200; i+=2) {
        memcpy(pScr, LLS_Screen[i], 320);
        pScr += 320*2;
    }
    start_scan ^= 1;
}

PRIVATE sint32 (*dtable)[256];

PUBLIC void InitDForm(void) {
    int i, j;
    DISPOSE(GL_WorkScreen);
    GL_WorkScreen = NEW(3*LLS_Size);
    if (GL_WorkScreen == NULL)
        BASE_Abort("Alloc 3 workscreen");

    for (i = 0; i < 3; i++) {
        char buf[100];
        sprintf(buf, "dflogo%d.pix", i+1);
        JCLIB_Load(buf, GL_WorkScreen + LLS_Size*i, LLS_Size);
    }

    InitCTable();

    dtable = NEW(sizeof(*dtable)*16);
    if (dtable == NULL)
        BASE_Abort("Alloc dtable");

    for (i = 0; i < 16; i++) {
        for (j = 0; j < 256; j++) {
            dtable[i][j] = FPMult(i, Cos(j*65536/256));
        }
    }
}


#define AI_INC 2
#define AJ_INC 2

PUBLIC void DoDForm(void) {
    int i, j, i2;
    byte *p;

    byte *varea;
    int ai = 0, aj = 0;
    int l, dl;
    bool leave = FALSE;
    int nf = 0;

    //outpw(0x3D4, 0x4009);  Ni probar esto!


    varea = NEW(512*256);
    if (varea == NULL)
        BASE_Abort("Alloc varea");
    memset(varea, 0, 512*256);
    VBL_ZeroPalette();


        VBL_DestPal = GL_Pal;
        VBL_FadeMode =  VBL_FADEFAST;
        VBL_FadeStartColor = 0;
        VBL_FadeNColors = 256;
        VBL_FadePos = 1;
        VBL_FadeSpeed = 1;

    VBL_VSync(0);
    for (i2 = 0; !leave && i2 < 3; i2++) {
        p = GL_WorkScreen + i2*LLS_Size;
        for (i = 0; i < 200; i++)
            memcpy(varea + i*512, p + i*320, 320);

        l = 15 << 8;
        dl = 0;
        nf = 0;
        while (!leave) {
            int ti, tj, d;
            int f;
            sint32 *pl;

            p = LLS_Screen[start_scan]; // GL_WorkScreen;
            ti = ai;
            pl = dtable + (l >> 8);

            if (LLK_SpacePressed != 0)
                leave = TRUE;

            for (i = start_scan; i < 200; i+=2) {
                tj = aj;
                d = 512*((i+pl[(ti&255)])&255);
                for (j = 0; j < 320; j++) {
                    byte b;
                    b = varea[d + ((j+pl[(tj&255)])&511)];
                    *p = ctable[b][*p];
                    p++;
                    tj++;
                }
                ti+=2;
                p+=320;
            }
            ai+=AI_INC;
            aj+=AJ_INC;
            //VGA_SetBorder(0, 0, 0);
            f = VBL_VSync(2);
            DumpScr();

            if (nf < 70 && (nf+f) >= 70) {
                dl = -(1 << 6);
            } else if (nf < 220 && (nf+f) >= 220) {
                dl = (1 << 6);
//            } else if (nf < 510 && (nf+f) >= 510 && i2 == 2) {
            } else if (nf < 360 && (nf+f) >= 360 && i2 == 2) {
                VBL_DestPal = NULL;
                VBL_FadeStartColor = 0;
                VBL_FadeNColors = 256;
                VBL_FadeMode =  VBL_FADEFAST;
                VBL_DestRed = VBL_DestGreen = VBL_DestBlue = 0;
                VBL_FadePos = 1;
                VBL_FadeSpeed = 1;
//            } else if (nf < 580 && (nf+f) >= 580) {
            } else if (nf < 430 && (nf+f) >= 430) {
                break;
            }
            l += f*dl;
            if (l < 0) {
                dl = 0;
                l = 0;
            } else if (l >= (15 << 8)) {
                dl = 0;
                l = 15 << 8;
            }
            nf += f;
            //VGA_SetBorder(63, 0, 0);
        }
    }
    DISPOSE(varea);
    DISPOSE(ctable);
    DISPOSE(dtable);

    DISPOSE(GL_WorkScreen);
    GL_WorkScreen = NEW(LLS_Size);
    if (GL_WorkScreen == NULL)
        BASE_Abort("Alloc 1 workscreen");

}