//
// Interfaz del engine Phong/EnvMapping, Yann/Iguana
//
#ifndef _PHONG_H_
#define _PHONG_H_

#include "types.h"

typedef int HANDLE;

HANDLE  PH_BuildObj(BYTE *file_like_buffer);
void    PH_DestroyObj(HANDLE h);
int     PH_StartEngine(void);
void    PH_EndEngine(void);
void    PH_DrawFrame(void);
void    PH_SetMode13BufferAdr(void *p);
void   *PH_GetMode13BufferAdr();
void    PH_XFormVertices(HANDLE h, UWORD theta, UWORD phi, WORD x, WORD y, WORD z);
void    PH_XFormNormals(HANDLE h, WORD theta, UWORD phi, WORD alpha);
void    PH_ActivateObj(HANDLE h, int active);

/*
Se usa as:

Inicio:
- Se cargan todos los objetos con BuildObj (se le pasa la dir. de un
  buffer donde estn los bytes como el .o3d
- Se llama a SetMode13BufferAdr
- Se llama a StartEngine
- El programa tiene que proveer una variable externa, env_map_adr, que
  apunte a un buffer de 65536 bytes con el environment map. Adems tiene
  que poner la paleta

Para cada frame:
- Se coloca cada objeto con las funciones X
- Se vaca el buffer
- Se llama a DrawFrame

Al final:
- Se llama a EndEngine
- Se llama a DestroyObj para cada objeto
*/

#endif
