// Image Plasma

#include "pump.h"

byte (*origin)[64000];               // Original Picture

void loadscreen(char *fname, byte *dest)
{
    JCLIB_Load(fname, dest, 64000);
}

void loadpalette (char *fname)
{
    JCLIB_Load(fname, GL_Pal, 768);
}

void degrade()
{
    int x, y, pos;
    byte *p;

    p = LLS_Screen[0];
    pos=320;
    for (x=0; x<320; x++) {
        for (y=1; y<199; y++) {
            *p++ =(GL_WorkScreen[pos+320] + GL_WorkScreen[pos-320] + GL_WorkScreen[pos+1] + GL_WorkScreen[pos-1]) >> 2;
            pos++;
         }
    }
}

void dumpscreen(int incx, int incy, byte *orig)
{
    int x,y,pos,dif;

    dif=incx+incy*320;
    pos=0;
    for (y=0;y<170; y++) {
      for (x=0;x<319; x++) {
        if (orig[pos]!=0)
            LLS_Screen[0][pos+dif]=orig[pos];
        pos++;
      }
    }
}

void DoPlasma(void) {
    int i,j;
    int f = 0;
    bool leave = FALSE;

    j=0;
    origin = NEW(4*64000);
    loadscreen("iguana.pix",origin[0]);
    loadscreen("party.pix",origin[1]);
    loadscreen("coding.pix",origin[2]);
    loadscreen("rulez.pix",origin[3]);
    loadpalette("iguana.pal");
    VBL_DumpPalette(GL_Pal, 0, 256);
    memset(LLS_Screen[0], 0, LLS_Size);
    memcpy(GL_WorkScreen, origin[0], 64000);
    while (!LLK_SpacePressed && !leave) {
      for (i=0; !leave && i < 5; i++) {
        if (DVTInfo != NULL && DVTInfo->semaphores[3]) {
            DVTInfo->semaphores[3]--;
            leave = TRUE;
        } else if (DVTInfo == NULL && f > 5*70)
            leave = TRUE;
        degrade();
        memcpy(GL_WorkScreen, LLS_Screen[0], 64000);
        LLS_Update();
        f += VBL_VSync(1);
      }

       if (j==3) j=-1;
       j++;
       dumpscreen(0,0,origin[j]);
       memcpy(GL_WorkScreen, LLS_Screen[0], 64000);
    }
    DISPOSE(origin);
}

