{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+}
UNIT Output;

   (* Copyright by Jare/Iguana in 1993, but given to the public domain. *)
   (* Want more comments? Write'em!                                     *)

   (*   Performs screen output functions tailor-made for this setup. I  *)
   (* don't see much of this unit reused for other programs, but anyway *)
   (* who knows?                                                        *)


INTERFACE

PROCEDURE InitScreen;

PROCEDURE EndScreen;

PROCEDURE DumpLine(s : STRING; col : BYTE; y : BYTE);

PROCEDURE DumpDevice(s : STRING);

PROCEDURE DumpLang(s : STRING);

PROCEDURE ClearArea;

PROCEDURE ClearScreen(VAR p); 

PROCEDURE DumpScreen(VAR p);

PROCEDURE SetScanStart(i : WORD);

PROCEDURE SplitOut;

PROCEDURE SplitIn;



TYPE
   TScr = ARRAY [1..25*8,1..80,0..1] OF BYTE;

VAR
   scr : TScr ABSOLUTE $B800:0;

CONST
   lens : ARRAY [1..13] OF INTEGER = (
      29,
{      46, 46, 46, 46,}
      29, 29, 29, 29,
      29, 29, 29, 29,
      29, 29, 29, 29
);

   defcol = 0*16+15;



   (* ========================================= *)

IMPLEMENTATION

USES Gfx;


PROCEDURE InitScreen;
  BEGIN
     ASM
        CLD
        PUSH ES
        MOV  AX,3
        INT  10h
        MOV  AX,SEG(scr)
        MOV  ES,AX
        MOV  CX,80*25*4
        XOR  DI,DI
        XOR  AX,AX
        REP STOSW
        POP  ES
     END;
  {   SetScrStart(80*25*2)}
  END;

PROCEDURE EndScreen;
  BEGIN
     ASM
        MOV  AX,3
        INT  10h
     END
  END;




PROCEDURE DumpLine(s : STRING; col : BYTE; y : BYTE);
  VAR
     i : BYTE;
     len : INTEGER;
  BEGIN
     IF (y >= 13) THEN EXIT;
     INC(y);
     IF (col = 0) THEN col := defcol;
     IF (Length(s) < lens[y]) THEN
        len := Length(s)
     ELSE
        len := lens[y];

     FOR i := 1 TO len DO BEGIN
         Scr[8+y, 8+16+i, 0] := BYTE(s[i]);
         Scr[8+y, 8+16+i, 1] := col
     END;
     IF len < Lens[y] THEN
        FOR i := len+1 TO Lens[y] DO BEGIN
           Scr[8+y, 8+16+i, 0] := 32;
           Scr[8+y, 8+16+i, 1] := col
        END;
  END;


PROCEDURE DumpDevice(s : STRING);
  VAR
     i, m : INTEGER;
  BEGIN
     i := 1;
     WHILE (i <= Length(s)) AND (s[i] = ' ') DO
       INC(i);
     m := i;
     FOR i := m TO Length(s) DO BEGIN
         Scr[25, i-m+5, 0] := BYTE(s[i]);
         Scr[25, i-m+5, 1] := 9
     END;
     IF Length(s) < 80 THEN
        FOR i := Length(s)+1 TO 73 DO BEGIN
           Scr[23, i-m+5, 0] := 32;
           Scr[23, i-m+5, 1] := 10
        END;
  END;

PROCEDURE DumpLang(s : STRING);
  VAR
     i, m : INTEGER;
  BEGIN
     i := 1;
     WHILE (i <= Length(s)) AND (s[i] = ' ') DO
       INC(i);
     m := i;
     FOR i := m TO Length(s) DO BEGIN
         Scr[22, i-m+5, 0] := BYTE(s[i]);
         Scr[22, i-m+5, 1] := 15
     END;
     IF Length(s) < 20 THEN
        FOR i := Length(s)+1 TO 20 DO BEGIN
           Scr[22, i-m+5, 0] := 32;
           Scr[22, i-m+5, 1] := 10
        END;
  END;


PROCEDURE ClearArea;
  VAR
     i,j : BYTE;
  BEGIN
     FOR i := 1 TO 13 DO
        FOR j := 1 TO lens[i] DO BEGIN
           Scr[8+i, 8+16+j, 0] := 32;
           Scr[8+i, 8+16+j, 1] := defcol
        END;
  END;


PROCEDURE ClearScreen(VAR p); ASSEMBLER;
  ASM
       CLD
       PUSH ES
       LES DI,p
       MOV CX,80*25
       XOR AX,AX
       REP STOSW
       POP ES
  END;


PROCEDURE DumpScreen(VAR p); ASSEMBLER;
  ASM
       CLD
       PUSH ES
       PUSH DS
       MOV AX,CS
       MOV DS,AX
       MOV SI,OFFSET @@scr
       LES DI,p
       MOV CX,80*25
       REP MOVSW
       POP DS
       POP ES
       JMP @@bye
     @@scr:
; (*----- File created with BIN2DB from file setup.bin. -----*)

 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,15,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,250,9,80,11,250,9,85,11,250,9,77,11
 DB 250,9,80,11,250,9,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,65,3,32,3,112,3,97,9,114,9,116,9,121,9,32,9
 DB 99,3,111,9,100,9,105,9,110,9,103,9,32,9,101,3,120,9,112,9
 DB 101,9,114,9,105,9,109,9,101,9,110,9,116,9,32,9,98,3,121,9
 DB 32,9,73,3,103,9,117,9,97,9,110,9,97,9,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
 DB 32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3,32,3
     @@bye:
  END;


PROCEDURE SetScanStart(i : WORD);
  VAR
     j : INTEGER;
  BEGIN
     WaitForDisplay;
     SetScrStart(((i DIV 16))*80);
     WaitForRetrace;
     PresetRowScan(i);
  END;


CONST
   wh : BOOLEAN = TRUE;
PROCEDURE SetSplitScan(s : INTEGER);
   VAR
      i : WORD;
   BEGIN
      IF wh THEN
         i := s
      ELSE
         i := {2*25*16-}s;
      SetScanStart(i);
      wh := NOT wh
   END;

VAR
   Poss  : ARRAY [1..100] OF WORD;
   NPoss : INTEGER;


PROCEDURE SplitOut;
  VAR
     i   : INTEGER;
  BEGIN
     DumpScreen(scr[26]);
     SetScanStart(25*16);
     ClearScreen(scr[1]);
     ClearScreen(scr[51]);

     FOR i := 1 TO NPoss DO
        SetSplitScan(Poss[i]);
  END;


PROCEDURE SplitIn;
  VAR
     i : INTEGER;
  BEGIN
     DumpScreen(scr[26]);
     ClearScreen(scr[1]);
     ClearScreen(scr[51]);
     FOR i := NPoss DOWNTO 1 DO
        SetSplitScan(Poss[i]);

     DumpScreen(scr[1]);
     SetScanStart(0);
     ClearScreen(scr[26])
  END;


VAR
   vel, i, n : INTEGER;

BEGIN
   n := 1;
   vel := 0;
   i := 25*16;
   REPEAT
      Poss[n] := i;
      i := i - vel DIV 5;
      vel := vel+1;
      INC(n);
   UNTIL i <= 0;
   NPoss := n-1;
END.

