{$M 4096,0,32768}
{$X+}

   (* Copyright by Jare/Iguana in 1993, but given to the public domain. *)
   (* Want more comments? Write'em!                                     *)

   (*   Main program. Does too many things not taken to separate units, *)
   (* but anyway it works.                                              *)

USES
   DOS,
   Devices, EMS, Menus, Output, Detections, Gfx, HexConversions, Reader, LibFile;

CONST
  MainFile='PUMP.EXE';
  VtoFileSpec='C:\PUMP.VTO';

VAR
   cfg : TCfg;
   RunForever : BOOLEAN;
   CLine:String;
   Port,DMA,IRQ,Freq:String[5];
   Ofs:String[20];
   Param:String[10];
   P:Char;
   Pags:Word;


CONST
   rateit : ARRAY [1..13] OF TMenuIt = (
         (Text: ' 8000       486/25        '  ; Val: 8000),
         (Text: '10000                    '  ; Val:10000),
         (Text: '12000                    '  ; Val:12000),
         (Text: '14000                    '  ; Val:14000),
         (Text: '16000                    '  ; Val:16000),
         (Text: '18000                    '  ; Val:18000),
         (Text: '20000                    '  ; Val:20000),
         (Text: '22000       486/50        '  ; Val:22000),
         (Text: '26000                    '  ; Val:26000),
         (Text: '32000                    '  ; Val:32000),
         (Text: '38000                    '  ; Val:38000),
         (Text: '44000  Pentium or higher  '  ; Val:44000),
         (Text: '  Accept previous selection' ; Val:$FFFF)
   );

Procedure ShowFreeMem;
Var Mem:Word;
Begin
  asm
    mov ah,48h
    mov bx,0ffffh
    int 21h
    mov Mem,bx
  end;
  Writeln('You have ', mem, ' paragraphs free.');
End;

PROCEDURE ChooseRate;
  VAR
     ch : WORD;
     i  : INTEGER;
  BEGIN
     IF (cfg.SoundDevice = NONE) OR (cfg.SoundDevice = GUS) THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 1 TO 13 DO
        AddItem(mm^, rateit[i], TRUE);
     ch := DoMenu(mm^, cfg.ReplayRate);
     IF ch <> $FFFF THEN
        cfg.ReplayRate := ch;
     ClearArea
  END;


CONST
   devit : ARRAY [1..9] OF TMenuIt = (
        (Text:' Stereo SoundBlaster 16 ASP'; Val:ORD(S_SB16ASP)),
        (Text:'  Mono SoundBlaster 16 ASP'  ; Val:ORD(M_SB16ASP)),
        (Text:'  Stereo SoundBlaster Pro'   ; Val:ORD(S_SBPRO)),
        (Text:'   Mono SoundBlaster Pro'     ; Val:ORD(M_SBPRO)),
        (Text:'    Plain SoundBlaster'        ; Val:ORD(SB)),
        (Text:'     Gravis Ultrasound'         ; Val:ORD(GUS)),
        (Text:'  PAS (SB emulation, sorry)' ; Val:ORD(PAS)),
        (Text:'         No Sound'                  ; Val:ORD(NONE)),
        (Text:'  Accept previous selection'; Val:$FFFF)
   );
PROCEDURE SelectDevice;
  CONST
     compareDevices: ARRAY [TDevices] OF BYTE = (
        0, 0, 0, 0, 0,
        1,
        0,
        2,
        255);
  VAR
     ch : WORD;
     i  : INTEGER;
  BEGIN
     ClearArea;
     ClearMenu(mm^);
     FOR i := 1 TO 9 DO
        AddItem(mm^, devit[i], TRUE);
     ch := DoMenu(mm^, ORD(cfg.SoundDevice));
     IF ch <> $FFFF THEN BEGIN
        IF (cfg.SoundDevice >= DEV_INVALID) OR
           (compareDevices[TDevices(ch)] <> compareDevices[cfg.SoundDevice]) THEN BEGIN
           cfg.SoundDevice := TDevices(ch);
           CASE compareDevices[TDevices(ch)] OF
              0: BEGIN
                    cfg.Port := $220;
                    cfg.IRQ  := 7;
                    cfg.DMA  := 1;
                    DetectSoundEnvironment(cfg)
                 END;
              1: BEGIN
                    cfg.Port := $240;
                    cfg.IRQ  := 11;
                    DetectSoundEnvironment(cfg)
                 END;
              2: BEGIN
                    cfg.Port := $3F8;
                    cfg.IRQ  := 4
                 END
           END
        END;
        cfg.SoundDevice := TDevices(ch);
     END;
     ClearArea
  END;


PROCEDURE SetPort;
  CONST
     silencePorts: ARRAY [1..4] OF TMenuIt = (
        (Text:'   3F8h (Serial Port COM1)'; Val:$3F8),
        (Text:'   2F8h (Serial Port COM2)'; Val:$2F8),
        (Text:'   3E8h (Serial Port COM3)'; Val:$3E8),
        (Text:'   2E8h (Serial Port COM4)'; Val:$2E8)
     );
  VAR
     portit: TMenuIt;
     ch : WORD;
     i  : INTEGER;
  BEGIN
     IF cfg.SoundDevice > NONE THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     IF cfg.SoundDevice = NONE THEN BEGIN
        FOR i := 1 TO 4 DO
           AddItem(mm^, silencePorts[i], TRUE);
        AddItem(mm^, rateit[13], TRUE)
     END ELSE BEGIN
        FOR i := 1 TO 12 DO BEGIN
           portit.Text := '      Port number 2'+HexByte((i-1)*16)+'h';
           portit.Val  := (i-1)*16 + $200;
           AddItem(mm^, portit, TRUE);
        END;
        AddItem(mm^, rateit[13], TRUE)
     END;
     ch := DoMenu(mm^, cfg.Port);
     IF ch <> $FFFF THEN BEGIN
        cfg.Port := ch;
        IF cfg.SoundDevice = NONE THEN
           IF cfg.Port = $3F8 THEN
              cfg.IRQ := 4
           ELSE IF cfg.Port = $2F8 THEN
              cfg.IRQ := 3
     END;
     ClearArea;
  END;


PROCEDURE SetIRQ;
  VAR
     irqit : TMenuIt;
     ch    : WORD;
     i     : INTEGER;
     s     : STRING;
  BEGIN
     IF cfg.SoundDevice > NONE THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 2 TO 15 DO
        IF (i <> 6) AND (i <> 9) THEN BEGIN
           Str(i : 2, s);
           irqit.Text := '        IRQ number '+s;
           irqit.Val  := i;
           AddItem(mm^, irqit, TRUE)
        END;
     AddItem(mm^, rateit[13], TRUE);
     ch := DoMenu(mm^, cfg.IRQ);
     IF ch <> $FFFF THEN
        cfg.IRQ := ch;
     ClearArea;
  END;

PROCEDURE SetDMA;
  VAR
     dmait : TMenuIt;
     ch    : WORD;
     i     : INTEGER;
     s     : STRING;
  BEGIN
     IF (cfg.SoundDevice >= NONE) OR (cfg.SoundDevice = GUS) THEN
        EXIT;
     ClearArea;
     ClearMenu(mm^);
     FOR i := 0 TO 7 DO
        IF (i <> 2) AND (i <> 4) THEN BEGIN
           Str(i : 2, s);
           dmait.Text := '       DMA channel '+s;
           dmait.Val  := i;
           AddItem(mm^, dmait, TRUE)
        END;
     AddItem(mm^, rateit[13], TRUE);
     ch := DoMenu(mm^, cfg.DMA);
     IF ch <> $FFFF THEN
        cfg.DMA := ch;
     ClearArea;
  END;

FUNCTION Cfg2Text: STRING;
  VAR
     s1, s2 : STRING;
  BEGIN
     s1 := {'Device: '+}devit[ORD(cfg.SoundDevice)+1].Text;
     IF cfg.SoundDevice <> NONE THEN BEGIN
        s1 := s1;
        IF cfg.SoundDevice <> GUS THEN BEGIN
           Str(cfg.ReplayRate, s2);
           s1 := s1 + ', Rate = ' + s2
        END;
        s1 := s1 + ', Port ' + HexWord(cfg.Port) + 'h, IRQ ';
        Str(cfg.IRQ, s2);
        s1 := s1 + s2;
        IF cfg.SoundDevice <> GUS THEN BEGIN
           Str(cfg.DMA, s2);
           s1 := s1 + ', DMA ' + s2
        END
     END ELSE BEGIN
        IF (cfg.Port = $3F8) AND (cfg.IRQ = 4) THEN
           s1 := s1 + ' (COM1)'
        ELSE IF (cfg.Port = $3F8) AND (cfg.IRQ = 4) THEN
           s1 := s1 + ' (COM1)'
        ELSE IF (cfg.Port = $2F8) AND (cfg.IRQ = 3) THEN
           s1 := s1 + ' (COM2)'
        ELSE IF (cfg.Port = $3E8) AND (cfg.IRQ = 4) THEN
           s1 := s1 + ' (COM3)'
        ELSE IF (cfg.Port = $2E8) AND (cfg.IRQ = 3) THEN
           s1 := s1 + ' (COM4)'
        ELSE BEGIN
           s1 := s1 + ', Serial Port ' + HexWord(cfg.Port) + 'h, IRQ ';
           Str(cfg.IRQ, s2);
           s1 := s1 + s2
        END
     END;
     Cfg2Text := s1
  END;


CONST
   mainit : ARRAY [1..8] OF TMenuIt = (
         (Text:'        Run the demo'; Val:0),
         (Text:'    Select sound device'; Val:1),
         (Text:'    Choose sampling rate'; Val:2),
         (Text:'      Set port number'; Val:3),
         (Text:'          Set IRQ'; Val:4),
         (Text:'      Set DMA channel'; Val:5),
         (Text:'     Notes of interest'; Val:6),
         (Text:'        Exit to DOS'; Val:$FFFF)
   );
PROCEDURE MainMenu;
  VAR
     ch : WORD;
     i  : INTEGER;
     uopts : ARRAY [1..8] OF BOOLEAN;
  BEGIN
     ch := 0;
     FOR i := 1 TO 8 DO
       uopts[i] := TRUE;
     IF cfg.SoundDevice = DEV_INVALID THEN BEGIN
        cfg.SoundDevice := NONE;
        SelectDevice;
        IF cfg.SoundDevice <> NONE THEN BEGIN
           IF cfg.SoundDevice = GUS THEN BEGIN
              cfg.DMA  :=   1;  {Not used}
              cfg.IRQ  :=   7;
              cfg.Port := $220;
              cfg.ReplayRate := 44000; {WOW!}
           END ELSE BEGIN
              cfg.DMA  :=    1;  {Not used}
              cfg.IRQ  :=    7;
              cfg.Port := $220;
              cfg.ReplayRate := 16000; {WOW!}
           END;
           ChooseRate;
           SetPort;
           SetIRQ;
           SetDMA;
        END
     END;
     REPEAT
        DumpDevice(CFG2Text);
        ClearMenu(mm^);
        uopts[3] := NOT((cfg.SoundDevice = NONE) OR (cfg.SoundDevice = GUS));
        uopts[6] := NOT((cfg.SoundDevice = NONE) OR (cfg.SoundDevice = GUS));
        FOR i := 1 TO 8 DO
           AddItem(mm^, mainit[i], uopts[i]);
        ch := DoMenu(mm^, ch);
        CASE ch OF
           0 : RunForever := FALSE;
           1 : SelectDevice;
           2 : ChooseRate;
           3 : SetPort;
           4 : SetIRQ;
           5 : SetDMA;
           6 : ReadText;
           $FFFF : BEGIN EndScreen; HALT(1); END;
        END;
     UNTIL (ch = 0) OR (ch = 7);
  END;



TYPE
TS = ARRAY[1..4000] OF BYTE;
VAR
SSS : TS ABSOLUTE $B800:0;
f   : FILE OF TS;
VAR
   fcfg : FILE OF TCfg;
   fvto : TEXT;
   i, j : INTEGER;
   s    : STRING;

CONST
   VTDevs : ARRAY [TDevices] OF STRING = (
         'DMA-SB-Stereo',
         'DMA-SB-Mono',
         'DMA-SB-Stereo',
         'DMA-SB-Mono',
         'DMA-SB-Mono',
         'GUS',
         'DMA-SB-Mono',
         'Silence',
         'Silence'    (* If you don't know which card, then no card. *)
   );

BEGIN
   {ShowFreeMem;}
   CheckFilesOK;
   cfg.SoundDevice := DEV_INVALID;
   cfg.ReplayRate  := 16000;
   cfg.IRQ  := 7;  (* Something to use as default values. *)
   cfg.DMA  := 1;
   cfg.Port := $220;
   cfg.visco:= 2;
   DetectSoundEnvironment(cfg);

   i := IOResult;

   IF NOT IsVGA THEN BEGIN
      WriteLn(#13'                                              ');
      WriteLn('I think you don''t have the required VGA card.');
      Write(' Continue anyway? (y/N) ');
      IF UpCase(CHAR(GetKey)) <> 'Y' THEN BEGIN
         WriteLn;
         WriteLn('Go buy a cool ET-4000 or something like that.');
         HALT(1)
      END
    End;

    IF NOT Is386 THEN BEGIN
       WriteLn(#13'                                              ');
       WriteLn('I can''t find a 386SX or higher in your machine. I need one.');
       Write(' Continue anyway? (y/N) ');
       IF UpCase(CHAR(GetKey)) <> 'Y' THEN BEGIN
          WriteLn;
          WriteLn('Have a sad DOS (without a 386 it sure will be).');
          HALT(1)
       END
    END;

    ASM
      MOV  AX,3
      INT  10h
    END;


    InitScreen;
    SplitIn;


    asm
      mov dx,03d4h
      mov al,0ah
      out dx,al
      inc dx
      in al,dx
      and al,224
      or al,20h
      out dx,al
    end;

    MainMenu;
    SplitOut;
    EndScreen;
    asm
      mov dx,03d4h
      mov al,0ah
      out dx,al
      inc dx
      in al,dx
      and al,224
      or al,20h
      out dx,al
    end;


      IF ((cfg.SoundDevice = NONE) AND HasMouse) (*OR IsProtMode*) THEN BEGIN

         IF IsProtMode THEN BEGIN
            WriteLn('You are running in protected mode (EMM386, QEMM, Windows, OS/2, DesqView).'#13#10,
                    'If the demo runs slow or flickers, try booting with a clean MSDOS.'#13#10);
         END;

         IF (cfg.SoundDevice = NONE) AND HasMouse THEN BEGIN
            WriteLn('You have selected silent mode, but your mouse driver may cause conflicts.');
            WriteLn('If you experience any problems, try changing the COM port and IRQ.');
         END;
         Write(' Press any key to continue');
         GetKey;
         WriteLn(#13'                                              ');
      END;

   If (cfg.SoundDevice<>GUS) then Begin
     If not EMM_Installed then Begin
        Writeln('You need to have at least 512 Kb EMS memory');
        Halt(1);
     End;
     asm
       mov pags,0
       mov ah,42h
       int 67h
       mov pags,bx
     end;
     If LongInt(pags*16)<512 then Begin
        Writeln('You need to have at least 512 Kb EMS memory');
        Halt(1);
     End;
   End;
   Str(cfg.Port,Port);
   Str(cfg.IRQ,IRQ);
   Str(cfg.DMA,DMA);
   Str(cfg.ReplayRate,Freq);

   Cline:=' /nb /v:127 /port:'+Port+' /irq:'+IRQ;
   IF NOT (cfg.SoundDevice IN [NONE, GUS]) THEN BEGIN
      Cline:=Cline+' /dma:'+DMA+' /d:'+VTDevs[cfg.SoundDevice]+' /f:'+Freq;
   END ELSE
      Cline:=Cline+' /d:'+VTDevs[cfg.SoundDevice];

   Str(LF_FindFile('THE_SIGN.S3M')^.offs,ofs);
   CLine:=' '+MainFile+' '+CLine+' /off:'+ofs+' /sh:PUMP.DAT ';
   (* Escribir VTO *)
   Assign(fvto, VtoFileSpec);
   Rewrite(fvto);
   Write(fvto, CLine);
   Close(fvto)
END.

