
#include "pump.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <vga.h>
#include <sincos.h>
#include <llkey.h>
#include <jclib.h>
#include <cspline.h>
#include <vbl.h>
#include "types.h"
#include "phong.h"

#define TRACE(r,g,b) do { if (tracing) VGA_PutColor(0,r,g,b); } while(0)

PRIVATE CSP_PSpline spl_x, spl_y, spl_z, spl_rot, spl_tumble;
PRIVATE double t;           // Tiempo
void *env_map_adr;
int tracing = 0;

static void *envpix, *envpal, *o3d, *virtscr;

void DumpScr(void) {
#if 0
    int i;
    byte *p = (byte *)0xA0000;
    byte *q = virtscr;

    for (i = 0; i < 200; i+=2) {
        memcpy(p, q, 320);
        p += 640;
        q += 640;
    }
#else
    memcpy((void *)0xA0000, virtscr, 64000);
#endif
}

PRIVATE UWORD rot = 0;
PRIVATE WORD z = 512, x = 0, y = 0;
PRIVATE UWORD tumble = 0x2000;
static double t = 0;

#define FLUSH()  (*(WORD *)(0x41A) = *(WORD *)(0x41c))

#define SPL_DO(var) \
    do { \
        seg = CSP_FindSegment(spl_##var, t); \
        var = CSP_Interpolate(spl_##var->pts + seg, t); \
    } while (0)

PRIVATE int sign = 1;

void Advance(void) {
    int seg;

    SPL_DO(x);
    SPL_DO(y);
    SPL_DO(z);
    SPL_DO(rot);
    SPL_DO(tumble);
    z = z + 256;
    x = sign*x;
    if (sign < 0)
        rot = 32768-rot;

/*
    if (LLK_Keys[kKEYPADPLUS]) {
        z += 0x10;
    }
    if (LLK_Keys[kKEYPADMINUS]) {
        z -= 0x10;
    }
    if (LLK_Keys[kKEYPADSTAR]) {
        theta += 0x10;
    }
    if (LLK_Keys[kKEYPADSLASH]) {
        theta -= 0x10;
    }
    if (LLK_Keys[kKEYPAD4]) {
        x -= 0x10;
    }
    if (LLK_Keys[kKEYPAD6]) {
        x += 0x10;
    }
    if (LLK_Keys[kHOME]) {
        tumble -= 0x100;
    }
    if (LLK_Keys[kEND]) {
        tumble += 0x100;
    }
    if (LLK_Keys[kKEYPAD8]) {
        y -= 0x10;
    }
    if (LLK_Keys[kKEYPAD2]) {
        y += 0x10;
    }
    if (LLK_Keys[kKEYPAD5]) {
        while (LLK_kbhit())
            ;
        VGA_SetMode(3);
        printf("x: %d, y: %d, z: %d\n"
               "rot: %d, theta: %d\n"
               "press any key",
               (int)x, (int)y, (int)z, (int)rot, (int)theta);
        LLK_PressAnyKey();
        VGA_SetMode(0x13);
        VGA_DumpPalette(envpal, 0, 256);
    }
    if (LLK_Keys[k4]) {
        theta = 16288;
    }
    if (LLK_Keys[k3]) {
        theta = 21760;
    }
    if (LLK_Keys[k2]) {
        theta = 32788;
    }
    if (LLK_Keys[k1]) {
        theta = 0;
    }
    if (LLK_Keys[kT]) {
        tracing ^= 1;
        LLK_Keys[kT] = 0;
        LLK_NumKeys--;
    }
    if (LLK_Keys[kS]) {
        see_side ^= 1;
        LLK_Keys[kS] = 0;
        LLK_NumKeys--;
    }
    if (LLK_Keys[kA]) {
        which_side += 0x200;
    }
    if (LLK_Keys[kD]) {
        which_side -= 0x200;
    }
    if (LLK_NumKeys) {
        FLUSH();
    }
    rot += theta;
*/
}

TPH_Do(HANDLE obj) {

    Advance();
    while (!LLK_SpacePressed) {
        int nt;
                TRACE(32,0,0);
        memset(virtscr, 0, 64000);              // Borrar fondo
                TRACE(0,32,0);
        PH_XFormVertices(obj, rot, tumble, x, y, z);    // Girar vrtices
                TRACE(0,0,32);
        PH_XFormNormals(obj, rot, -tumble, 0x8000);      // Girar normales
                TRACE(32,32,0);
        PH_DrawFrame();                         // Dibujar
                TRACE(0,0,0);
        nt = VBL_VSync(2);                     // Esperamos para volcar
        if (t < 630 && (nt+t) >= 630)
            break;
        t += nt;
                TRACE(32,0,32);
        DumpScr();
                TRACE(0,0,0);
        Advance();
        if (LLK_Keys[kT]) {
            tracing ^= 1;
            LLK_Keys[kT] = 0;
            LLK_NumKeys--;
        }
    }
    FLUSH();
}

CSP_PSpline LoadSpline(char *fname) {
    FILE *fd;
    char buf[256];
    int i, n;
    CSP_PSpline spline;

    fd = JCLIB_OpenText(fname);
    if (!fd)
        return NULL;
    fgets(buf, 256, fd);
    n = atoi(buf);
    if (n <= 0)
        return NULL;
    spline = NEW(CSP_Size(n));
    if (!spline)
        return NULL;
    memset(spline, 0, CSP_Size(n));
    spline->npts = n;

    i = 0;
    for (;;) {
        fgets(buf, 256, fd);
        while (strlen(buf) && isspace(buf[strlen(buf)-1])) {
            buf[strlen(buf)-1] = '\0';
        }
        if (!strcmp(buf, "EOF"))
            break;
        if (!strlen(buf))
            continue;
        spline->pts[i].f = atof(buf);
        fgets(buf, 256, fd);
        while (strlen(buf) && isspace(buf[strlen(buf)-1])) {
            buf[strlen(buf)-1] = '\0';
        }
        spline->pts[i].t = atof(buf);
        i++;
    }
    JCLIB_Close(fd);
    if (i != n) {
        DISPOSE(spline);
        return NULL;
    }
    return spline;
}

PUBLIC int DoPhong(void) {
    HANDLE obj, ob2;

    memset(LLS_Screen[0], 0, LLS_Size);
    LLS_Update();

    spl_x = LoadSpline("x.spl");
    spl_y = LoadSpline("y.spl");
    spl_z = LoadSpline("z.spl");
    spl_rot = LoadSpline("rot.spl");
    spl_tumble = LoadSpline("tumble.spl");
    if (!spl_x || !spl_y || !spl_z || !spl_rot || !spl_tumble) {
        BASE_Abort("Load Splines");
    }
    CSP_CalcSpline(spl_x);
    CSP_CalcSpline(spl_y);
    CSP_CalcSpline(spl_z);
    CSP_CalcSpline(spl_rot);
    CSP_CalcSpline(spl_tumble);

    // Carga el environment map
    envpix = fload("envmap.pix");
    envpal = fload("envmap.pal");
    if (!envpix || !envpal) {
        puts("Cannot find envmap.pix | envmap.pal");
        return -1;
    }
    env_map_adr = envpix;

    // Carga el objeto
    o3d = fload("test.o3d");
    if (!o3d) {
        puts("Cannot find o3d file");
        return -1;
    }
    obj = PH_BuildObj(o3d);
    if (!obj) {
        puts("Not enough mem to build object in mem");
        return -1;
    }
    free(o3d);

    // Carga el objeto
    o3d = fload("face.o3d");
    if (!o3d) {
        puts("Cannot find o3d file");
        return -1;
    }
    ob2 = PH_BuildObj(o3d);
    if (!ob2) {
        puts("Not enough mem to build object in mem");
        return -1;
    }
    free(o3d);

    // Virtual screen
    virtscr = LLS_Screen[0];
    PH_SetMode13BufferAdr(virtscr);

    // Init-ea las distintas cosas
    if (!PH_StartEngine()) {
        puts("not enough mem for triangle tables!");
        return -1;
    }

    while (!LLK_SpacePressed && DVTInfo != NULL && !DVTInfo->semaphores[3]);


    VBL_FadeSpeed = VBL_FadePos = 0;
    VBL_DumpPalette(envpal, 0, 256);
    VBL_VSync(0);
    PH_ActivateObj(ob2, 0);
    TPH_Do(obj);
    PH_ActivateObj(ob2, 1);
    PH_ActivateObj(obj, 0);
    sign = -1;
    t = 0;
    TPH_Do(ob2);

    PH_DestroyObj(obj);
    PH_DestroyObj(ob2);
    PH_EndEngine();

    free(envpix);
    free(envpal);
    return 0;
}
